/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.zip.ZipInputStream;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public class BufferInput
extends InputStream {
    private final byte[] cache = new byte[4];
    protected final byte[] buffer;
    protected int pos;
    protected int size;
    private InputStream in;
    private String enc = "UTF-8";
    private CharsetDecoder csd;
    private long length;
    private int read;
    private int mark;

    public BufferInput(File file) throws IOException {
        this(new FileInputStream(file));
        this.length = file.length();
    }

    public BufferInput(InputStream is) {
        this(is, 4096);
    }

    public BufferInput(InputStream is, int bs) {
        this.buffer = new byte[bs];
        this.in = is;
    }

    protected BufferInput(byte[] buf) {
        this.buffer = buf;
        this.size = buf.length;
        this.length = this.size;
    }

    public final String encoding() throws IOException {
        byte d;
        if (this.size <= 0) {
            this.size = this.in.read(this.buffer);
        }
        byte a = this.size > 0 ? this.buffer[0] : (byte)0;
        byte b = this.size > 1 ? this.buffer[1] : (byte)0;
        byte c = this.size > 2 ? this.buffer[2] : (byte)0;
        byte by = d = this.size > 3 ? this.buffer[3] : (byte)0;
        if (a == -1 && b == -2 || a == 60 && b == 0 && c == 63 && d == 0) {
            this.enc = "UTF-16LE";
            if (a == -1) {
                this.pos = 2;
            }
        } else if (a == -2 && b == -1 || a == 0 && b == 60 && c == 0 && d == 63) {
            this.enc = "UTF-16BE";
            if (a == -2) {
                this.pos = 2;
            }
        } else if (a == -17 && b == -69 && c == -65) {
            this.pos = 3;
        }
        return this.enc;
    }

    public final void encoding(String encoding) throws IOException {
        try {
            this.enc = Token.normEncoding(encoding, this.enc);
            this.csd = Charset.forName(encoding).newDecoder();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.size) {
            if (this.size <= 0 || this.size >= this.buffer.length) {
                this.size = 0;
                this.pos = 0;
            }
            int r = -1;
            while ((r = this.in.read(this.buffer, this.size, this.buffer.length - this.size)) <= 0) {
                if (r >= 0) continue;
                return -1;
            }
            this.size += r;
            this.read += r;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public final String readString() throws IOException {
        return this.bytes().toString();
    }

    public final byte[] readBytes() throws IOException {
        return this.bytes().toArray();
    }

    public final int readChar() throws IOException {
        int ch = this.read();
        if (ch == -1) {
            return ch;
        }
        if (this.enc == "UTF-16LE") {
            return ch | this.read() << 8;
        }
        if (this.enc == "UTF-16BE") {
            return ch << 8 | this.read();
        }
        if (ch < 128) {
            return ch;
        }
        if (this.enc == "UTF-8") {
            int cl = Token.cl((byte)ch);
            this.cache[0] = (byte)ch;
            int c = 1;
            while (c < cl) {
                this.cache[c] = (byte)this.read();
                ++c;
            }
            return Token.cp(this.cache, 0);
        }
        int p = 0;
        if (p == 4) {
            return -this.cache[0];
        }
        this.cache[p++] = (byte)ch;
        try {
            CharBuffer cb = this.csd.decode(ByteBuffer.wrap(Arrays.copyOf(this.cache, p)));
            int i = 0;
            int c = 0;
            while (c < cb.limit()) {
                i |= cb.get(c) << (c << 3);
                ++c;
            }
            return i;
        }
        catch (CharacterCodingException ex) {
            return ch;
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.in != null && !(this.in instanceof ZipInputStream)) {
            this.in.close();
        }
    }

    public final int size() {
        return this.read + this.pos;
    }

    public final long length() {
        return this.length;
    }

    public final void length(long l) {
        this.length = l;
    }

    @Override
    public final boolean markSupported() {
        return this.read <= this.buffer.length;
    }

    @Override
    public synchronized void mark(int m) {
        this.mark = this.pos;
    }

    @Override
    public final synchronized void reset() {
        this.size = this.read;
        this.pos = this.mark;
    }

    private ByteList bytes() throws IOException {
        int l;
        ByteList bl = new ByteList();
        while ((l = this.read()) > 0) {
            bl.add(l);
        }
        return bl;
    }
}

