/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.IO;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class TextInput {
    private BufferInput[] in = new BufferInput[1];
    private int ip;
    private final IO file;
    private int line = 1;
    private final int[] last = new int[16];
    private int lp;
    private int pp;

    public TextInput(IO f) throws IOException {
        this.in[0] = f.buffer();
        this.in[0].encoding();
        this.file = f;
    }

    public static TokenBuilder content(IO in) throws IOException {
        return TextInput.content(in, null);
    }

    public static TokenBuilder content(IO in, String enc) throws IOException {
        TokenBuilder tb = new TokenBuilder();
        TextInput ti = new TextInput(in);
        try {
            int ch;
            if (enc != null) {
                ti.encoding(enc);
            }
            while ((ch = ti.next()) != -1) {
                if (ch == 13) {
                    if (ti.next() != 10) {
                        ti.prev(1);
                    }
                    ch = 10;
                }
                tb.add(ch);
            }
        }
        finally {
            ti.close();
        }
        return tb;
    }

    public void encoding(String e) throws IOException {
        this.in[0].encoding(e);
    }

    public IO io() {
        return this.file;
    }

    public void prev(int p) {
        this.pp -= p;
        this.pos();
    }

    public int next() throws IOException {
        if (this.pp != 0) {
            return this.last[this.lp + this.pp++ & 0xF];
        }
        int ch = this.in[this.ip].readChar();
        while (ch == -1 && this.ip != 0) {
            ch = this.in[--this.ip].readChar();
        }
        this.last[this.lp++] = ch;
        this.lp &= 0xF;
        if (this.ip == 0 && ch == 10) {
            ++this.line;
        }
        return ch;
    }

    public boolean add(byte[] val, boolean s) throws IOException {
        if (s) {
            this.add(new ArrayInput(Token.SPACE));
        }
        this.add(new ArrayInput(val));
        if (s) {
            this.add(new ArrayInput(Token.SPACE));
        }
        return this.ip < 32;
    }

    private void add(ArrayInput ci) throws IOException {
        if (++this.ip == this.in.length) {
            this.in = Arrays.copyOf(this.in, this.ip << 1);
        }
        this.in[this.ip] = ci;
        ci.encoding();
    }

    public void close() throws IOException {
        this.in[0].close();
    }

    public int pos() {
        return Math.max(0, this.in[0].size() + this.pp);
    }

    public int line() {
        return this.line;
    }

    public long length() {
        return this.in[0].length();
    }
}

