/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public class HTMLSerializer
extends OutputSerializer {
    private static final TokenList SCRIPTS = new TokenList();
    private static final TokenSet BOOLEAN = new TokenSet();

    static {
        SCRIPTS.add(Token.token("script"));
        SCRIPTS.add(Token.token("style"));
        BOOLEAN.add(Token.token("area:nohref"));
        BOOLEAN.add(Token.token("button:disabled"));
        BOOLEAN.add(Token.token("dir:compact"));
        BOOLEAN.add(Token.token("dl:compact"));
        BOOLEAN.add(Token.token("frame:noresize"));
        BOOLEAN.add(Token.token("hr:noshade"));
        BOOLEAN.add(Token.token("img:ismap"));
        BOOLEAN.add(Token.token("input:checked"));
        BOOLEAN.add(Token.token("input:disabled"));
        BOOLEAN.add(Token.token("input:readonly"));
        BOOLEAN.add(Token.token("menu:compact"));
        BOOLEAN.add(Token.token("object:declare"));
        BOOLEAN.add(Token.token("ol:compact"));
        BOOLEAN.add(Token.token("optgroup:disabled"));
        BOOLEAN.add(Token.token("option:selected"));
        BOOLEAN.add(Token.token("option:disabled"));
        BOOLEAN.add(Token.token("script:defer"));
        BOOLEAN.add(Token.token("select:multiple"));
        BOOLEAN.add(Token.token("select:disabled"));
        BOOLEAN.add(Token.token("td:nowrap"));
        BOOLEAN.add(Token.token("textarea:disabled"));
        BOOLEAN.add(Token.token("textarea:readonly"));
        BOOLEAN.add(Token.token("th:nowrap"));
        BOOLEAN.add(Token.token("ul:compact"));
    }

    HTMLSerializer(OutputStream os, SerializerProp p) throws IOException {
        super(os, p, "4.0", "4.01");
    }

    @Override
    public void attribute(byte[] n, byte[] v) throws IOException {
        byte[] tagatt = Token.concat(Token.lc(this.tag), Token.COLON, Token.lc(n));
        if (BOOLEAN.id(tagatt) != 0 && Token.eq(n, v)) {
            return;
        }
        byte[] val = this.escape && URIS.id(tagatt) != 0 ? Token.escape(v) : v;
        this.print(32);
        this.print(n);
        this.print(DataText.ATT1);
        int k = 0;
        while (k < val.length) {
            int ch = Token.cp(val, k);
            if (ch == 60 || ch == 38 && val[Math.min(k + 1, val.length - 1)] == 123) {
                this.print(ch);
            } else if (ch == 34) {
                this.print(DataText.E_QU);
            } else if (ch == 9 || ch == 10) {
                this.hex(ch);
            } else {
                this.code(ch);
            }
            k += Token.cl(val, k);
        }
        this.print(DataText.ATT2);
    }

    @Override
    public void finishComment(byte[] n) throws IOException {
        if (this.ind) {
            this.indent();
        }
        this.print(DataText.COMM_O);
        this.print(n);
        this.print(DataText.COMM_C);
    }

    @Override
    public void finishPi(byte[] n, byte[] v) throws IOException {
        if (this.ind) {
            this.indent();
        }
        if (Token.contains(v, 62)) {
            Err.SERPI.thrwSerial(new Object[0]);
        }
        this.print(DataText.PI_O);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(DataText.ELEM_C);
    }

    @Override
    protected void code(int ch) throws IOException {
        if (this.script) {
            this.printChar(ch);
        } else if (ch > 127 && ch < 160) {
            Err.SERILL.thrwSerial(Integer.toHexString(ch));
        } else if (ch == 160) {
            this.print(DataText.E_NBSP);
        } else {
            super.code(ch);
        }
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        this.doctype(null);
        if (this.ind) {
            this.indent();
        }
        this.print(DataText.ELEM_O);
        this.print(t);
        this.ind = this.indent;
        this.script = SCRIPTS.contains(Token.lc(t));
        if (this.content && Token.eq(Token.lc(this.tag), DataText.HEAD)) {
            ++this.ct;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        if (this.ct(false, true)) {
            return;
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        if (this.ct(true, true)) {
            return;
        }
        this.print(DataText.ELEM_C);
        if (EMPTIES.contains(Token.lc(this.tag))) {
            return;
        }
        this.ind = false;
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        super.finishClose();
        this.script &= !SCRIPTS.contains(Token.lc(this.tag));
    }
}

