/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.basex.core.Prop;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public abstract class OutputSerializer
extends Serializer {
    protected static final TokenList EMPTIES = new TokenList();
    protected static final TokenSet URIS = new TokenSet();
    protected String docsys;
    protected String docpub;
    protected int ct;
    protected boolean ind;
    protected boolean item;
    protected boolean script;
    protected final boolean escape;
    protected final TokenList cdata = new TokenList();
    protected final boolean indent;
    protected final boolean content;
    protected final String media;
    protected final Charset encoding;
    protected final byte[] nl;
    protected final PrintOutput out;
    private final boolean utf8;
    protected final int indents;
    protected final char tab;
    private final boolean format;
    private final byte[] wUri;
    private final byte[] wPre;
    private final boolean wrap;

    static {
        EMPTIES.add(Token.token("area"));
        EMPTIES.add(Token.token("base"));
        EMPTIES.add(Token.token("br"));
        EMPTIES.add(Token.token("col"));
        EMPTIES.add(Token.token("hr"));
        EMPTIES.add(Token.token("img"));
        EMPTIES.add(Token.token("input"));
        EMPTIES.add(Token.token("link"));
        EMPTIES.add(Token.token("meta"));
        EMPTIES.add(Token.token("basefont"));
        EMPTIES.add(Token.token("frame"));
        EMPTIES.add(Token.token("isindex"));
        EMPTIES.add(Token.token("param"));
        URIS.add(Token.token("a:href"));
        URIS.add(Token.token("a:name"));
        URIS.add(Token.token("applet:codebase"));
        URIS.add(Token.token("area:href"));
        URIS.add(Token.token("base:href"));
        URIS.add(Token.token("blockquote:cite"));
        URIS.add(Token.token("body:background"));
        URIS.add(Token.token("button:datasrc"));
        URIS.add(Token.token("del:cite"));
        URIS.add(Token.token("div:datasrc"));
        URIS.add(Token.token("form:action"));
        URIS.add(Token.token("frame:longdesc"));
        URIS.add(Token.token("frame:src"));
        URIS.add(Token.token("head:profile"));
        URIS.add(Token.token("iframe:longdesc"));
        URIS.add(Token.token("iframe:src"));
        URIS.add(Token.token("img:longdesc"));
        URIS.add(Token.token("img:src"));
        URIS.add(Token.token("img:usemap"));
        URIS.add(Token.token("input:datasrc"));
        URIS.add(Token.token("input:src"));
        URIS.add(Token.token("input:usemap"));
        URIS.add(Token.token("ins:cite"));
        URIS.add(Token.token("link:href"));
        URIS.add(Token.token("object:archive"));
        URIS.add(Token.token("object:classid"));
        URIS.add(Token.token("object:codebase"));
        URIS.add(Token.token("object:data"));
        URIS.add(Token.token("object:datasrc"));
        URIS.add(Token.token("object:usemap"));
        URIS.add(Token.token("q:cite"));
        URIS.add(Token.token("script:for"));
        URIS.add(Token.token("script:src"));
        URIS.add(Token.token("select:datasrc"));
        URIS.add(Token.token("span:datasrc"));
        URIS.add(Token.token("table:datasrc"));
        URIS.add(Token.token("textarea:datasrc"));
    }

    OutputSerializer(OutputStream os, SerializerProp props, String ... versions) throws IOException {
        SerializerProp p;
        SerializerProp serializerProp = p = props == null ? PROPS : props;
        String ver = p.get(SerializerProp.S_VERSION).isEmpty() ? (versions.length > 0 ? versions[0] : "") : p.check(SerializerProp.S_VERSION, versions);
        this.indents = Math.max(0, Token.toInt(p.get(SerializerProp.S_INDENTS)));
        this.tab = (char)(p.yes(SerializerProp.S_TABULATOR) ? 9 : 32);
        this.wPre = Token.token(p.get(SerializerProp.S_WRAP_PREFIX));
        this.wUri = Token.token(p.get(SerializerProp.S_WRAP_URI));
        this.wrap = this.wPre.length != 0;
        this.out = PrintOutput.get(os);
        boolean decl = !p.yes(SerializerProp.S_OMIT_XML_DECLARATION);
        boolean bom = p.yes(SerializerProp.S_BYTE_ORDER_MARK);
        String sa = p.check(SerializerProp.S_STANDALONE, "yes", "no", "omit");
        p.check(SerializerProp.S_NORMALIZATION_FORM, "NFC", "none");
        String maps = p.get(SerializerProp.S_USE_CHARACTER_MAPS);
        String enc = Token.normEncoding(p.get(SerializerProp.S_ENCODING), null);
        this.utf8 = enc == "UTF-8";
        this.encoding = Charset.forName(enc);
        this.docsys = p.get(SerializerProp.S_DOCTYPE_SYSTEM);
        this.docpub = p.get(SerializerProp.S_DOCTYPE_PUBLIC);
        this.media = p.get(SerializerProp.S_MEDIA_TYPE);
        this.format = p.yes(SerializerProp.S_FORMAT);
        this.indent = p.yes(SerializerProp.S_INDENT) && this.format;
        this.escape = p.yes(SerializerProp.S_ESCAPE_URI_ATTRIBUTES);
        this.content = p.yes(SerializerProp.S_INCLUDE_CONTENT_TYPE);
        this.undecl = p.yes(SerializerProp.S_UNDECLARE_PREFIXES);
        byte[] byArray = this.nl = this.utf8 ? Token.token(Prop.NL) : Prop.NL.getBytes(this.encoding);
        if (!maps.isEmpty()) {
            Err.SERMAP.thrwSerial(maps);
        }
        if (!Token.supported(enc)) {
            Err.SERENCODING.thrwSerial(enc);
        }
        if (this.docsys.isEmpty()) {
            this.docsys = null;
            this.docpub = null;
        } else if (this.docpub.isEmpty()) {
            this.docpub = null;
        }
        if (bom) {
            if (enc == "UTF-8") {
                this.out.write(239);
                this.out.write(187);
                this.out.write(191);
            } else if (enc == "UTF-16LE") {
                this.out.write(255);
                this.out.write(254);
            } else if (enc == "UTF-16BE") {
                this.out.write(254);
                this.out.write(255);
            }
        }
        if (this instanceof XMLSerializer || this instanceof XHTMLSerializer) {
            String cdse = p.get(SerializerProp.S_CDATA_SECTION_ELEMENTS);
            if (!cdse.isEmpty()) {
                String[] stringArray = cdse.split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    if (!c.isEmpty()) {
                        this.cdata.add(Token.token(c));
                    }
                    ++n2;
                }
            }
            if (this.undecl && ver.equals("1.0")) {
                Err.SERUNDECL.thrwSerial(new Object[0]);
            }
            if (decl) {
                this.print(DataText.PI_O);
                this.print("xml version=\"");
                this.print(ver);
                this.print("\" encoding=\"");
                this.print(p.get(SerializerProp.S_ENCODING));
                if (!sa.equals("omit")) {
                    this.print("\" standalone=\"");
                    this.print(sa);
                }
                this.print(DataText.ATT2);
                this.print(DataText.PI_C);
                this.ind = this.indent;
            } else if (!sa.equals("omit") || !ver.equals("1.0") && this.docsys != null) {
                Err.SERSTAND.thrwSerial(new Object[0]);
            }
        }
        if (this.wrap) {
            this.openElement(this.wPre.length != 0 ? Token.concat(this.wPre, Token.COLON, DataText.RESULTS) : DataText.RESULTS, (byte[][])new byte[0][]);
            this.namespace(this.wPre, this.wUri);
        }
    }

    @Override
    public final void reset() {
        this.ind = false;
        this.item = false;
    }

    @Override
    public void close() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
        this.out.flush();
    }

    @Override
    public void openResult() throws IOException {
        if (this.wrap) {
            this.openElement(this.wPre.length != 0 ? Token.concat(this.wPre, Token.COLON, DataText.RESULT) : DataText.RESULT, (byte[][])new byte[0][]);
            this.ind = false;
        }
    }

    @Override
    public void closeResult() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
    }

    @Override
    public void attribute(byte[] n, byte[] v) throws IOException {
        this.print(32);
        this.print(n);
        this.print(DataText.ATT1);
        int k = 0;
        while (k < v.length) {
            int ch = Token.cp(v, k);
            if (!this.format) {
                this.printChar(ch);
            } else if (ch == 34) {
                this.print(DataText.E_QU);
            } else if (ch == 9 || ch == 10) {
                this.hex(ch);
            } else {
                this.code(ch);
            }
            k += Token.cl(v, k);
        }
        this.print(DataText.ATT2);
    }

    @Override
    public void finishText(byte[] b) throws IOException {
        if (this.cdata.size() == 0 || !this.cdata.contains(this.tags.peek())) {
            int k = 0;
            while (k < b.length) {
                this.code(Token.cp(b, k));
                k += Token.cl(b, k);
            }
        } else {
            this.print(DataText.CDATA_O);
            int c = 0;
            int k = 0;
            while (k < b.length) {
                int ch = Token.cp(b, k);
                if (ch == 93) {
                    ++c;
                } else {
                    if (c > 1 && ch == 62) {
                        this.print(DataText.CDATA_C);
                        this.print(DataText.CDATA_O);
                    }
                    c = 0;
                }
                this.printChar(ch);
                k += Token.cl(b, k);
            }
            this.print(DataText.CDATA_C);
        }
        this.ind = false;
    }

    @Override
    public void finishText(byte[] b, FTPos ftp) throws IOException {
        FTLexer lex = new FTLexer().sc().init(b);
        while (lex.hasNext()) {
            FTSpan span = lex.next();
            if (!span.special && ftp.contains(span.pos)) {
                this.print(4);
            }
            byte[] t = span.text;
            int k = 0;
            while (k < t.length) {
                this.code(Token.cp(t, k));
                k += Token.cl(t, k);
            }
        }
        this.ind = false;
    }

    @Override
    public void finishComment(byte[] n) throws IOException {
        if (this.ind) {
            this.indent();
        }
        this.print(DataText.COMM_O);
        this.print(n);
        this.print(DataText.COMM_C);
    }

    @Override
    public void finishPi(byte[] n, byte[] v) throws IOException {
        if (this.ind) {
            this.indent();
        }
        this.print(DataText.PI_O);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(DataText.PI_C);
    }

    @Override
    public void finishItem(Item it) throws IOException {
        if (this.ind) {
            this.print(32);
        }
        byte[] atom = this.atom(it);
        int a = 0;
        while (a < atom.length) {
            this.code(Token.cp(atom, a));
            a += Token.cl(atom, a);
        }
        this.ind = this.format;
        this.item = true;
    }

    protected void code(int ch) throws IOException {
        if (!this.format) {
            this.printChar(ch);
        } else if (ch < 32 && ch != 10 && ch != 9 || ch > 127 && ch < 160) {
            this.hex(ch);
        } else if (ch == 38) {
            this.print(DataText.E_AMP);
        } else if (ch == 62) {
            this.print(DataText.E_GT);
        } else if (ch == 60) {
            this.print(DataText.E_LT);
        } else {
            this.printChar(ch);
        }
    }

    @Override
    public final boolean finished() {
        return this.out.finished();
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        this.doctype(t);
        if (this.ind) {
            this.indent();
        }
        this.print(DataText.ELEM_O);
        this.print(t);
        this.ind = this.indent;
    }

    protected void doctype(byte[] dt) throws IOException {
        if (this.level != 0 || this.docsys == null) {
            return;
        }
        if (this.ind) {
            this.indent();
        }
        this.print("<!DOCTYPE ");
        if (dt == null) {
            this.print("html");
        } else {
            this.print(dt);
        }
        if (this.docpub != null) {
            this.print(" PUBLIC \"" + this.docpub + "\"");
        } else {
            this.print(" SYSTEM");
        }
        this.print(" \"" + this.docsys + "\"");
        this.print(DataText.ELEM_C);
        this.print(this.nl);
        this.docsys = null;
    }

    @Override
    protected void finishOpen() throws IOException {
        this.print(DataText.ELEM_C);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.print(DataText.ELEM_SC);
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.ind) {
            this.indent();
        }
        this.print(DataText.ELEM_OS);
        this.print(this.tag);
        this.print(DataText.ELEM_C);
        this.ind = this.indent;
    }

    protected final void indent() throws IOException {
        if (!this.indent) {
            return;
        }
        if (this.item) {
            this.item = false;
        } else {
            this.print(this.nl);
            int ls = this.level * this.indents;
            int l = 0;
            while (l < ls) {
                this.print(this.tab);
                ++l;
            }
        }
    }

    protected final void hex(int ch) throws IOException {
        this.print("&#x");
        this.print(Token.HEX[ch >> 4]);
        this.print(Token.HEX[ch & 0xF]);
        this.print(59);
    }

    protected final void printChar(int ch) throws IOException {
        if (ch == 10) {
            this.out.write(this.nl);
        } else {
            this.print(ch);
        }
    }

    protected void print(int ch) throws IOException {
        if (this.utf8) {
            this.out.utf8(ch);
        } else {
            this.out.write(new TokenBuilder(4).add(ch).toString().getBytes(this.encoding));
        }
    }

    protected final void print(byte[] token) throws IOException {
        if (this.utf8) {
            byte[] byArray = token;
            int n = token.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.out.write(b);
                ++n2;
            }
        } else {
            this.out.write(Token.string(token).getBytes(this.encoding));
        }
    }

    protected final void print(String s) throws IOException {
        if (this.utf8) {
            byte[] byArray = Token.token(s);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.out.write(b);
                ++n2;
            }
        } else {
            this.out.write(s.getBytes(this.encoding));
        }
    }

    protected boolean ct(boolean empty, boolean html) throws IOException {
        if (this.ct != 1) {
            return false;
        }
        ++this.ct;
        if (empty) {
            this.finishOpen();
        }
        ++this.level;
        this.startOpen(DataText.META);
        this.attribute(DataText.HTTPEQUIV, Token.token("Content-Type"));
        this.attribute(DataText.CONTENT, new TokenBuilder(this.media.isEmpty() ? "text/html" : this.media).add(DataText.CHARSET).addExt(this.encoding, new Object[0]).finish());
        if (html) {
            this.print(DataText.ELEM_C);
        } else {
            this.print(32);
            this.print(DataText.ELEM_SC);
        }
        --this.level;
        if (empty) {
            this.finishClose();
        }
        return true;
    }
}

