/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.util.Map;
import org.basex.core.AProp;
import org.basex.io.serial.SerializerException;
import org.basex.query.util.Err;
import org.basex.util.TokenBuilder;

public final class SerializerProp
extends AProp {
    public static final Object[] S_BYTE_ORDER_MARK = new Object[]{"byte-order-mark", "no"};
    public static final Object[] S_CDATA_SECTION_ELEMENTS = new Object[]{"cdata-section-elements", ""};
    public static final Object[] S_DOCTYPE_PUBLIC = new Object[]{"doctype-public", ""};
    public static final Object[] S_DOCTYPE_SYSTEM = new Object[]{"doctype-system", ""};
    public static final Object[] S_ENCODING = new Object[]{"encoding", "UTF-8"};
    public static final Object[] S_ESCAPE_URI_ATTRIBUTES = new Object[]{"escape-uri-attributes", "no"};
    public static final Object[] S_INCLUDE_CONTENT_TYPE = new Object[]{"include-content-type", "no"};
    public static final Object[] S_INDENT = new Object[]{"indent", "yes"};
    public static final Object[] S_MEDIA_TYPE = new Object[]{"media-type", ""};
    public static final Object[] S_METHOD = new Object[]{"method", "xml"};
    public static final Object[] S_NORMALIZATION_FORM = new Object[]{"normalization-form", "NFC"};
    public static final Object[] S_OMIT_XML_DECLARATION = new Object[]{"omit-xml-declaration", "yes"};
    public static final Object[] S_STANDALONE = new Object[]{"standalone", "omit"};
    public static final Object[] S_UNDECLARE_PREFIXES = new Object[]{"undeclare-prefixes", "no"};
    public static final Object[] S_USE_CHARACTER_MAPS = new Object[]{"use-character-maps", ""};
    public static final Object[] S_VERSION = new Object[]{"version", ""};
    public static final Object[] S_FORMAT = new Object[]{"format", "yes"};
    public static final Object[] S_TABULATOR = new Object[]{"tabulator", "no"};
    public static final Object[] S_INDENTS = new Object[]{"indents", "2"};
    public static final Object[] S_WRAP_PREFIX = new Object[]{"wrap-prefix", ""};
    public static final Object[] S_WRAP_URI = new Object[]{"wrap-uri", ""};

    public SerializerProp() {
        super(null);
    }

    public SerializerProp(String s) throws SerializerException {
        this();
        if (s == null) {
            return;
        }
        String[] stringArray = s.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ser = stringArray[n2];
            if (!ser.isEmpty()) {
                String val;
                String[] sprop = ser.split("=", 2);
                String key = sprop[0].trim();
                String string = val = sprop.length < 2 ? "" : sprop[1].trim();
                if (this.get(key) == null) {
                    Err.SERINVALID.thrwSerial(key);
                }
                this.set(key, (Object)val);
            }
            ++n2;
        }
    }

    public String check(Object[] key, String ... allowed) throws SerializerException {
        String val = this.get(key);
        String[] stringArray = allowed;
        int n = allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equals(val)) {
                return val;
            }
            ++n2;
        }
        throw SerializerProp.error(key[0], val, allowed);
    }

    public boolean yes(Object[] key) throws SerializerException {
        String a;
        String val = this.get(key);
        String[] stringArray = new String[]{"yes", "true", "ON"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            a = stringArray[n2];
            if (a.equals(val)) {
                return true;
            }
            ++n2;
        }
        stringArray = new String[]{"no", "false", "OFF"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            a = stringArray[n2];
            if (a.equals(val)) {
                return false;
            }
            ++n2;
        }
        throw SerializerProp.error(key[0], val, "yes", "no");
    }

    public static SerializerException error(Object key, String found, String ... allowed) {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt("Parameter '%' must be [%", key, allowed[0]);
        int a = 1;
        while (a < allowed.length) {
            tb.addExt("|%", allowed[a]);
            ++a;
        }
        tb.addExt("]; '%' found", found);
        try {
            return Err.SERANY.thrwSerial(tb);
        }
        catch (SerializerException ex) {
            return ex;
        }
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (Map.Entry e : this.props.entrySet()) {
            if (tb.size() != 0) {
                tb.add(44);
            }
            tb.add((String)e.getKey()).add(61).addExt(e.getValue(), new Object[0]);
        }
        return tb.toString();
    }
}

