/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.serial.SerializerException;
import org.basex.query.item.Empty;
import org.basex.query.item.Value;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class QueryException
extends Exception {
    private Err err;
    private String code;
    private Value value = Empty.SEQ;
    private IO file;
    private StringList complete;
    private int[] lineCol;
    private int markedCol;

    public QueryException(InputInfo ii, Err er, Object ... ext) {
        this(ii, null, null, er.desc, ext);
        this.err = er;
    }

    public QueryException(InputInfo ii, SerializerException ex) {
        this(ii, null, null, ex.getLocalizedMessage(), new Object[0]);
        this.err = ex.err();
    }

    public QueryException(InputInfo ii, String errc, Value val, String msg, Object ... ext) {
        super(BaseXException.message(msg, ext));
        this.code = errc;
        this.value = val;
        if (ii == null) {
            return;
        }
        this.file = ii.file;
        this.lineCol = ii.lineCol();
    }

    public int col() {
        return this.lineCol == null ? 0 : this.lineCol[1];
    }

    public int markedCol() {
        return this.markedCol;
    }

    public int line() {
        return this.lineCol == null ? 0 : this.lineCol[0];
    }

    public IO file() {
        return this.file;
    }

    public StringList complete() {
        return this.complete == null ? new StringList() : this.complete;
    }

    public void complete(InputParser qp, StringList comp) {
        this.complete = comp;
        this.pos(qp);
    }

    void pos(InputParser parser) {
        this.markedCol = parser.qm;
        if (this.lineCol != null) {
            return;
        }
        this.file = parser.file;
        this.lineCol = InputInfo.lineCol(parser.query, Math.min(parser.qm, parser.ql));
    }

    public String code() {
        return this.code == null ? this.err.toString() : this.code;
    }

    public Err err() {
        return this.err;
    }

    public Value value() {
        return this.value;
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String c;
        TokenBuilder tb = new TokenBuilder();
        if (this.lineCol != null) {
            tb.add(Text.STOPPED).add(32).addExt(Text.LINEINFO, this.lineCol[0]);
            if (this.lineCol[1] != 0) {
                tb.add(", ").addExt(Text.COLINFO, this.lineCol[1]);
            }
            if (this.file != null) {
                tb.add(32).addExt(Text.FILEINFO, this.file);
            }
            tb.add(":").add(Text.NL);
        }
        if (!(c = this.code()).isEmpty()) {
            tb.add(91).add(c).add("] ");
        }
        return tb.add(this.getLocalizedMessage()).toString();
    }
}

