/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunc;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.Token;

public final class QueryProcessor
extends Progress {
    public final QueryContext ctx;
    private String query;
    private boolean parsed;
    private boolean compiled;

    public QueryProcessor(String qu, Context cx) {
        this(qu, cx.current(), cx);
    }

    public QueryProcessor(String qu, Nodes nodes, Context cx) {
        this.query = qu;
        this.ctx = new QueryContext(cx);
        this.ctx.nodes = nodes;
        this.progress(this.ctx);
    }

    public QueryProcessor(String qu, Object o, Context cx) throws QueryException {
        this(qu, o instanceof ItemCache ? ((ItemCache)o).value() : (o instanceof Expr ? (Expr)o : JavaFunc.type(o).e(o, null)), cx);
    }

    public QueryProcessor(String qu, Expr expr, Context cx) {
        this.query = qu;
        this.ctx = new QueryContext(cx);
        this.ctx.initExpr = expr;
        this.progress(this.ctx);
    }

    public void parse() throws QueryException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.ctx.parse(this.query);
    }

    public void compile() throws QueryException {
        this.parse();
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.ctx.compile();
    }

    public Iter iter() throws QueryException {
        this.compile();
        return this.ctx.iter();
    }

    public Value value() throws QueryException {
        this.compile();
        return this.ctx.value();
    }

    public Result execute() throws QueryException {
        this.compile();
        return this.ctx.eval();
    }

    public QueryProcessor bind(String n, Object o, String t) throws QueryException {
        this.ctx.bind(n, o, t);
        return this;
    }

    public QueryProcessor bind(String n, Object o) throws QueryException {
        this.ctx.bind(n, o);
        return this;
    }

    public QueryProcessor context(Object o) throws QueryException {
        this.ctx.initExpr = o instanceof Expr ? (Expr)o : JavaFunc.type(o).e(o, null);
        return this;
    }

    public Serializer getSerializer(OutputStream os) throws IOException, QueryException {
        this.compile();
        try {
            return Serializer.get(os, this.ctx.serProp(true));
        }
        catch (SerializerException ex) {
            throw new QueryException(null, ex);
        }
    }

    public Nodes queryNodes() throws QueryException {
        Result res = this.execute();
        if (!(res instanceof Nodes)) {
            if (res.size() == 0L) {
                return new Nodes(this.ctx.nodes.data);
            }
            Err.QUERYNODES.thrw(null, new Object[0]);
        }
        return (Nodes)res;
    }

    public void module(String file, String uri) {
        this.ctx.modDeclared.add(Token.token(file), Token.token(uri));
    }

    public void query(String qu) {
        this.query = qu;
        this.parsed = false;
        this.compiled = false;
    }

    public void close() throws IOException {
        if (this.ctx.globalOpt != null) {
            for (Map.Entry<String, Object> e : this.ctx.globalOpt.entrySet()) {
                this.ctx.context.prop.set(e.getKey(), e.getValue());
            }
            this.ctx.globalOpt = null;
        }
        this.ctx.resource.close();
        this.ctx.jdbc.close();
    }

    public int updates() {
        return this.ctx.updates.size();
    }

    public String info() {
        return this.ctx.info();
    }

    public static boolean updating(Context ctx, String qu) {
        try {
            QueryProcessor qp = new QueryProcessor(qu, ctx);
            qp.parse();
            return qp.ctx.updating;
        }
        catch (QueryException ex) {
            return true;
        }
    }

    public static String removeComments(String qu, int max) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        boolean s = false;
        int cl = qu.length();
        int c = 0;
        while (c < cl && sb.length() < max) {
            char ch = qu.charAt(c);
            if (ch != '\r') {
                if (ch == '(' && c + 1 < cl && qu.charAt(c + 1) == ':') {
                    if (m == 0 && !s) {
                        sb.append(' ');
                        s = true;
                    }
                    ++m;
                    ++c;
                } else if (m != 0 && ch == ':' && c + 1 < cl && qu.charAt(c + 1) == ')') {
                    --m;
                    ++c;
                } else if (m == 0) {
                    if (ch > ' ') {
                        sb.append(ch);
                    } else if (!s) {
                        sb.append(' ');
                    }
                    s = ch <= ' ';
                }
            }
            ++c;
        }
        if (sb.length() >= max) {
            sb.append("...");
        }
        return sb.toString().trim();
    }

    public void plan(Serializer ser) throws IOException {
        this.ctx.plan(ser);
    }

    @Override
    public String tit() {
        return Text.QUERYEVAL;
    }

    @Override
    public String det() {
        return Text.QUERYEVAL;
    }
}

