/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.And;
import org.basex.query.expr.Expr;
import org.basex.query.expr.FLWR;
import org.basex.query.expr.Filter;
import org.basex.query.expr.For;
import org.basex.query.expr.ForLet;
import org.basex.query.expr.Group;
import org.basex.query.expr.If;
import org.basex.query.expr.Order;
import org.basex.query.expr.OrderBy;
import org.basex.query.expr.ParseExpr;
import org.basex.query.func.Function;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.util.ValueList;
import org.basex.query.util.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.ObjList;

public class GFLWOR
extends ParseExpr {
    protected Expr ret;
    protected ForLet[] fl;
    protected Expr where;
    protected Order order;
    protected Group group;

    GFLWOR(ForLet[] f, Expr w, Order o, Group g, Expr r, InputInfo ii) {
        super(ii);
        this.ret = r;
        this.fl = f;
        this.where = w;
        this.group = g;
        this.order = o;
    }

    public static GFLWOR get(ForLet[] f, Expr w, OrderBy[] o, Var[][] g, Expr r, InputInfo ii) {
        if (o == null && g == null) {
            return new FLWR(f, w, r, ii);
        }
        Order ord = o == null ? null : new Order(ii, o);
        Group grp = g == null ? null : new Group(ii, g[0], g[1], g[2]);
        return new GFLWOR(f, w, ord, grp, r, ii);
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        this.compHoist(ctx);
        this.compWhere(ctx);
        boolean grp = ctx.grouping;
        ctx.grouping = this.group != null;
        int vs = ctx.vars.size();
        int f = 0;
        while (f < this.fl.length) {
            ForLet flt = this.fl[f];
            flt.comp(ctx);
            if (flt.expr.value() || this.count(flt.var, f) == 1) {
                flt.bind(ctx);
            }
            ++f;
        }
        boolean empty = false;
        if (this.where != null) {
            this.where = this.checkUp(this.where, ctx).comp(ctx).compEbv(ctx);
            if (this.where.value()) {
                boolean bl = empty = !this.where.ebv(ctx, this.input).bool(this.input);
                if (!empty) {
                    ctx.compInfo("%: removing %", this.desc(), this.where);
                    this.where = null;
                }
            }
        }
        if (this.group != null) {
            this.group.comp(ctx);
        }
        if (this.order != null) {
            this.order.comp(ctx);
        }
        this.ret = this.ret.comp(ctx);
        ctx.vars.reset(vs);
        ctx.grouping = grp;
        if (empty) {
            ctx.compInfo("%: removing %", this.desc(), this.where);
            return Empty.SEQ;
        }
        if (this.ret == Empty.SEQ) {
            ctx.compInfo("simplifying flwor expression", new Object[0]);
            return this.ret;
        }
        int f2 = 0;
        while (f2 < this.fl.length) {
            ForLet l = this.fl[f2];
            if (l.var.expr() != null || l.simple(true) && this.count(l.var, f2) == 0 && !l.expr.uses(Expr.Use.CTX)) {
                ctx.compInfo("removing variable %", l.var);
                this.fl = Array.delete(this.fl, f2--);
            }
            ++f2;
        }
        if (this.fl.length == 0) {
            ctx.compInfo("simplifying flwor expression", new Object[0]);
            return this.where != null ? new If(this.input, this.where, this.ret, (Expr)Empty.SEQ) : this.ret;
        }
        ForLet[] forLetArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f3 = forLetArray[n2];
            if (f3 instanceof For && f3.size() == 0L) {
                ctx.compInfo("simplifying flwor expression", new Object[0]);
                return Empty.SEQ;
            }
            ++n2;
        }
        if (this.where == null && this.group == null) {
            this.size = this.ret.size();
            if (this.size != -1L) {
                forLetArray = this.fl;
                n = this.fl.length;
                n2 = 0;
                while (n2 < n) {
                    ForLet f4 = forLetArray[n2];
                    long s = f4.size();
                    if (s == -1L) {
                        this.size = s;
                        break;
                    }
                    this.size *= s;
                    ++n2;
                }
            }
        }
        this.type = SeqType.get(this.ret.type().type, this.size);
        this.compHoist(ctx);
        return this;
    }

    private void compHoist(QueryContext ctx) {
        int m = 0;
        int i = 1;
        while (i < this.fl.length) {
            ForLet in = this.fl[i];
            if (in.size() == 1L && !in.uses(Expr.Use.CTX) && !in.uses(Expr.Use.CNS)) {
                int p = -1;
                int o = i;
                while (o-- != 0 && in.count(this.fl[o]) == 0) {
                    p = o;
                }
                if (p != -1) {
                    Array.move(this.fl, p, 1, i - p);
                    this.fl[p] = in;
                    if (m++ == 0) {
                        ctx.compInfo("moving for/let clauses", new Object[0]);
                    }
                }
            }
            ++i;
        }
    }

    private void compWhere(QueryContext ctx) {
        Expr[] exprArray;
        if (this.where == null) {
            return;
        }
        ForLet[] forLetArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f = forLetArray[n2];
            if (!(!(f instanceof For) || f.simple(false) && this.where.removable(f.var))) {
                return;
            }
            ++n2;
        }
        if (this.where instanceof And) {
            exprArray = ((And)this.where).expr;
        } else {
            Expr[] exprArray2 = new Expr[1];
            exprArray = exprArray2;
            exprArray2[0] = this.where;
        }
        Expr[] tests = exprArray;
        int[] tar = new int[tests.length];
        int t = 0;
        while (t < tests.length) {
            int fr = -1;
            int f = this.fl.length - 1;
            while (f >= 0) {
                if (this.fl[f] instanceof For) {
                    fr = f;
                }
                if (tests[t].count(this.fl[f].var) != 0) {
                    if (fr == -1) {
                        return;
                    }
                    tar[t] = fr;
                    break;
                }
                --f;
            }
            ++t;
        }
        ctx.compInfo("rewriting where clause to predicate(s)", new Object[0]);
        t = 0;
        while (t < tests.length) {
            ForLet f = this.fl[tar[t]];
            Expr e = tests[t].remove(f.var);
            e = Function.BOOLEAN.get(this.input, e).compEbv(ctx);
            f.expr = f.expr instanceof AxisPath ? ((AxisPath)f.expr).addPreds(e) : (f.expr instanceof Filter ? ((Filter)f.expr).addPred(e) : new Filter(this.input, f.expr, e));
            ++t;
        }
        this.where = null;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Iter[] iter = new Iter[this.fl.length];
        int vs = ctx.vars.size();
        int f = 0;
        while (f < this.fl.length) {
            iter[f] = ctx.iter(this.fl[f]);
            ++f;
        }
        ObjList<Item[]> keys = null;
        ValueList vals = null;
        if (this.order != null) {
            keys = new ObjList<Item[]>();
            vals = new ValueList();
        }
        if (this.group != null) {
            this.group.init(this.order);
        }
        this.iter(ctx, iter, 0, keys, vals);
        ctx.vars.reset(vs);
        ForLet[] forLetArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f2 = forLetArray[n2];
            ctx.vars.add(f2.var);
            ++n2;
        }
        Iter ir = this.group != null ? this.group.gp.ret(ctx, this.ret, keys, vals) : ctx.iter(this.order.set(keys, vals));
        ctx.vars.reset(vs);
        return ir;
    }

    private void iter(QueryContext ctx, Iter[] it, int p, ObjList<Item[]> ks, ValueList vs) throws QueryException {
        boolean more = p + 1 != this.fl.length;
        while (it[p].next() != null) {
            if (more) {
                this.iter(ctx, it, p + 1, ks, vs);
                continue;
            }
            if (this.where != null && !this.where.ebv(ctx, this.input).bool(this.input)) continue;
            if (this.group != null) {
                this.group.gp.add(ctx);
                continue;
            }
            if (this.order == null) continue;
            this.order.add(ctx, this.ret, ks, vs);
        }
    }

    @Override
    public final boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || this.ret.uses(u);
    }

    @Override
    public final int count(Var v) {
        return this.count(v, 0);
    }

    public final int count(Var v, int i) {
        int c = 0;
        int f = i;
        while (f < this.fl.length) {
            c += this.fl[f].count(v);
            ++f;
        }
        if (this.where != null) {
            c += this.where.count(v);
        }
        if (this.order != null) {
            c += this.order.count(v);
        }
        if (this.group != null) {
            c += this.group.count(v);
        }
        return c + this.ret.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        ForLet[] forLetArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f = forLetArray[n2];
            if (!f.removable(v)) {
                return false;
            }
            ++n2;
        }
        return !(this.where != null && !this.where.removable(v) || this.order != null && !this.order.removable(v) || this.group != null && !this.group.removable(v) || !this.ret.removable(v));
    }

    @Override
    public final Expr remove(Var v) {
        ForLet[] forLetArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f = forLetArray[n2];
            f.remove(v);
            ++n2;
        }
        if (this.where != null) {
            this.where = this.where.remove(v);
        }
        if (this.order != null) {
            this.order = this.order.remove(v);
        }
        this.ret = this.ret.remove(v);
        return this;
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        ForLet[] forLetArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            ForLet f = forLetArray[n2];
            f.plan(ser);
            ++n2;
        }
        if (this.where != null) {
            ser.openElement(QueryText.WHR, (byte[][])new byte[0][]);
            this.where.plan(ser);
            ser.closeElement();
        }
        if (this.group != null) {
            this.group.plan(ser);
        }
        if (this.order != null) {
            this.order.plan(ser);
        }
        ser.openElement(QueryText.RET, (byte[][])new byte[0][]);
        this.ret.plan(ser);
        ser.closeElement();
        ser.closeElement();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i != this.fl.length) {
            sb.append(String.valueOf(i != 0 ? " " : "") + this.fl[i]);
            ++i;
        }
        if (this.where != null) {
            sb.append(" where " + this.where);
        }
        if (this.group != null) {
            sb.append(this.group);
        }
        if (this.order != null) {
            sb.append(this.order);
        }
        return sb.append(" return " + this.ret).toString();
    }
}

