/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.OrderBy;
import org.basex.query.item.Item;
import org.basex.query.item.Str;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class OrderByExpr
extends OrderBy {
    private Expr expr;

    public OrderByExpr(InputInfo ii, Expr e, boolean d, boolean l) {
        super(ii);
        this.expr = e;
        this.desc = d;
        this.lst = l;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        this.expr = this.checkUp(this.expr, ctx).comp(ctx);
        this.type = this.expr.type();
        return this;
    }

    @Override
    Item key(QueryContext ctx, int i) throws QueryException {
        Item it = this.expr.item(ctx, this.input);
        if (it != null) {
            if (it.node()) {
                it = Str.get(it.atom(this.input));
            } else if (it.num() && Double.isNaN(it.dbl(this.input))) {
                it = null;
            }
        }
        return it;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.expr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v);
    }

    @Override
    public OrderByExpr remove(Var v) {
        this.expr = this.expr.remove(v);
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.DIR, Token.token(this.desc ? "descending" : "ascending"), Token.token("empty"), Token.token(this.lst ? "least" : "greatest")});
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.expr.toString());
        if (this.desc) {
            sb.append(" descending");
        }
        if (!this.lst) {
            sb.append(" empty greatest");
        }
        return sb.toString();
    }
}

