/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.func.Function;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.util.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.ObjList;

public abstract class Preds
extends ParseExpr {
    public Expr[] preds;
    public boolean last;
    public Pos pos;

    public Preds(InputInfo ii, Expr[] p) {
        super(ii);
        this.preds = p;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            this.checkUp(p, ctx);
            ++n2;
        }
        Expr e = this;
        int p = 0;
        while (p < this.preds.length) {
            Expr pr = this.preds[p].comp(ctx).compEbv(ctx);
            if ((pr = Pos.get(CmpV.Op.EQ, pr, pr, this.input)).value()) {
                if (!pr.ebv(ctx, this.input).bool(this.input)) {
                    ctx.compInfo("%: removing %", this.desc(), pr);
                    e = Empty.SEQ;
                    break;
                }
                ctx.compInfo("%: removing %", this.desc(), pr);
                this.preds = Array.delete(this.preds, p--);
            } else {
                this.preds[p] = pr;
                if (this.preds[p] instanceof And) {
                    ctx.compInfo("rewriting % to predicate(s)", this.preds[p].desc());
                    Expr[] and = ((And)this.preds[p]).expr;
                    int m = and.length - 1;
                    ObjList<Expr> tmp = new ObjList<Expr>(this.preds.length + m);
                    int i = 0;
                    while (i < p) {
                        tmp.add(this.preds[i]);
                        ++i;
                    }
                    Expr[] exprArray2 = and;
                    int n3 = and.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Expr a = exprArray2[n4];
                        tmp.add(Function.BOOLEAN.get(this.input, a).compEbv(ctx));
                        ++n4;
                    }
                    i = p + 1;
                    while (i < this.preds.length) {
                        tmp.add(this.preds[i]);
                        ++i;
                    }
                    this.preds = tmp.toArray(new Expr[tmp.size()]);
                }
            }
            ++p;
        }
        return e;
    }

    protected boolean useIterator() {
        this.pos = this.preds[0] instanceof Pos ? (Pos)this.preds[0] : null;
        this.last = this.preds[0].isFun(Function.LAST);
        boolean np1 = true;
        boolean np2 = true;
        int p = 0;
        while (p < this.preds.length) {
            boolean np = !this.preds[p].type().mayBeNum() && !this.preds[p].uses(Expr.Use.POS);
            np1 &= np;
            if (p > 0) {
                np2 &= np;
            }
            ++p;
        }
        return np1 || this.pos != null && np2 || this.last && this.preds.length == 1;
    }

    public boolean preds(Item it, QueryContext ctx) throws QueryException {
        ctx.value = it;
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            Item i = p.test(ctx, this.input);
            if (i == null) {
                return false;
            }
            it.score(i.score());
            ++n2;
        }
        return true;
    }

    @Override
    public boolean uses(Expr.Use u) {
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            if (u == Expr.Use.POS && p.type().mayBeNum() || p.uses(u)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int count(Var v) {
        int c = 0;
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            c += p.count(v);
            ++n2;
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            if (p.count(v) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Expr remove(Var v) {
        int p = 0;
        while (p < this.preds.length) {
            this.preds[p] = this.preds[p].remove(v);
            ++p;
        }
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            p.plan(ser);
            ++n2;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Expr[] exprArray = this.preds;
        int n = this.preds.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            sb.append("[" + e + "]");
            ++n2;
        }
        return sb.toString();
    }
}

