/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.data.ExprInfo;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.For;
import org.basex.query.expr.ForLet;
import org.basex.query.expr.ParseExpr;
import org.basex.query.item.Bln;
import org.basex.query.item.SeqType;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Quantifier
extends ParseExpr {
    private final boolean every;
    private final For[] fl;
    private Expr sat;

    public Quantifier(InputInfo ii, For[] f, Expr s, boolean e) {
        super(ii);
        this.sat = s;
        this.fl = f;
        this.every = e;
        this.type = SeqType.BLN;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        int vs = ctx.vars.size();
        For[] forArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            For f = forArray[n2];
            f.comp(ctx);
            ++n2;
        }
        this.sat = this.checkUp(this.sat, ctx).comp(ctx).compEbv(ctx);
        ctx.vars.reset(vs);
        boolean empty = this.sat.empty();
        For[] forArray2 = this.fl;
        int n3 = this.fl.length;
        n = 0;
        while (n < n3) {
            For f = forArray2[n];
            empty |= f.empty();
            ++n;
        }
        return empty ? this.optPre(Bln.get(this.every), ctx) : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter[] iter = new Iter[this.fl.length];
        int f = 0;
        while (f < this.fl.length) {
            iter[f] = ctx.iter(this.fl[f]);
            ++f;
        }
        return Bln.get(this.iter(ctx, iter, 0));
    }

    private boolean iter(QueryContext ctx, Iter[] it, int p) throws QueryException {
        boolean last = p + 1 == this.fl.length;
        while (it[p].next() != null) {
            if (!(this.every ^ (last ? this.sat.ebv(ctx, this.input).bool(this.input) : this.iter(ctx, it, p + 1)))) continue;
            Iter[] iterArray = it;
            int n = it.length;
            int n2 = 0;
            while (n2 < n) {
                Iter ri = iterArray[n2];
                ri.reset();
                ++n2;
            }
            return !this.every;
        }
        return this.every;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || this.sat.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        For[] forArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            For f = forArray[n2];
            c += ((ForLet)f).count(v);
            ++n2;
        }
        return c + this.sat.count(v);
    }

    @Override
    public boolean removable(Var v) {
        For[] forArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            For f = forArray[n2];
            if (!((ForLet)f).removable(v)) {
                return false;
            }
            ++n2;
        }
        return this.sat.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        For[] forArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            For f = forArray[n2];
            ((ForLet)f).remove(v);
            ++n2;
        }
        this.sat = this.sat.remove(v);
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.TYP, Token.token(this.every ? "every" : "some")});
        For[] forArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            For f = forArray[n2];
            ((ExprInfo)f).plan(ser);
            ++n2;
        }
        this.sat.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.every ? "every" : "some");
        For[] forArray = this.fl;
        int n = this.fl.length;
        int n2 = 0;
        while (n2 < n) {
            For f = forArray[n2];
            sb.append(" " + f);
            ++n2;
        }
        return sb.append(" satisfies " + this.sat).toString();
    }
}

