/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.UserFuncCall;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.NSLocal;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class VarRef
extends ParseExpr {
    Var var;

    public VarRef(InputInfo ii, Var v) {
        super(ii);
        this.var = v;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        this.var = ctx.vars.get(this.var);
        this.type = this.var.type();
        this.size = this.var.size();
        Expr e = this.var.expr();
        if (e == null) {
            return this;
        }
        NSLocal ns = ctx.ns;
        ctx.ns = ns.copy();
        if (ctx.nsElem.length != 0) {
            ctx.ns.add(new QNm(Token.EMPTY, ctx.nsElem), this.input);
        }
        if (this.var.global || ctx.nsElem.length != 0 || ns.size() != 0 || this.var.type != null || e.uses(Expr.Use.CNS) || e instanceof UserFuncCall) {
            e = this.var.value(ctx);
        }
        ctx.ns = ns;
        return e;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.var = ctx.vars.get(this.var);
        return this.var.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.var = ctx.vars.get(this.var);
        return ctx.iter(this.var);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        this.var = ctx.vars.get(this.var);
        return ctx.value(this.var);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || u != Expr.Use.CTX && this.var.expr() != null && this.var.expr().uses(u);
    }

    @Override
    public int count(Var v) {
        return this.var.is(v) ? 1 : 0;
    }

    @Override
    public boolean removable(Var v) {
        return true;
    }

    @Override
    public Expr remove(Var v) {
        return this.var.is(v) ? new Context(this.input) : this;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof VarRef && this.var.sameAs(((VarRef)cmp).var);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.emptyElement(this, (byte[][])new byte[][]{QueryText.NAM, Token.token(this.var.toString())});
    }

    @Override
    public String desc() {
        return "Variable";
    }

    @Override
    public String toString() {
        return new TokenBuilder("$").add(this.var.name.atom()).toString();
    }
}

