/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNAcc
extends FuncCall {
    public FNAcc(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr.length != 0 ? this.expr[0] : this.checkCtx(ctx);
        switch (this.def) {
            case POS: {
                return Itr.get(ctx.pos);
            }
            case LAST: {
                return Itr.get(ctx.size);
            }
            case STRING: {
                Item it = e.item(ctx, this.input);
                if (it == null) {
                    return Str.ZERO;
                }
                if (it.func()) {
                    Err.FNSTR.thrw(ii, this);
                }
                return it.str() && !it.unt() ? it : Str.get(it.atom(ii));
            }
            case NUMBER: {
                return this.number(ctx.iter(e), ctx);
            }
            case STRLEN: {
                return Itr.get(Token.len(this.checkEStr(e, ctx)));
            }
            case NORMSPC: {
                return Str.get(Token.norm(this.checkEStr(e, ctx)));
            }
            case URIQNM: {
                Item it = e.item(ctx, this.input);
                if (it == null) {
                    return null;
                }
                QNm qn = (QNm)this.checkType(it, AtomType.QNM);
                return qn.hasUri() ? qn.uri() : Uri.uri(ctx.ns.uri(qn.pref(), true, ii));
            }
        }
        return super.item(ctx, ii);
    }

    private Item number(Iter ir, QueryContext ctx) throws QueryException {
        Item it = ir.next();
        if (it == null || ir.next() != null) {
            return Dbl.NAN;
        }
        if (it.func()) {
            Err.FNATM.thrw(this.input, this);
        }
        try {
            return it.type == AtomType.DBL ? it : AtomType.DBL.e(it, ctx, this.input);
        }
        catch (QueryException ex) {
            return Dbl.NAN;
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        boolean pos;
        boolean bl = pos = this.def == Function.POS || this.def == Function.LAST;
        return u == Expr.Use.CTX && (pos || this.expr.length == 0) || u == Expr.Use.POS && pos || super.uses(u);
    }
}

