/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.core.Commands;
import org.basex.core.Prop;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexToken;
import org.basex.io.IOFile;
import org.basex.io.MimeTypes;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.func.FNFt;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.DBNode;
import org.basex.query.item.DBNodeSeq;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.QNm;
import org.basex.query.item.Raw;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.up.primitives.DBAdd;
import org.basex.query.up.primitives.DBDelete;
import org.basex.query.up.primitives.DBOptimize;
import org.basex.query.up.primitives.DBRename;
import org.basex.query.up.primitives.DBStore;
import org.basex.query.up.primitives.DeleteNode;
import org.basex.query.up.primitives.ReplaceValue;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class FNDb
extends FuncCall {
    public FNDb(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case DBOPEN: {
                return this.open(ctx).iter();
            }
            case DBTEXT: {
                return this.text(ctx);
            }
            case DBATTR: {
                return this.attribute(ctx);
            }
            case DBFULLTEXT: {
                return this.fulltext(ctx);
            }
            case DBLIST: {
                return this.list(ctx);
            }
            case DBNODEID: {
                return this.node(ctx, true);
            }
            case DBNODEPRE: {
                return this.node(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case DBOPEN: {
                return this.open(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case DBEVENT: {
                return this.event(ctx);
            }
            case DBOPENID: {
                return this.open(ctx, true);
            }
            case DBOPENPRE: {
                return this.open(ctx, false);
            }
            case DBSYSTEM: {
                return this.system(ctx);
            }
            case DBINFO: {
                return this.info(ctx);
            }
            case DBADD: {
                return this.add(ctx);
            }
            case DBDELETE: {
                return this.delete(ctx);
            }
            case DBRENAME: {
                return this.rename(ctx);
            }
            case DBREPLACE: {
                return this.replace(ctx);
            }
            case DBOPTIMIZE: {
                return this.optimize(ctx);
            }
            case DBSTORE: {
                return this.store(ctx);
            }
            case DBRETRIEVE: {
                return this.retrieve(ctx);
            }
            case DBISRAW: {
                return this.isRaw(ctx);
            }
            case DBEXISTS: {
                return this.exists(ctx);
            }
            case DBISXML: {
                return this.isXML(ctx);
            }
            case DBCTYPE: {
                return this.contentType(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Value open(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        String path = this.expr.length < 2 ? "" : this.path(1, ctx);
        return DBNodeSeq.get(data.docs(path), data, true, path.isEmpty());
    }

    private DBNode open(QueryContext ctx, boolean id) throws QueryException {
        int pre;
        Data data = this.data(0, ctx);
        int v = (int)this.checkItr(this.expr[1], ctx);
        int n = pre = id ? data.pre(v) : v;
        if (pre < 0 || pre >= data.meta.size) {
            Err.IDINVALID.thrw(this.input, this, v);
        }
        return new DBNode(data, pre);
    }

    private Iter text(QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, this.data(0, ctx), null, true);
        return new IndexAccess(this.input, this.expr[1], IndexToken.IndexType.TEXT, ic).iter(ctx);
    }

    private Iter attribute(QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, this.data(0, ctx), null, true);
        IndexAccess ia = new IndexAccess(this.input, this.expr[1], IndexToken.IndexType.ATTRIBUTE, ic);
        if (this.expr.length < 3) {
            return ia.iter(ctx);
        }
        Item name = this.checkEmpty(this.expr[2].item(ctx, this.input));
        QNm nm = new QNm(this.checkStr(name, ctx), ctx, this.input);
        final NameTest nt = new NameTest(nm, Test.Name.STD, true, this.input);
        if (!nt.comp(ctx)) {
            return Empty.ITER;
        }
        return new Iter(ia, ctx){
            final NodeIter ir;
            {
                this.ir = indexAccess.iter(queryContext);
            }

            @Override
            public Item next() throws QueryException {
                ANode n;
                while ((n = this.ir.next()) != null && !nt.eval(n)) {
                }
                return n;
            }
        };
    }

    private Iter fulltext(QueryContext ctx) throws QueryException {
        return FNFt.search(this.data(0, ctx), this.checkStr(this.expr[1], ctx), this, ctx);
    }

    private Iter list(QueryContext ctx) throws QueryException {
        final TokenList tl = new TokenList();
        int el = this.expr.length;
        if (el == 0) {
            for (String s : List.list(ctx.context)) {
                tl.add(s);
            }
        } else {
            Data data = this.data(0, ctx);
            String path = Token.string(el == 1 ? Token.EMPTY : this.checkStr(this.expr[1], ctx));
            IntList il = data.docs(path);
            int is = il.size();
            int i = 0;
            while (i < is) {
                tl.add(data.text(il.get(i), true));
                ++i;
            }
            for (byte[] file : data.files(path)) {
                tl.add(file);
            }
        }
        tl.sort(!Prop.WIN);
        return new Iter(){
            int pos;

            @Override
            public Item get(long i) {
                return Str.get(tl.get((int)i));
            }

            @Override
            public Item next() {
                return (long)this.pos < this.size() ? this.get(this.pos++) : null;
            }

            @Override
            public boolean reset() {
                this.pos = 0;
                return true;
            }

            @Override
            public long size() {
                return tl.size();
            }
        };
    }

    private Bln isRaw(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        IOFile io = data.meta.binary(path);
        return Bln.get(io.exists() && !io.isDir());
    }

    private Bln exists(QueryContext ctx) throws QueryException {
        try {
            Data data = this.data(0, ctx);
            if (this.expr.length == 1) {
                return Bln.TRUE;
            }
            String path = this.path(1, ctx);
            IOFile io = data.meta.binary(path);
            return Bln.get(io.exists() && !io.isDir() || data.doc(path) != -1);
        }
        catch (QueryException ex) {
            if (ex.err() == Err.NODB) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    private Bln isXML(QueryContext ctx) throws QueryException {
        String path;
        Data data = this.data(0, ctx);
        return Bln.get(data.doc(path = this.path(1, ctx)) != -1);
    }

    private Str contentType(QueryContext ctx) throws QueryException {
        String path;
        Data data = this.data(0, ctx);
        if (data.doc(path = this.path(1, ctx)) != -1) {
            return Str.get("application/xml");
        }
        IOFile io = data.meta.binary(path);
        if (io.exists() && !io.isDir()) {
            return Str.get(MimeTypes.get(path));
        }
        throw Err.RESFNF.thrw(this.input, path);
    }

    private Str system(QueryContext ctx) {
        return Str.get(Token.delete(Info.info(ctx.context), 13));
    }

    private Str info(QueryContext ctx) throws QueryException {
        byte[] info;
        Data data = this.data(0, ctx);
        if (this.expr.length == 1) {
            boolean create = ctx.context.user.perm(4);
            info = InfoDB.db(data.meta, false, true, create);
        } else {
            byte[] tp = this.checkStr(this.expr[1], ctx);
            Commands.CmdIndexInfo cmd = InfoIndex.info(Token.string(tp));
            if (cmd == null) {
                Err.NOIDX.thrw(this.input, this);
            }
            info = InfoIndex.info(cmd, data);
        }
        return Str.get(Token.delete(info, 13));
    }

    private Item add(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        Item it = this.checkItem(this.expr[1], ctx);
        String path = this.expr.length < 3 ? "" : this.path(2, ctx);
        ctx.updates.add(new DBAdd(data, this.input, it, path, ctx.context), ctx);
        return null;
    }

    private Item replace(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        Item doc = this.checkItem(this.expr[2], ctx);
        int pre = data.doc(path);
        if (pre != -1) {
            if (data.docs(path).size() != 1) {
                Err.DOCTRGMULT.thrw(this.input, new Object[0]);
            }
            ctx.updates.add(new DeleteNode(pre, data, this.input), ctx);
        }
        TokenList raw = Delete.files(data, path);
        ctx.updates.add(new DBDelete(data, raw, this.input), ctx);
        ctx.updates.add(new DBAdd(data, this.input, doc, path, ctx.context), ctx);
        IOFile file = data.meta.binary(path);
        if (file != null && file.exists() && !file.isDir()) {
            byte[] val = this.checkBin(doc, ctx);
            ctx.updates.add(new DBStore(data, Token.token(path), val, this.input), ctx);
        }
        return null;
    }

    private Item delete(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        IntList docs = data.docs(path);
        int i = 0;
        int is = docs.size();
        while (i < is) {
            ctx.updates.add(new DeleteNode(docs.get(i), data, this.input), ctx);
            ++i;
        }
        TokenList raw = Delete.files(data, path);
        ctx.updates.add(new DBDelete(data, raw, this.input), ctx);
        return null;
    }

    private Item rename(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String src = this.path(1, ctx);
        String trg = this.path(2, ctx);
        IntList il = data.docs(src);
        int i = 0;
        int is = il.size();
        while (i < is) {
            int pre = il.get(i);
            String target = Rename.target(data, pre, src, trg);
            if (target.isEmpty()) {
                Err.EMPTYPATH.thrw(this.input, this);
            }
            ctx.updates.add(new ReplaceValue(pre, data, this.input, Token.token(target)), ctx);
            ++i;
        }
        if (data.meta.binary(src) != null && data.meta.binary(trg) != null) {
            ctx.updates.add(new DBRename(data, src, trg, this.input), ctx);
        }
        return null;
    }

    private Item optimize(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        boolean all = this.expr.length == 2 && this.checkBln(this.expr[1], ctx);
        ctx.updates.add(new DBOptimize(data, ctx.context, all, this.input), ctx);
        return null;
    }

    private Item store(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        IOFile file = data.meta.binary(path);
        if (file == null || file.isDir()) {
            Err.RESINV.thrw(this.input, path);
        }
        byte[] val = this.checkBin(this.expr[2], ctx);
        ctx.updates.add(new DBStore(data, Token.token(path), val, this.input), ctx);
        return null;
    }

    private Item retrieve(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        IOFile file = data.meta.binary(path);
        if (file == null || !file.exists() || file.isDir()) {
            Err.RESFNF.thrw(this.input, path);
        }
        return new Raw(file, path);
    }

    private Iter node(QueryContext ctx, final boolean id) throws QueryException {
        return new Iter(ctx){
            final Iter ir;
            {
                this.ir = queryContext.iter(FNDb.this.expr[0]);
            }

            @Override
            public Item next() throws QueryException {
                Item it = this.ir.next();
                if (it == null) {
                    return null;
                }
                DBNode node = FNDb.this.checkDBNode(it);
                return Itr.get(id ? node.data.id(node.pre) : node.pre);
            }
        };
    }

    private Item event(QueryContext ctx) throws QueryException {
        byte[] name = this.checkStr(this.expr[0], ctx);
        ArrayOutput ao = new ArrayOutput();
        try {
            Item it;
            Serializer ser = Serializer.get(ao, ctx.serProp(true));
            ValueIter ir = this.expr[1].value(ctx).iter();
            while ((it = ir.next()) != null) {
                it.serialize(ser);
            }
            ser.close();
        }
        catch (SerializerException ex) {
            throw new QueryException(this.input, ex);
        }
        catch (IOException ex) {
            Err.SERANY.thrw(this.input, ex);
        }
        if (!ctx.context.events.notify(ctx.context, name, ao.toArray())) {
            Err.NOEVENT.thrw(this.input, new Object[]{name});
        }
        return null;
    }

    @Override
    public boolean vacuous() {
        return this.def == Function.DBEVENT;
    }

    @Override
    public boolean uses(Expr.Use u) {
        boolean up;
        boolean bl = up = this.def == Function.DBADD || this.def == Function.DBDELETE || this.def == Function.DBRENAME || this.def == Function.DBREPLACE || this.def == Function.DBOPTIMIZE || this.def == Function.DBSTORE;
        return u == Expr.Use.CTX && (this.def == Function.DBTEXT || this.def == Function.DBATTR || this.def == Function.DBFULLTEXT || this.def == Function.DBEVENT || up) || u == Expr.Use.UPD && up || super.uses(u);
    }

    @Override
    public boolean iterable() {
        return this.def == Function.DBOPEN || this.def == Function.DBTEXT || this.def == Function.DBATTR || this.def == Function.DBFULLTEXT || super.iterable();
    }

    private Data data(int i, QueryContext ctx) throws QueryException {
        Item it = this.checkEmpty(this.expr[i].item(ctx, this.input));
        if (it.node()) {
            return this.checkDBNode((Item)it).data;
        }
        if (it.str()) {
            byte[] name = it.atom(this.input);
            if (!MetaData.validName(Token.string(name), false)) {
                Err.INVDB.thrw(this.input, new Object[]{name});
            }
            return ctx.resource.data(name, this.input);
        }
        throw Err.STRNODTYPE.thrw(this.input, this, it.type);
    }

    private String path(int i, QueryContext ctx) throws QueryException {
        String path = Token.string(this.checkStr(this.expr[i], ctx));
        String norm = MetaData.normPath(path);
        if (norm == null) {
            Err.RESINV.thrw(this.input, path);
        }
        return norm;
    }
}

