/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTIndexAccess;
import org.basex.query.ft.FTWords;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Str;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;

public final class FNFt
extends FuncCall {
    private static final byte[] MARK = Token.token("mark");

    public FNFt(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case FTCOUNT: {
                return this.count(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case FTSEARCH: {
                return this.search(ctx);
            }
            case FTSCORE: {
                return this.score(ctx);
            }
            case FTMARK: {
                return this.mark(ctx, false);
            }
            case FTEXTRACT: {
                return this.mark(ctx, true);
            }
        }
        return super.iter(ctx);
    }

    private Item count(QueryContext ctx) throws QueryException {
        Item it;
        FTPosData tmp = ctx.ftpos;
        ctx.ftpos = new FTPosData();
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            this.checkDBNode(it);
        }
        int s = ctx.ftpos.size();
        ctx.ftpos = tmp;
        return Itr.get(s);
    }

    private Iter mark(final QueryContext ctx, boolean ex) throws QueryException {
        int l;
        byte[] m = MARK;
        int n = l = ex ? 150 : Integer.MAX_VALUE;
        if (this.expr.length > 1 && !XMLToken.isQName(m = this.checkStr(this.expr[1], ctx))) {
            Err.value(this.input, AtomType.QNM, m);
        }
        if (this.expr.length > 2) {
            l = (int)this.checkItr(this.expr[2], ctx);
        }
        final byte[] mark = m;
        final int len = l;
        return new Iter(){
            final FTPosData ftd = new FTPosData();
            Iter ir;
            ValueIter ii;

            @Override
            public Item next() throws QueryException {
                Item it;
                do {
                    if (this.ii != null) {
                        Item it2 = this.ii.next();
                        if (it2 != null) {
                            return it2;
                        }
                        this.ii = null;
                    }
                    FTPosData tmp = ctx.ftpos;
                    ctx.ftpos = this.ftd;
                    if (this.ir == null) {
                        this.ir = ctx.iter(FNFt.this.expr[0]);
                    }
                    if ((it = this.ir.next()) != null) {
                        this.ii = DataBuilder.mark(FNFt.this.checkDBNode(it), mark, len, ctx).iter();
                    }
                    ctx.ftpos = tmp;
                } while (it != null);
                return null;
            }
        };
    }

    private Iter score(QueryContext ctx) throws QueryException {
        return new Iter(ctx){
            final Iter iter;
            {
                this.iter = FNFt.this.expr[0].iter(queryContext);
            }

            @Override
            public Dbl next() throws QueryException {
                Item item = this.iter.next();
                return item == null ? null : Dbl.get(item.score());
            }
        };
    }

    Iter search(QueryContext ctx) throws QueryException {
        return FNFt.search(this.checkDBNode((Item)this.checkItem((Expr)this.expr[0], (QueryContext)ctx)).data, this.checkStr(this.expr[1], ctx), this, ctx);
    }

    static Iter search(Data data, byte[] str, FuncCall fun, QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, data, null, true);
        if (!data.meta.ftindex) {
            Err.NOIDX.thrw(fun.input, fun);
        }
        FTOpt tmp = ctx.ftopt;
        ctx.ftopt = new FTOpt();
        ctx.ftopt.set(FTFlag.CS, data.meta.casesens);
        ctx.ftopt.set(FTFlag.DC, data.meta.diacritics);
        ctx.ftopt.set(FTFlag.ST, data.meta.stemming);
        ctx.ftopt.ln = data.meta.language;
        FTWords words = new FTWords(fun.input, ic.data, Str.get(str), ctx);
        ctx.ftopt = tmp;
        return new FTIndexAccess(fun.input, words, ic).iter(ctx);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && this.def == Function.FTSEARCH || super.uses(u);
    }
}

