/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import java.util.Comparator;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.FItem;
import org.basex.query.item.FuncType;
import org.basex.query.item.Item;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class FNHof
extends FuncCall {
    public FNHof(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case HOFSORTWITH: {
                return this.sortWith(ctx);
            }
            case HOFID: 
            case HOFCONST: {
                return this.expr[0].iter(ctx);
            }
            case HOFUNTIL: {
                return this.until(ctx).iter();
            }
            case HOFITERATE: {
                return this.iterate(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case HOFFOLDLEFT: {
                return this.foldLeft1(ctx);
            }
            case HOFUNTIL: {
                return this.until(ctx);
            }
            case HOFID: 
            case HOFCONST: {
                return this.expr[0].value(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case HOFID: 
            case HOFCONST: {
                return this.expr[0].item(ctx, ii);
            }
        }
        return super.item(ctx, ii);
    }

    private Value foldLeft1(QueryContext ctx) throws QueryException {
        Item x;
        FItem f = this.withArity(0, 2, ctx);
        Iter xs = this.expr[1].iter(ctx);
        Value sum = this.checkEmpty(xs.next());
        while ((x = xs.next()) != null) {
            sum = f.invValue(ctx, this.input, sum, x);
        }
        return sum;
    }

    private ItemCache sortWith(final QueryContext ctx) throws QueryException {
        final FItem lt = this.withArity(0, 2, ctx);
        ItemCache ic = this.expr[1].value(ctx).cache();
        try {
            Arrays.sort(ic.item, 0, (int)ic.size(), new Comparator<Item>(){

                @Override
                public int compare(Item it1, Item it2) {
                    try {
                        return FNHof.this.checkType(lt.invItem(ctx, FNHof.this.input, it1, it2), AtomType.BLN).bool(FNHof.this.input) ? -1 : 1;
                    }
                    catch (QueryException qe) {
                        throw new QueryError(qe);
                    }
                }
            });
        }
        catch (QueryError err) {
            throw err.wrapped();
        }
        return ic;
    }

    private Value until(QueryContext ctx) throws QueryException {
        FItem pred = this.withArity(0, 1, ctx);
        FItem fun = this.withArity(1, 1, ctx);
        Value v = this.expr[2].value(ctx);
        while (!this.checkType(pred.invItem(ctx, this.input, v), AtomType.BLN).bool(this.input)) {
            v = fun.invValue(ctx, this.input, v);
        }
        return v;
    }

    private Iter iterate(final QueryContext ctx) throws QueryException {
        final FItem f = this.withArity(0, 1, ctx);
        return new Iter(){
            Value v;
            long i;
            long len;
            {
                this.v = FNHof.this.expr[1].value(queryContext);
                this.len = this.v.size();
            }

            @Override
            public Item next() throws QueryException {
                while (this.i >= this.len) {
                    this.v = f.invValue(ctx, FNHof.this.input, this.v);
                    this.i = 0L;
                    this.len = this.v.size();
                }
                return this.v.itemAt(this.i++);
            }
        };
    }

    private FItem withArity(int p, int a, QueryContext ctx) throws QueryException {
        Item f = this.checkItem(this.expr[p], ctx);
        if (!f.func() || ((FItem)f).arity() != a) {
            Err.type(this, FuncType.arity(a), f);
        }
        return (FItem)f;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.def == Function.PARTAPP && u == Expr.Use.CTX || u == Expr.Use.X30 || super.uses(u);
    }
}

