/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.Err;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class FNNode
extends FuncCall {
    public FNNode(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = (this.expr.length != 0 ? this.expr[0] : this.checkCtx(ctx)).item(ctx, this.input);
        switch (this.def) {
            case NODENAME: {
                if (it == null) {
                    return null;
                }
                QNm qname = this.checkNode(it).qname();
                return qname != null && qname.atom().length != 0 ? qname : null;
            }
            case DOCURI: {
                if (it == null) {
                    return null;
                }
                byte[] uri = this.checkNode(it).base();
                return uri.length == 0 ? null : Uri.uri(uri);
            }
            case NILLED: {
                if (it == null) {
                    return null;
                }
                return this.checkNode((Item)it).type != NodeType.ELM ? null : Bln.FALSE;
            }
            case BASEURI: {
                if (it == null) {
                    return null;
                }
                ANode n = this.checkNode(it);
                if (n.type != NodeType.ELM && n.type != NodeType.DOC && n.parent() == null) {
                    return null;
                }
                Uri base = Uri.EMPTY;
                while (!base.absolute()) {
                    if (n == null) {
                        base = ctx.baseURI.resolve(base);
                        break;
                    }
                    base = Uri.uri(n.base()).resolve(base);
                    n = n.parent();
                }
                return base;
            }
            case NAME: {
                if (it == null) {
                    return Str.ZERO;
                }
                QNm qname = this.checkNode(it).qname();
                return qname != null ? Str.get(qname.atom()) : Str.ZERO;
            }
            case LOCNAME: {
                if (it == null) {
                    return Str.ZERO;
                }
                QNm qname = this.checkNode(it).qname();
                return qname != null ? Str.get(qname.ln()) : Str.ZERO;
            }
            case NSURI: {
                if (it == null || it.type == NodeType.PI) {
                    return Uri.EMPTY;
                }
                ANode node = this.checkNode(it);
                while (node != null) {
                    int pos;
                    QNm qname = node.qname();
                    if (qname == null) break;
                    if (qname.hasUri()) {
                        return qname.uri();
                    }
                    Atts ns = node.nsScope();
                    if (ns != null && (pos = ns.get(qname.pref())) != -1) {
                        return Uri.uri(ns.val[pos]);
                    }
                    node = node.parent();
                }
                return Uri.uri(ctx.nsElem);
            }
            case ROOT: {
                if (it == null) {
                    return null;
                }
                ANode n = this.checkNode(it);
                while (n.parent() != null) {
                    n = n.parent();
                }
                return n;
            }
            case GENID: {
                return it == null ? Str.ZERO : Str.get(new TokenBuilder(QueryText.ID).addLong(this.checkNode((Item)it).id).finish());
            }
            case CHILDREN: {
                return Bln.get(it != null && this.checkNode(it).hasChildren());
            }
            case PATH: {
                if (it == null) {
                    return null;
                }
                return this.path(it);
            }
        }
        return super.item(ctx, ii);
    }

    private Str path(Item it) throws QueryException {
        TokenList tl = new TokenList();
        ANode n = this.checkNode(it);
        while (n.parent() != null) {
            ANode fs;
            AxisIter ai;
            QNm qnm;
            int i = 1;
            TokenBuilder tb = new TokenBuilder();
            if (n.type == NodeType.ATT) {
                tb.add("@\"");
                qnm = n.qname();
                if (qnm.uri().atom().length != 0) {
                    tb.add(qnm.uri().atom());
                }
                tb.add("\":").add(qnm.ln());
            } else if (n.type == NodeType.ELM) {
                qnm = n.qname();
                ai = n.precSibl();
                while ((fs = ai.next()) != null) {
                    if (!fs.qname().eq(qnm)) continue;
                    ++i;
                }
                tb.addExt("\"%\":%[%]", qnm.uri().atom(), qnm.ln(), i);
            } else if (n.type == NodeType.COM || n.type == NodeType.TXT) {
                ANode fs2;
                AxisIter ai2 = n.precSibl();
                while ((fs2 = ai2.next()) != null) {
                    if (fs2.type != n.type) continue;
                    ++i;
                }
                tb.addExt(n.type() + "[%]", i);
            } else if (n.type == NodeType.PI) {
                qnm = n.qname();
                ai = n.precSibl();
                while ((fs = ai.next()) != null) {
                    if (fs.type != n.type || !fs.qname().eq(qnm)) continue;
                    ++i;
                }
                tb.addExt("%(\"%\")[%]", n.type.nam(), qnm.ln(), i);
            }
            tl.add(tb.finish());
            n = n.parent();
        }
        if (n.type != NodeType.DOC) {
            Err.IDDOC.thrw(this.input, new Object[0]);
        }
        TokenBuilder tb = new TokenBuilder();
        int i = tl.size() - 1;
        while (i >= 0) {
            tb.add(47).add(tl.get(i));
            --i;
        }
        return Str.get(tb.size() == 0 ? Token.SLASH : tb.finish());
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && (this.def == Function.GENID || this.expr.length == 0 && (this.def == Function.DOCURI || this.def == Function.NODENAME)) || u == Expr.Use.CTX && this.expr.length == 0 || super.uses(u);
    }
}

