/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.basex.build.Parser;
import org.basex.build.file.HTMLParser;
import org.basex.core.Prop;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.io.in.TextInput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.B64;
import org.basex.query.item.DBNode;
import org.basex.query.item.FAttr;
import org.basex.query.item.FElem;
import org.basex.query.item.Hex;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ByteList;
import org.basex.util.list.StringList;

public final class FNZip
extends FuncCall {
    private static final Uri U_ZIP = Uri.uri(QueryText.ZIPURI);
    private static final QNm E_FILE = new QNm(Token.token("zip:file"), U_ZIP);
    private static final QNm E_DIR = new QNm(Token.token("zip:dir"), U_ZIP);
    private static final QNm E_ENTRY = new QNm(Token.token("zip:entry"), U_ZIP);
    private static final QNm A_HREF = new QNm(Token.token("href"));
    private static final QNm A_NAME = new QNm(Token.token("name"));
    private static final QNm A_SRC = new QNm(Token.token("src"));
    private static final QNm A_METHOD = new QNm(Token.token("method"));
    private static final String M_BASE64 = "base64";
    private static final String M_HEX = "hex";

    public FNZip(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkAdmin(ctx);
        switch (this.def) {
            case ZIPBIN: {
                return this.binaryEntry(ctx);
            }
            case ZIPTEXT: {
                return this.textEntry(ctx);
            }
            case ZIPHTML: {
                return this.xmlEntry(ctx, true);
            }
            case ZIPXML: {
                return this.xmlEntry(ctx, false);
            }
            case ZIPENTRIES: {
                return this.entries(ctx);
            }
            case ZIPFILE: {
                return this.zipFile(ctx);
            }
            case ZIPUPDATE: {
                return this.updateEntries(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private B64 binaryEntry(QueryContext ctx) throws QueryException {
        return new B64(this.entry(ctx));
    }

    private Str textEntry(QueryContext ctx) throws QueryException {
        String enc = this.expr.length < 3 ? null : Token.string(this.checkStr(this.expr[2], ctx));
        IOContent io = new IOContent(this.entry(ctx));
        try {
            return Str.get(TextInput.content(io, enc).finish());
        }
        catch (IOException ex) {
            throw Err.ZIPFAIL.thrw(this.input, ex.getMessage());
        }
    }

    private ANode xmlEntry(QueryContext ctx, boolean html) throws QueryException {
        Prop prop = ctx.context.prop;
        IOContent io = new IOContent(this.entry(ctx));
        try {
            return new DBNode(html ? new HTMLParser(io, "", prop) : Parser.xmlParser(io, prop), prop);
        }
        catch (IOException ex) {
            throw Err.SAXERR.thrw(this.input, ex);
        }
    }

    private ANode entries(QueryContext ctx) throws QueryException {
        String file = Token.string(this.checkStr(this.expr[0], ctx));
        IOFile path = new IOFile(file);
        if (!path.exists()) {
            Err.ZIPNOTFOUND.thrw(this.input, file);
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            FElem root = new FElem(E_FILE, new Atts().add(QueryText.ZIP, QueryText.ZIPURI), null);
            root.add(new FAttr(A_HREF, Token.token(path.path())));
            this.createEntries(this.paths(zf).iterator(), root, "");
            FElem fElem = root;
            return fElem;
        }
        catch (IOException ex) {
            throw Err.ZIPFAIL.thrw(this.input, ex.getMessage());
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String createEntries(Iterator<String> it, FElem par, String pref) {
        String path = null;
        boolean curr = false;
        while (curr || it.hasNext()) {
            if (!curr) {
                path = it.next();
                curr = true;
            }
            if (path == null) break;
            if (!path.startsWith(pref)) {
                return path;
            }
            int i = path.lastIndexOf(47);
            String dir = i == -1 ? path : path.substring(0, i);
            String name = path.substring(i + 1);
            if (name.isEmpty()) {
                path = this.createEntries(it, this.createDir(par, dir), dir);
                continue;
            }
            this.createFile(par, name);
            curr = false;
        }
        return null;
    }

    private FElem createDir(FElem par, String name) {
        FElem e = new FElem(E_DIR);
        e.add(new FAttr(A_NAME, Token.token(name)));
        par.add(e);
        return e;
    }

    private void createFile(FElem par, String name) {
        FElem e = new FElem(E_ENTRY);
        e.add(new FAttr(A_NAME, Token.token(name)));
        par.add(e);
    }

    private Item zipFile(QueryContext ctx) throws QueryException {
        block15: {
            ANode elm = (ANode)this.checkType(this.expr[0].item(ctx, this.input), NodeType.ELM);
            if (!elm.qname().eq(E_FILE)) {
                Err.ZIPUNKNOWN.thrw(this.input, elm.qname());
            }
            String file = this.attribute(elm, A_HREF, true);
            FileOutputStream fos = null;
            boolean ok = true;
            try {
                try {
                    fos = new FileOutputStream(file);
                    ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));
                    this.create(zos, elm.children(), "", null, ctx);
                    zos.close();
                }
                catch (IOException ex) {
                    ok = false;
                    Err.ZIPFAIL.thrw(this.input, ex.getMessage());
                    if (fos == null) break block15;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!ok) {
                        new IOFile(file).delete();
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                    if (!ok) {
                        new IOFile(file).delete();
                    }
                }
            }
        }
        return null;
    }

    private void create(ZipOutputStream zos, AxisIter ai, String root, ZipFile zf, QueryContext ctx) throws QueryException, IOException {
        ANode node;
        byte[] data = new byte[4096];
        while ((node = ai.next()) != null) {
            QNm mode = node.qname();
            boolean dir = mode.eq(E_DIR);
            if (!dir && !mode.eq(E_ENTRY)) {
                Err.ZIPUNKNOWN.thrw(this.input, mode);
            }
            String name = this.attribute(node, A_NAME, false);
            String src = this.attribute(node, A_SRC, false);
            if (src != null) {
                src = src.replaceAll("\\\\", "/");
            }
            if (name == null) {
                if (src == null) {
                    throw Err.ZIPINVALID.thrw(this.input, node.qname(), A_SRC);
                }
                name = src;
            }
            name = name.replaceAll(".*/", "");
            if (dir) {
                name = String.valueOf(name) + '/';
            }
            zos.putNextEntry(new ZipEntry(String.valueOf(root) + name));
            if (dir) {
                this.create(zos, node.children(), String.valueOf(root) + name, zf, ctx);
                continue;
            }
            if (src != null) {
                if (!new IOFile(src).exists()) {
                    Err.ZIPNOTFOUND.thrw(this.input, src);
                }
                BufferedInputStream bis = null;
                try {
                    int c;
                    bis = new BufferedInputStream(new FileInputStream(src));
                    while ((c = bis.read(data)) != -1) {
                        zos.write(data, 0, c);
                    }
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            AxisMoreIter ch = node.children();
            String m = this.attribute(node, A_METHOD, false);
            ANode n = ch.next();
            ZipEntry ze = null;
            if (zf != null && n == null) {
                ze = zf.getEntry(String.valueOf(root) + name);
            }
            if (ze != null) {
                int c;
                InputStream zis = zf.getInputStream(ze);
                while ((c = zis.read(data)) != -1) {
                    zos.write(data, 0, c);
                }
            } else if (n != null) {
                boolean hex = M_HEX.equals(m);
                if (hex || M_BASE64.equals(m)) {
                    ByteList bl = new ByteList();
                    do {
                        bl.add(n.atom());
                    } while ((n = ch.next()) != null);
                    byte[] bytes = bl.toArray();
                    zos.write((hex ? new Hex(bytes) : new B64(bytes)).toJava());
                } else {
                    try {
                        Serializer ser = Serializer.get(zos, this.serPar(node, ctx));
                        do {
                            DataBuilder.stripNS(n, QueryText.ZIPURI, ctx).serialize(ser);
                        } while ((n = ch.next()) != null);
                        ser.close();
                    }
                    catch (SerializerException ex) {
                        throw new QueryException(this.input, ex);
                    }
                }
            }
            zos.closeEntry();
        }
    }

    private SerializerProp serPar(ANode node, QueryContext ctx) throws SerializerException {
        ANode at;
        TokenBuilder tb = new TokenBuilder();
        AxisIter ati = node.attributes();
        while ((at = ati.next()) != null) {
            QNm name = at.qname();
            if (name.eq(A_NAME) || name.eq(A_SRC)) continue;
            if (tb.size() != 0) {
                tb.add(44);
            }
            tb.add(name.ln()).add(61).add(at.atom());
        }
        return tb.size() == 0 ? ctx.serProp(true) : new SerializerProp(tb.toString());
    }

    private Item updateEntries(QueryContext ctx) throws QueryException {
        block27: {
            IOFile out;
            ANode elm = (ANode)this.checkType(this.expr[0].item(ctx, this.input), NodeType.ELM);
            if (!elm.qname().eq(E_FILE)) {
                Err.ZIPUNKNOWN.thrw(this.input, elm.qname());
            }
            String in = this.attribute(elm, A_HREF, true);
            IOFile target = new IOFile(Token.string(this.checkStr(this.expr[1], ctx)));
            while ((out = new IOFile(String.valueOf(target.path()) + new Random().nextInt(Integer.MAX_VALUE))).exists()) {
            }
            if (!new IOFile(in).exists()) {
                Err.ZIPNOTFOUND.thrw(this.input, in);
            }
            ZipFile zf = null;
            boolean ok = true;
            try {
                try {
                    zf = new ZipFile(in);
                    FileOutputStream fos = null;
                    try {
                        try {
                            fos = new FileOutputStream(out.path());
                            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));
                            this.create(zos, elm.children(), "", zf, ctx);
                            zos.close();
                        }
                        catch (IOException ex) {
                            ok = false;
                            Err.ZIPFAIL.thrw(this.input, ex.getMessage());
                            if (fos == null) break block27;
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (IOException ex) {
                    throw Err.ZIPFAIL.thrw(this.input, ex.getMessage());
                }
            }
            finally {
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {}
                }
                if (ok) {
                    target.delete();
                    out.rename(target);
                } else {
                    out.delete();
                }
            }
        }
        return null;
    }

    private StringList paths(ZipFile zf) {
        TreeSet<String> paths = new TreeSet<String>();
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            String name = ze.getName();
            int i = name.lastIndexOf(47);
            if (i > -1 && i + 1 < name.length()) {
                paths.add(name.substring(0, i + 1));
            }
            paths.add(name);
        }
        StringList sl = new StringList();
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            sl.add((String)it.next());
        }
        return sl;
    }

    private String attribute(ANode elm, QNm name, boolean force) throws QueryException {
        byte[] val = elm.attribute(name);
        if (val == null && force) {
            throw Err.ZIPINVALID.thrw(this.input, elm.qname(), name);
        }
        return val == null ? null : Token.string(val);
    }

    private byte[] entry(QueryContext ctx) throws QueryException {
        IOFile file = new IOFile(Token.string(this.checkStr(this.expr[0], ctx)));
        String path = Token.string(this.checkStr(this.expr[1], ctx));
        if (!file.exists()) {
            Err.ZIPNOTFOUND.thrw(this.input, file);
        }
        try {
            return new Zip(file).read(path);
        }
        catch (FileNotFoundException ex) {
            throw Err.ZIPNOTFOUND.thrw(this.input, file + "/" + path);
        }
        catch (IOException ex) {
            throw Err.ZIPFAIL.thrw(this.input, ex.getMessage());
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX;
    }
}

