/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.Atm;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.item.map.Map;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;

public abstract class FuncCall
extends Arr {
    private static final Uri U_OUTPUT = Uri.uri(QueryText.OUTPUTURI);
    private static final QNm E_PARAM = new QNm(Token.token("serialization-parameters"), U_OUTPUT);
    private static final QNm A_VALUE = new QNm(Token.token("value"));
    public Function def;

    protected FuncCall(InputInfo ii, Function fd, Expr ... args) {
        super(ii, args);
        this.def = fd;
        this.type = this.def.ret;
    }

    @Override
    public final Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        if (this.uses(Expr.Use.CTX) || !this.values()) {
            return this.optPre(this.cmp(ctx), ctx);
        }
        return this.optPre(this.def.ret.zeroOrOne() ? this.item(ctx, this.input) : this.value(ctx), ctx);
    }

    public Expr cmp(QueryContext ctx) throws QueryException {
        return this;
    }

    protected final Item atom(Item it) throws QueryException {
        return it.node() ? (it.type == NodeType.PI || it.type == NodeType.COM ? Str.get(it.atom(this.input)) : new Atm(it.atom(this.input))) : it;
    }

    @Override
    public final boolean isFun(Function f) {
        return this.def == f;
    }

    @Override
    public final String desc() {
        return this.def.toString();
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.NAM, Token.token(this.def.desc)});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr arg = exprArray[n2];
            arg.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public final String toString() {
        String desc = this.def.toString();
        return new TokenBuilder().add(desc.substring(0, desc.indexOf(40) + 1)).addSep(this.expr, ", ").add(")").toString();
    }

    static SerializerProp serialPar(FuncCall fun, int arg, QueryContext ctx) throws SerializerException, QueryException {
        Item it;
        TokenObjMap<Object> tm = new TokenObjMap();
        if (arg < fun.expr.length && (it = fun.expr[arg].item(ctx, fun.input)) != null) {
            if (it instanceof Map) {
                tm = ((Map)it).tokenJavaMap(fun.input);
            } else {
                ANode n = (ANode)fun.checkType(it, NodeType.ELM);
                if (!n.qname().eq(E_PARAM)) {
                    Err.SERUNKNOWN.thrw(fun.input, n.qname());
                }
                AxisMoreIter ai = n.children();
                while ((n = ai.next()) != null) {
                    byte[] val;
                    QNm qn = n.qname();
                    if (!qn.uri().eq(U_OUTPUT)) {
                        Err.SERUNKNOWN.thrw(fun.input, qn);
                    }
                    if ((val = n.attribute(A_VALUE)) == null) {
                        Err.SERNOVAL.thrw(fun.input, new Object[0]);
                    }
                    tm.add(qn.ln(), val);
                }
            }
        }
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : tm) {
            if (tb.size() != 0) {
                tb.add(44);
            }
            tb.add(key).add(61).addExt(tm.get(key), new Object[0]);
        }
        return tb.size() == 0 ? ctx.serProp(true) : new SerializerProp(tb.toString());
    }
}

