/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.HashMap;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNAcc;
import org.basex.query.func.FNAggr;
import org.basex.query.func.FNContext;
import org.basex.query.func.FNCrypto;
import org.basex.query.func.FNDate;
import org.basex.query.func.FNDb;
import org.basex.query.func.FNFile;
import org.basex.query.func.FNFormat;
import org.basex.query.func.FNFt;
import org.basex.query.func.FNFunc;
import org.basex.query.func.FNGen;
import org.basex.query.func.FNHof;
import org.basex.query.func.FNHttp;
import org.basex.query.func.FNId;
import org.basex.query.func.FNInfo;
import org.basex.query.func.FNJson;
import org.basex.query.func.FNMap;
import org.basex.query.func.FNMath;
import org.basex.query.func.FNNode;
import org.basex.query.func.FNNum;
import org.basex.query.func.FNPat;
import org.basex.query.func.FNQName;
import org.basex.query.func.FNSent;
import org.basex.query.func.FNSeq;
import org.basex.query.func.FNSimple;
import org.basex.query.func.FNSql;
import org.basex.query.func.FNStr;
import org.basex.query.func.FNUtil;
import org.basex.query.func.FNXslt;
import org.basex.query.func.FNZip;
import org.basex.query.func.FuncCall;
import org.basex.query.item.FuncType;
import org.basex.query.item.SeqType;
import org.basex.query.util.NSGlobal;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.TokenBuilder;

public enum Function {
    POS(FNAcc.class, "position()", SeqType.ITR, new SeqType[0]),
    LAST(FNAcc.class, "last()", SeqType.ITR, new SeqType[0]),
    STRING(FNAcc.class, "string([item])", SeqType.STR, 0, SeqType.ITEM_ZO),
    NUMBER(FNAcc.class, "number([item])", SeqType.DBL, 0, SeqType.AAT_ZO),
    STRLEN(FNAcc.class, "string-length([item])", SeqType.ITR, 0, SeqType.STR_ZO),
    NORMSPC(FNAcc.class, "normalize-space([string])", SeqType.STR, 0, SeqType.STR_ZO),
    URIQNM(FNAcc.class, "namespace-uri-from-QName(qname)", SeqType.URI_ZO, SeqType.QNM_ZO),
    AVG(FNAggr.class, "avg(item)", SeqType.AAT_ZO, SeqType.AAT_ZM),
    COUNT(FNAggr.class, "count(item)", SeqType.ITR, SeqType.ITEM_ZM),
    MAX(FNAggr.class, "max(item[,coll])", SeqType.AAT_ZO, 1, SeqType.AAT_ZM, SeqType.STR),
    MIN(FNAggr.class, "min(item[,coll])", SeqType.AAT_ZO, 1, SeqType.AAT_ZM, SeqType.STR),
    SUM(FNAggr.class, "sum(item[,zero])", SeqType.AAT_ZO, 1, SeqType.AAT_ZM, SeqType.AAT_ZO),
    CURRDATE(FNContext.class, "current-date()", SeqType.DAT, new SeqType[0]),
    CURRDTM(FNContext.class, "current-dateTime()", SeqType.DTM, new SeqType[0]),
    CURRTIME(FNContext.class, "current-time()", SeqType.TIM, new SeqType[0]),
    IMPLZONE(FNContext.class, "implicit-timezone()", SeqType.DTD, new SeqType[0]),
    COLLAT(FNContext.class, "default-collation()", SeqType.STR, new SeqType[0]),
    STBASEURI(FNContext.class, "static-base-uri()", SeqType.URI_ZO, new SeqType[0]),
    DAYDAT(FNDate.class, "day-from-date(item)", SeqType.ITR_ZO, SeqType.DAT_ZO),
    DAYDTM(FNDate.class, "day-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    DAYDUR(FNDate.class, "days-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    HOUDTM(FNDate.class, "hours-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    HOUDUR(FNDate.class, "hours-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    HOUTIM(FNDate.class, "hours-from-time(item)", SeqType.ITR_ZO, SeqType.TIM_ZO),
    MINDTM(FNDate.class, "minutes-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    MINDUR(FNDate.class, "minutes-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    MINTIM(FNDate.class, "minutes-from-time(item)", SeqType.ITR_ZO, SeqType.TIM_ZO),
    MONDAT(FNDate.class, "month-from-date(item)", SeqType.ITR_ZO, SeqType.DAT_ZO),
    MONDTM(FNDate.class, "month-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    MONDUR(FNDate.class, "months-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    SECDTM(FNDate.class, "seconds-from-dateTime(datetime)", SeqType.DEC_ZO, SeqType.DTM_ZO),
    SECDUR(FNDate.class, "seconds-from-duration(dur)", SeqType.DEC_ZO, SeqType.DUR_ZO),
    SECTIM(FNDate.class, "seconds-from-time(item)", SeqType.DEC_ZO, SeqType.TIM_ZO),
    ZONDAT(FNDate.class, "timezone-from-date(item)", SeqType.DTD_ZO, SeqType.DAT_ZO),
    ZONDTM(FNDate.class, "timezone-from-dateTime(item)", SeqType.DTD_ZO, SeqType.DTM_ZO),
    ZONTIM(FNDate.class, "timezone-from-time(item)", SeqType.DTD_ZO, SeqType.TIM_ZO),
    YEADAT(FNDate.class, "year-from-date(item)", SeqType.ITR_ZO, SeqType.DAT_ZO),
    YEADTM(FNDate.class, "year-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    YEADUR(FNDate.class, "years-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    DATZON(FNDate.class, "adjust-date-to-timezone(date[,zone])", SeqType.DAT_ZO, 1, SeqType.DAT_ZO, SeqType.DTD_ZO),
    DTMZON(FNDate.class, "adjust-dateTime-to-timezone(date[,zone])", SeqType.DTM, 1, SeqType.DTM_ZO, SeqType.DTD_ZO),
    TIMZON(FNDate.class, "adjust-time-to-timezone(date[,zone])", SeqType.TIM_ZO, 1, SeqType.TIM_ZO, SeqType.DTD_ZO),
    DATETIME(FNDate.class, "dateTime(date,time)", SeqType.DTM_ZO, SeqType.DAT_ZO, SeqType.TIM_ZO),
    FORMINT(FNFormat.class, "format-integer(number,picture[,lang])", SeqType.STR, 2, SeqType.ITR_ZO, SeqType.STR, SeqType.STR),
    FORMNUM(FNFormat.class, "format-number(number,picture[,format])", SeqType.STR, 2, SeqType.ITR_ZO, SeqType.STR, SeqType.STR),
    FORMDTM(FNFormat.class, "format-dateTime(number,picture,[lang[,cal[,place]]])", SeqType.STR_ZO, 2, SeqType.DTM_ZO, SeqType.STR, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    FORMDAT(FNFormat.class, "format-date(date,picture,[lang[,cal[,place]]])", SeqType.STR_ZO, 2, SeqType.DAT_ZO, SeqType.STR, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    FORMTIM(FNFormat.class, "format-time(number,picture,[lang[,cal[,place]]])", SeqType.STR_ZO, 2, SeqType.TIM_ZO, SeqType.STR, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    FILTER(FNFunc.class, "filter(function,seq)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM}, SeqType.BLN).seq(), SeqType.ITEM_ZM),
    FUNCNAME(FNFunc.class, "function-name(function)", SeqType.QNM_ZO, FuncType.ANY_FUN.seq()),
    FUNCARITY(FNFunc.class, "function-arity(function)", SeqType.ITR, FuncType.ANY_FUN.seq()),
    MAP(FNFunc.class, "map(function,seq)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM}, SeqType.ITEM_ZM).seq(), SeqType.ITEM_ZM),
    MAPPAIRS(FNFunc.class, "map-pairs(function,seq1,seq2)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM, SeqType.ITEM}, SeqType.ITEM_ZM).seq(), SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    FOLDLEFT(FNFunc.class, "fold-left(function,zero,seq)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM_ZM, SeqType.ITEM}, SeqType.ITEM_ZM).seq(), SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    FOLDRIGHT(FNFunc.class, "fold-right(function,zero,seq)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM, SeqType.ITEM_ZM}, SeqType.ITEM_ZM).seq(), SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    PARTAPP(FNFunc.class, "partial-apply(function,arg[,pos])", SeqType.FUN_O, 2, SeqType.FUN_O, SeqType.ITEM_ZM, SeqType.ITR),
    DATA(FNGen.class, "data([item])", SeqType.AAT_ZM, 0, SeqType.ITEM_ZM),
    COLL(FNGen.class, "collection([uri])", SeqType.NOD_ZM, 0, SeqType.STR_ZO),
    DOC(FNGen.class, "doc(uri)", SeqType.DOC_ZO, SeqType.STR_ZO),
    DOCAVL(FNGen.class, "doc-available(uri)", SeqType.BLN, SeqType.STR_ZO),
    PUT(FNGen.class, "put(node,path)", SeqType.EMP, SeqType.NOD, SeqType.STR_ZO),
    PARSETXT(FNGen.class, "unparsed-text(uri[,encoding])", SeqType.STR_ZO, 1, SeqType.STR_ZO, SeqType.STR),
    PARSETXTLIN(FNGen.class, "unparsed-text-lines(uri[,encoding])", SeqType.STR_ZM, 1, SeqType.STR_ZO, SeqType.STR),
    PARSETXTAVL(FNGen.class, "unparsed-text-available(uri[,encoding])", SeqType.BLN, 1, SeqType.STR_ZO, SeqType.STR),
    PARSEXML(FNGen.class, "parse-xml(string[,base])", SeqType.DOC_O, 1, SeqType.STR_ZO, SeqType.STR),
    URICOLL(FNGen.class, "uri-collection([uri])", SeqType.URI_ZM, 0, SeqType.STR_ZO),
    SERIALIZE(FNGen.class, "serialize(node[,params])", SeqType.STR, 1, SeqType.ITEM_ZM, SeqType.ITEM),
    ID(FNId.class, "id(string[,item])", SeqType.ELM_ZM, 1, SeqType.STR_ZM, SeqType.NOD),
    IDREF(FNId.class, "idref(string[,item])", SeqType.NOD_ZM, 1, SeqType.STR_ZM, SeqType.NOD),
    LANG(FNId.class, "lang(string[,item])", SeqType.BLN, 1, SeqType.STR_ZO, SeqType.NOD),
    ELID(FNId.class, "element-with-id(string[,item])", SeqType.ELM_ZM, 1, SeqType.STR_ZM, SeqType.NOD),
    ERROR(FNInfo.class, "error([code[,desc[,object]]])", SeqType.EMP, 0, SeqType.QNM_ZO, SeqType.STR, SeqType.ITEM_ZM),
    TRACE(FNInfo.class, "trace(item,msg)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.STR),
    ENVAR(FNInfo.class, "environment-variable(string)", SeqType.STR_ZO, SeqType.STR),
    ENVARS(FNInfo.class, "available-environment-variables()", SeqType.STR_ZM, new SeqType[0]),
    DOCURI(FNNode.class, "document-uri([node])", SeqType.URI_ZO, 0, SeqType.NOD_ZO),
    NILLED(FNNode.class, "nilled(node)", SeqType.BLN_ZO, SeqType.NOD_ZO),
    NODENAME(FNNode.class, "node-name([node])", SeqType.QNM_ZO, 0, SeqType.NOD_ZO),
    LOCNAME(FNNode.class, "local-name([node])", SeqType.STR, 0, SeqType.NOD_ZO),
    NAME(FNNode.class, "name([node])", SeqType.STR, 0, SeqType.NOD_ZO),
    NSURI(FNNode.class, "namespace-uri([node])", SeqType.URI, 0, SeqType.NOD_ZO),
    ROOT(FNNode.class, "root([node])", SeqType.NOD_ZO, 0, SeqType.NOD_ZO),
    BASEURI(FNNode.class, "base-uri([node])", SeqType.URI_ZO, 0, SeqType.NOD_ZO),
    GENID(FNNode.class, "generate-id([node])", SeqType.STR, 0, SeqType.NOD_ZO),
    CHILDREN(FNNode.class, "has-children(node)", SeqType.BLN, SeqType.NOD_ZM),
    PATH(FNNode.class, "path([node])", SeqType.STR_ZO, 0, SeqType.NOD_ZO),
    ABS(FNNum.class, "abs(num)", SeqType.AAT_ZO, SeqType.AAT_ZO),
    CEIL(FNNum.class, "ceiling(num)", SeqType.AAT_ZO, SeqType.AAT_ZO),
    FLOOR(FNNum.class, "floor(num)", SeqType.AAT_ZO, SeqType.AAT_ZO),
    ROUND(FNNum.class, "round(num[,prec])", SeqType.AAT_ZO, 1, SeqType.AAT_ZO, SeqType.ITR),
    RNDHLF(FNNum.class, "round-half-to-even(num[,prec])", SeqType.AAT_ZO, 1, SeqType.AAT_ZO, SeqType.ITR),
    MATCH(FNPat.class, "matches(item,pattern[,mod])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    REPLACE(FNPat.class, "replace(item,pattern,replace[,mod])", SeqType.STR, 3, SeqType.STR_ZO, SeqType.STR, SeqType.STR, SeqType.STR),
    TOKEN(FNPat.class, "tokenize(item,pattern[,mod])", SeqType.STR_ZM, 2, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    ANALZYE(FNPat.class, "analyze-string(input,pattern[,mod])", SeqType.ELM, 2, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    INSCOPE(FNQName.class, "in-scope-prefixes(elem)", SeqType.STR_ZM, SeqType.ELM),
    LOCNAMEQNAME(FNQName.class, "local-name-from-QName(qname)", SeqType.NCN_ZO, SeqType.QNM_ZO),
    NSURIPRE(FNQName.class, "namespace-uri-for-prefix(pref,elem)", SeqType.URI_ZO, SeqType.STR_ZO, SeqType.ELM),
    QNAME(FNQName.class, "QName(uri,name)", SeqType.QNM, SeqType.STR_ZO, SeqType.STR),
    PREQNAME(FNQName.class, "prefix-from-QName(qname)", SeqType.NCN_ZO, SeqType.QNM_ZO),
    RESQNAME(FNQName.class, "resolve-QName(item,base)", SeqType.QNM_ZO, SeqType.STR_ZO, SeqType.ELM),
    RESURI(FNQName.class, "resolve-uri(name[,elem])", SeqType.URI_ZO, 1, SeqType.STR_ZO, SeqType.STR),
    DISTINCT(FNSeq.class, "distinct-values(items[,coll])", SeqType.AAT_ZM, 1, SeqType.AAT_ZM, SeqType.STR),
    INDEXOF(FNSeq.class, "index-of(items,item[,coll])", SeqType.ITR_ZM, 2, SeqType.AAT_ZM, SeqType.AAT, SeqType.STR),
    INSBEF(FNSeq.class, "insert-before(items,pos,insert)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITR, SeqType.ITEM_ZM),
    REMOVE(FNSeq.class, "remove(items,pos)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITR),
    REVERSE(FNSeq.class, "reverse(items)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    SUBSEQ(FNSeq.class, "subsequence(items,start[,len])", SeqType.ITEM_ZM, 2, SeqType.ITEM_ZM, SeqType.DBL, SeqType.DBL),
    HEAD(FNSeq.class, "head(items)", SeqType.ITEM_ZO, SeqType.ITEM_ZM),
    TAIL(FNSeq.class, "tail(items)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    OUTERMOST(FNSeq.class, "outermost(nodes)", SeqType.NOD_ZM, SeqType.NOD_ZM),
    INNERMOST(FNSeq.class, "innermost(nodes)", SeqType.NOD_ZM, SeqType.NOD_ZM),
    FALSE(FNSimple.class, "false()", SeqType.BLN, new SeqType[0]),
    TRUE(FNSimple.class, "true()", SeqType.BLN, new SeqType[0]),
    BOOLEAN(FNSimple.class, "boolean(item)", SeqType.BLN, SeqType.ITEM_ZM),
    NOT(FNSimple.class, "not(item)", SeqType.BLN, SeqType.ITEM_ZM),
    EMPTY(FNSimple.class, "empty(item)", SeqType.BLN, SeqType.ITEM_ZM),
    EXISTS(FNSimple.class, "exists(item)", SeqType.BLN, SeqType.ITEM_ZM),
    UNORDER(FNSimple.class, "unordered(item)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    ZEROORONE(FNSimple.class, "zero-or-one(item)", SeqType.ITEM_ZO, SeqType.ITEM_ZM),
    EXACTLYONE(FNSimple.class, "exactly-one(item)", SeqType.ITEM, SeqType.ITEM_ZM),
    ONEORMORE(FNSimple.class, "one-or-more(item)", SeqType.ITEM_OM, SeqType.ITEM_ZM),
    DEEPEQUAL(FNSimple.class, "deep-equal(item,item[,coll])", SeqType.BLN, 2, SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.STR),
    CODEPNT(FNStr.class, "codepoint-equal(string,string)", SeqType.BLN_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    CODESTR(FNStr.class, "codepoints-to-string(nums)", SeqType.STR, SeqType.ITR_ZM),
    COMPARE(FNStr.class, "compare(first,second[,coll])", SeqType.ITR_ZO, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    CONCAT(FNStr.class, "concat(atom,atom[,...])", SeqType.STR, -2, SeqType.AAT_ZO, SeqType.AAT_ZO),
    CONTAINS(FNStr.class, "contains(string,sub[,coll])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    ENCURI(FNStr.class, "encode-for-uri(string)", SeqType.STR, SeqType.STR_ZO),
    ENDS(FNStr.class, "ends-with(string,sub[,coll])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    ESCURI(FNStr.class, "escape-html-uri(string)", SeqType.STR, SeqType.STR_ZO),
    IRIURI(FNStr.class, "iri-to-uri(string)", SeqType.STR, SeqType.STR_ZO),
    LOWER(FNStr.class, "lower-case(string)", SeqType.STR, SeqType.STR_ZO),
    NORMUNI(FNStr.class, "normalize-unicode(string[,form])", SeqType.STR, 1, SeqType.STR_ZO, SeqType.STR),
    STARTS(FNStr.class, "starts-with(string,sub[,coll])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    STRJOIN(FNStr.class, "string-join(strings[,sep])", SeqType.STR, 1, SeqType.STR_ZM, SeqType.STR),
    STCODE(FNStr.class, "string-to-codepoints(string)", SeqType.ITR_ZM, SeqType.STR_ZO),
    SUBSTR(FNStr.class, "substring(string,start[,len])", SeqType.STR, 2, SeqType.STR_ZO, SeqType.DBL, SeqType.DBL),
    SUBAFTER(FNStr.class, "substring-after(string,sub[,coll])", SeqType.STR, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    SUBBEFORE(FNStr.class, "substring-before(string,sub[,coll])", SeqType.STR, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    TRANS(FNStr.class, "translate(string,map,trans)", SeqType.STR, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    UPPER(FNStr.class, "upper-case(string)", SeqType.STR, SeqType.STR_ZO),
    MAPNEW(FNMap.class, "new([maps[,coll]])", SeqType.MAP_O, 0, SeqType.MAP_ZM, SeqType.STR),
    MAPENTRY(FNMap.class, "entry(key,value)", SeqType.MAP_O, SeqType.AAT, SeqType.ITEM_ZM),
    MAPGET(FNMap.class, "get(map,key)", SeqType.ITEM_ZM, SeqType.MAP_O, SeqType.AAT),
    MAPCONT(FNMap.class, "contains(map,key)", SeqType.BLN, SeqType.MAP_O, SeqType.AAT),
    MAPREM(FNMap.class, "remove(map,key)", SeqType.MAP_O, SeqType.MAP_O, SeqType.AAT),
    MAPSIZE(FNMap.class, "size(map)", SeqType.ITR, SeqType.MAP_O),
    MAPKEYS(FNMap.class, "keys(map)", SeqType.AAT_ZM, SeqType.MAP_O),
    MAPCOLL(FNMap.class, "collation(map)", SeqType.STR, SeqType.MAP_O),
    PI(FNMath.class, "pi()", SeqType.DBL, new SeqType[0]),
    SQRT(FNMath.class, "sqrt(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    SIN(FNMath.class, "sin(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    COS(FNMath.class, "cos(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    TAN(FNMath.class, "tan(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    ASIN(FNMath.class, "asin(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    ACOS(FNMath.class, "acos(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    ATAN(FNMath.class, "atan(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    ATAN2(FNMath.class, "atan2(number,number)", SeqType.DBL, SeqType.DBL, SeqType.DBL),
    POW(FNMath.class, "pow(number,number)", SeqType.DBL_ZO, SeqType.DBL_ZO, SeqType.ITR),
    EXP(FNMath.class, "exp(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    EXP10(FNMath.class, "exp10(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    LOG(FNMath.class, "log(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    LOG10(FNMath.class, "log10(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    RANDOM(FNMath.class, "random()", SeqType.DBL, new SeqType[0]),
    E(FNMath.class, "e()", SeqType.DBL, new SeqType[0]),
    SINH(FNMath.class, "sinh(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    COSH(FNMath.class, "cosh(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    TANH(FNMath.class, "tanh(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    DBOPEN(FNDb.class, "open(database[,path])", SeqType.NOD_ZM, 1, SeqType.STR, SeqType.STR),
    DBOPENPRE(FNDb.class, "open-pre(database,pre)", SeqType.NOD_ZM, SeqType.ITEM, SeqType.ITR),
    DBOPENID(FNDb.class, "open-id(database,id)", SeqType.NOD_ZM, SeqType.ITEM, SeqType.ITR),
    DBTEXT(FNDb.class, "text(database,string)", SeqType.NOD_ZM, SeqType.ITEM, SeqType.ITEM),
    DBATTR(FNDb.class, "attribute(database,string[,name])", SeqType.NOD_ZM, 2, SeqType.ITEM, SeqType.ITEM, SeqType.STR),
    DBFULLTEXT(FNDb.class, "fulltext(database,string)", SeqType.NOD_ZM, SeqType.ITEM, SeqType.STR),
    DBLIST(FNDb.class, "list([database[,path]])", SeqType.STR_ZM, 0, SeqType.STR, SeqType.STR),
    DBSYSTEM(FNDb.class, "system()", SeqType.STR, new SeqType[0]),
    DBINFO(FNDb.class, "info(database[,type])", SeqType.STR, 1, SeqType.ITEM, SeqType.STR),
    DBNODEID(FNDb.class, "node-id(nodes)", SeqType.ITR_ZM, SeqType.NOD_ZM),
    DBNODEPRE(FNDb.class, "node-pre(nodes)", SeqType.ITR_ZM, SeqType.NOD_ZM),
    DBEVENT(FNDb.class, "event(name,query)", SeqType.EMP, SeqType.STR, SeqType.ITEM_ZM),
    DBADD(FNDb.class, "add(database,nodes[,name[,path]])", SeqType.EMP, 2, SeqType.STR, SeqType.DOC_ZM, SeqType.STR, SeqType.STR),
    DBDELETE(FNDb.class, "delete(database,path)", SeqType.EMP, SeqType.ITEM, SeqType.STR),
    DBRENAME(FNDb.class, "rename(database,path,newpath)", SeqType.EMP, SeqType.STR, SeqType.STR, SeqType.STR),
    DBREPLACE(FNDb.class, "replace(database,path,item)", SeqType.EMP, SeqType.ITEM, SeqType.STR, SeqType.ITEM),
    DBOPTIMIZE(FNDb.class, "optimize(name[,all])", SeqType.EMP, 1, SeqType.STR, SeqType.BLN),
    DBRETRIEVE(FNDb.class, "retrieve(database,path)", SeqType.RAW, SeqType.STR, SeqType.STR),
    DBSTORE(FNDb.class, "store(database,path,value)", SeqType.EMP, SeqType.STR, SeqType.STR, SeqType.ITEM),
    DBISXML(FNDb.class, "is-xml(database,path)", SeqType.BLN, SeqType.STR, SeqType.STR),
    DBISRAW(FNDb.class, "is-raw(database,path)", SeqType.BLN, SeqType.STR, SeqType.STR),
    DBEXISTS(FNDb.class, "exists(database[,path])", SeqType.BLN, 1, SeqType.STR, SeqType.STR),
    DBCTYPE(FNDb.class, "content-type(database,path)", SeqType.STR, SeqType.STR, SeqType.STR),
    FLEXISTS(FNFile.class, "exists(path)", SeqType.BLN, SeqType.STR),
    FLISDIR(FNFile.class, "is-directory(path)", SeqType.BLN, SeqType.STR),
    FLISFILE(FNFile.class, "is-file(path)", SeqType.BLN, SeqType.STR),
    FLLASTMOD(FNFile.class, "last-modified(path)", SeqType.DTM, SeqType.STR),
    FLSIZE(FNFile.class, "size(path)", SeqType.ITR, SeqType.STR),
    FLBASENAME(FNFile.class, "base-name(path[,suffix])", SeqType.STR, 1, SeqType.STR, SeqType.STR),
    FLDIRNAME(FNFile.class, "dir-name(path)", SeqType.STR, SeqType.STR),
    FLPATHNATIVE(FNFile.class, "path-to-native(path)", SeqType.STR, SeqType.STR),
    FLPATHTOURI(FNFile.class, "path-to-uri(path)", SeqType.URI, SeqType.STR),
    FLRESOLVEPATH(FNFile.class, "resolve-path(path)", SeqType.STR, SeqType.STR),
    FLLIST(FNFile.class, "list(path[,recursive[,pattern]])", SeqType.STR_ZM, 1, SeqType.STR, SeqType.BLN, SeqType.STR),
    FLCREATEDIR(FNFile.class, "create-directory(path)", SeqType.EMP, SeqType.STR),
    FLDELETE(FNFile.class, "delete(path)", SeqType.EMP, SeqType.STR),
    FLREADTEXT(FNFile.class, "read-text(path[,encoding])", SeqType.STR, 1, SeqType.STR, SeqType.STR),
    FLREADLINES(FNFile.class, "read-text-lines(path[,encoding])", SeqType.STR_ZM, 1, SeqType.STR, SeqType.STR),
    FLREADBIN(FNFile.class, "read-binary(path)", SeqType.RAW, SeqType.STR),
    FLWRITE(FNFile.class, "write(path,data[,params])", SeqType.EMP, 2, SeqType.STR, SeqType.ITEM_ZM, SeqType.NOD),
    FLWRITEBIN(FNFile.class, "write-binary(path,item)", SeqType.EMP, SeqType.STR, SeqType.ITEM_ZM),
    FLAPPEND(FNFile.class, "append(path,data[,params])", SeqType.EMP, 2, SeqType.STR, SeqType.ITEM_ZM, SeqType.NOD),
    FLAPPENDBIN(FNFile.class, "append-binary(path,item)", SeqType.EMP, SeqType.STR, SeqType.ITEM_ZM),
    FLCOPY(FNFile.class, "copy(source,target)", SeqType.EMP, SeqType.STR, SeqType.STR),
    FLMOVE(FNFile.class, "move(source,target)", SeqType.EMP, SeqType.STR, SeqType.STR),
    SQLINIT(FNSql.class, "init(class)", SeqType.EMP, 1, SeqType.STR),
    SQLCONNECT(FNSql.class, "connect(url[,user[,pass[,options]]]]])", SeqType.ITR, 1, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.NOD_ZO),
    SQLPREPARE(FNSql.class, "prepare(id,statement)", SeqType.ITR, SeqType.ITR, SeqType.STR),
    SQLEXECUTE(FNSql.class, "execute(id[,item])", SeqType.ELM_ZM, 1, SeqType.ITR, SeqType.ITEM_ZO),
    SQLCLOSE(FNSql.class, "close(id)", SeqType.EMP, SeqType.ITR),
    SQLCOMMIT(FNSql.class, "commit(id)", SeqType.EMP, SeqType.ITR),
    SQLROLLBACK(FNSql.class, "rollback(id)", SeqType.EMP, SeqType.ITR),
    FTSEARCH(FNFt.class, "search(node,string)", SeqType.NOD_ZM, SeqType.NOD, SeqType.STR),
    FTCOUNT(FNFt.class, "count(nodes)", SeqType.ITR, SeqType.NOD_ZM),
    FTMARK(FNFt.class, "mark(nodes[,tag])", SeqType.NOD_ZM, 1, SeqType.NOD_ZM, SeqType.STR),
    FTEXTRACT(FNFt.class, "extract(nodes[,tag[,length]])", SeqType.NOD_ZM, 1, SeqType.ITEM_ZM, SeqType.STR, SeqType.ITR),
    FTSCORE(FNFt.class, "score(items)", SeqType.DBL_ZM, SeqType.ITEM_ZM),
    HOFSORTWITH(FNHof.class, "sort-with(lt-fun,seq)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM, SeqType.ITEM}, SeqType.BLN).seq(), SeqType.ITEM_ZM),
    HOFID(FNHof.class, "id(expr)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    HOFCONST(FNHof.class, "const(return,ignore)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    HOFUNTIL(FNHof.class, "until(pred,func,start)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM_ZM}, SeqType.BLN).seq(), FuncType.get(new SeqType[]{SeqType.ITEM_ZM}, SeqType.ITEM_ZM).seq(), SeqType.ITEM_ZM),
    HOFFOLDLEFT(FNHof.class, "fold-left1(function,non-empty-seq)", SeqType.ITEM_ZM, FuncType.get(new SeqType[]{SeqType.ITEM_ZM, SeqType.ITEM}, SeqType.ITEM_ZM).seq(), SeqType.ITEM_OM),
    HOFITERATE(FNHof.class, "iterate(fun, seq)", SeqType.ITEM_ZM, FuncType.arity(1).seq(), SeqType.ITEM_ZM),
    CRYPHMAC(FNCrypto.class, "hmac(string,string,string[,string])", SeqType.STR, 3, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR),
    CRYPENCRYPT(FNCrypto.class, "encrypt(string, string, string, string)", SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR),
    CRYPDECRYPT(FNCrypto.class, "decrypt(string, string, string, string)", SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR),
    CRYPGENSIG(FNCrypto.class, "generate-signature(node,string,string,string,string,string[,item][,item])", SeqType.NOD, 6, SeqType.NOD, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.ITEM_ZO, SeqType.ITEM_ZO),
    CRYPVALSIG(FNCrypto.class, "validate-signature(node)", SeqType.BLN, SeqType.NOD),
    HTTPSENDREQUEST(FNHttp.class, "send-request(request[,href,[bodies]])", SeqType.ITEM_ZM, 1, SeqType.NOD, SeqType.STR_ZO, SeqType.ITEM_ZM),
    JSONPARSE(FNJson.class, "parse(string)", SeqType.NOD, SeqType.STR),
    JSONPARSEML(FNJson.class, "parse-ml(string)", SeqType.NOD, SeqType.STR),
    JSONSER(FNJson.class, "serialize(node)", SeqType.STR, SeqType.NOD),
    JSONSERML(FNJson.class, "serialize-ml(node)", SeqType.STR, SeqType.NOD),
    SENTPOL(FNSent.class, "polarity(string,uri)", SeqType.DBL, SeqType.STR, SeqType.STR),
    SENTNORM(FNSent.class, "normed-polarity(string,uri)", SeqType.DBL, SeqType.STR, SeqType.STR),
    EVAL(FNUtil.class, "eval(string)", SeqType.ITEM_ZM, SeqType.STR_ZO),
    RUN(FNUtil.class, "run(string)", SeqType.ITEM_ZM, SeqType.STR),
    FORMAT(FNUtil.class, "format(format,item1[,...])", SeqType.STR, -2, SeqType.STR, SeqType.ITEM),
    MB(FNUtil.class, "mb(expr[,cache])", SeqType.DBL, 1, SeqType.ITEM_ZM, SeqType.BLN),
    MS(FNUtil.class, "ms(expr[,cache])", SeqType.DBL, 1, SeqType.ITEM_ZM, SeqType.BLN),
    TO_BASE(FNUtil.class, "integer-to-base(num,base)", SeqType.STR, SeqType.ITR, SeqType.ITR),
    FRM_BASE(FNUtil.class, "integer-from-base(str,base)", SeqType.ITR, SeqType.STR, SeqType.ITR),
    MD5(FNUtil.class, "md5(str)", SeqType.HEX, SeqType.STR),
    SHA1(FNUtil.class, "sha1(str)", SeqType.HEX, SeqType.STR),
    CRC32(FNUtil.class, "crc32(str)", SeqType.HEX, SeqType.STR),
    TO_BYTES(FNUtil.class, "to-bytes(item)", SeqType.BYT_ZM, SeqType.ITEM),
    TO_STRING(FNUtil.class, "to-string(item[,encoding])", SeqType.STR, 1, SeqType.ITEM, SeqType.STR),
    UUID(FNUtil.class, "uuid()", SeqType.STR, new SeqType[0]),
    TRANSFORM(FNXslt.class, "transform(input,stylesheet[,params])", SeqType.NOD, 2, SeqType.ITEM, SeqType.ITEM, SeqType.NOD_ZO),
    ZIPBIN(FNZip.class, "binary-entry(path,entry)", SeqType.B64, SeqType.STR, SeqType.STR),
    ZIPTEXT(FNZip.class, "text-entry(path,entry[,encoding])", SeqType.STR, 2, SeqType.STR, SeqType.STR, SeqType.STR),
    ZIPHTML(FNZip.class, "html-entry(path,entry)", SeqType.NOD, SeqType.STR, SeqType.STR),
    ZIPXML(FNZip.class, "xml-entry(path,entry)", SeqType.NOD, SeqType.STR, SeqType.STR),
    ZIPENTRIES(FNZip.class, "entries(path)", SeqType.ELM, SeqType.STR),
    ZIPFILE(FNZip.class, "zip-file(zip)", SeqType.EMP, SeqType.ELM),
    ZIPUPDATE(FNZip.class, "update-entries(zip,output)", SeqType.EMP, SeqType.ELM, SeqType.STR);

    private static final HashMap<Class<? extends FuncCall>, byte[]> URIS;
    final Class<? extends FuncCall> func;
    final String desc;
    public final int min;
    public final int max;
    public final SeqType[] args;
    final SeqType ret;

    static {
        URIS = new HashMap();
        URIS.put(FNMap.class, QueryText.MAPURI);
        URIS.put(FNMath.class, QueryText.MATHURI);
        URIS.put(FNCrypto.class, QueryText.CRYPTOURI);
        URIS.put(FNFile.class, QueryText.FILEURI);
        URIS.put(FNHttp.class, QueryText.HTTPURI);
        URIS.put(FNZip.class, QueryText.ZIPURI);
        URIS.put(FNDb.class, QueryText.DBURI);
        URIS.put(FNFt.class, QueryText.FTURI);
        URIS.put(FNHof.class, QueryText.HOFURI);
        URIS.put(FNJson.class, QueryText.JSONURI);
        URIS.put(FNSent.class, QueryText.SENTURI);
        URIS.put(FNSql.class, QueryText.SQLURI);
        URIS.put(FNUtil.class, QueryText.UTILURI);
        URIS.put(FNXslt.class, QueryText.XSLTURI);
    }

    private Function(Class<? extends FuncCall> fun, String dsc, SeqType r, SeqType ... typ) {
        this(fun, dsc, r, typ.length, typ);
    }

    private Function(Class<? extends FuncCall> fun, String dsc, SeqType r, int m, SeqType ... typ) {
        this.func = fun;
        this.desc = dsc;
        this.ret = r;
        this.min = m < 0 ? -m : m;
        this.max = m < 0 ? Integer.MAX_VALUE : typ.length;
        this.args = typ;
    }

    public FuncCall get(InputInfo ii, Expr ... arg) {
        return (FuncCall)Reflect.get(Reflect.find(this.func, InputInfo.class, Function.class, Expr[].class), new Object[]{ii, this, arg});
    }

    public byte[] uri() {
        byte[] u = URIS.get(this.func);
        return u == null ? QueryText.FNURI : u;
    }

    public FuncType type(int arity) {
        SeqType[] arg = new SeqType[arity];
        if (arity != 0 && this.max == Integer.MAX_VALUE) {
            System.arraycopy(this.args, 0, arg, 0, this.args.length);
            SeqType var = this.args[this.args.length - 1];
            int i = this.args.length;
            while (i < arg.length) {
                arg[i] = var;
                ++i;
            }
        } else {
            System.arraycopy(this.args, 0, arg, 0, arity);
        }
        return FuncType.get(arg, this.ret);
    }

    public String args(Object ... arg) {
        TokenBuilder tb = new TokenBuilder();
        Object[] objectArray = arg;
        int n = arg.length;
        int n2 = 0;
        while (n2 < n) {
            String s;
            Object a = objectArray[n2];
            if (tb.size() != 0) {
                tb.add(44);
            }
            if ((s = a.toString()).matches("^([\\w\\d-_:\\.]*\\(|<|\"|\\$| ).*") || a instanceof Integer) {
                tb.add(s);
            } else if (a instanceof Boolean) {
                tb.add(String.valueOf(s) + "()");
            } else {
                tb.add("\"" + s.replaceAll("\"", "\"\"") + "\"");
            }
            ++n2;
        }
        return String.valueOf(this.toString().replaceAll("\\(.*", "(")) + tb + ")";
    }

    public final String toString() {
        byte[] pre = NSGlobal.prefix(this.uri());
        return new TokenBuilder(pre).add(58).add(this.desc).toString();
    }
}

