/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.item.AtomType;
import org.basex.query.item.Empty;
import org.basex.query.item.Jav;
import org.basex.query.item.NodeType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class JavaFunc
extends Arr {
    private static final String NEW = "new";
    private static final Class<?>[] JAVA = new Class[]{String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, BigInteger.class, QName.class, CharSequence.class, byte[].class, Object[].class};
    private static final Type[] XQUERY = new Type[]{AtomType.STR, AtomType.BLN, AtomType.BLN, AtomType.BYT, AtomType.BYT, AtomType.SHR, AtomType.SHR, AtomType.INT, AtomType.INT, AtomType.LNG, AtomType.LNG, AtomType.FLT, AtomType.FLT, AtomType.DBL, AtomType.DBL, AtomType.DEC, AtomType.ITR, AtomType.QNM, AtomType.STR, AtomType.HEX, AtomType.SEQ};
    private final Class<?> cls;
    private final String mth;

    public JavaFunc(InputInfo ii, Class<?> c, String m, Expr[] a) {
        super(ii, a);
        this.cls = c;
        this.mth = m;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value[] arg = new Value[this.expr.length];
        int a = 0;
        while (a < this.expr.length) {
            arg[a] = this.expr[a].value(ctx);
            if (arg[a].empty()) {
                Err.XPEMPTY.thrw(this.input, this.desc());
            }
            ++a;
        }
        Object result = null;
        try {
            result = this.mth.equals(NEW) ? this.constructor(arg) : this.method(arg);
        }
        catch (InvocationTargetException ex) {
            Err.JAVAERR.thrw(this.input, ex.getCause());
        }
        catch (Exception ex) {
            Err.FUNJAVA.thrw(this.input, this.desc(), arg);
        }
        return result == null ? Empty.ITER : this.iter(result);
    }

    private Object constructor(Value[] ar) throws Exception {
        Constructor<?>[] constructorArray = this.cls.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> con = constructorArray[n2];
            Object[] arg = this.args(con.getParameterTypes(), ar, true);
            if (arg != null) {
                return con.newInstance(arg);
            }
            ++n2;
        }
        throw new Exception();
    }

    private Object method(Value[] ar) throws Exception {
        try {
            Field f = this.cls.getField(this.mth);
            boolean st = Modifier.isStatic(f.getModifiers());
            if (ar.length == (st ? 0 : 1)) {
                return f.get(st ? null : this.instObj(ar[0]));
            }
        }
        catch (NoSuchFieldException f) {
            // empty catch block
        }
        Method[] methodArray = this.cls.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method meth = methodArray[n2];
            if (meth.getName().equals(this.mth)) {
                boolean st = Modifier.isStatic(meth.getModifiers());
                Object[] arg = this.args(meth.getParameterTypes(), ar, st);
                if (arg != null) {
                    return meth.invoke(st ? null : this.instObj(ar[0]), arg);
                }
            }
            ++n2;
        }
        throw new Exception();
    }

    private Object instObj(Value v) throws QueryException {
        return this.cls.isInstance(v) ? v : (v instanceof Jav ? ((Jav)v).val : v.toJava());
    }

    private Object[] args(Class<?>[] params, Value[] args, boolean stat) throws QueryException {
        int s = stat ? 0 : 1;
        int l = args.length - s;
        if (l != params.length) {
            return null;
        }
        Object[] val = new Object[l];
        int a = 0;
        Class<?>[] classArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object next;
            Class<?> par = classArray[n2];
            Value arg = args[s + a];
            if (par.isInstance(arg)) {
                next = arg;
            } else {
                Type jtype = JavaFunc.type(par);
                if (jtype == null || !arg.type.instance(jtype) && !jtype.instance(arg.type)) {
                    return null;
                }
                next = arg.toJava();
            }
            val[a++] = next;
            ++n2;
        }
        return val;
    }

    private static Type type(Class<?> par) {
        int j = 0;
        while (j < JAVA.length) {
            if (par == JAVA[j]) {
                return XQUERY[j];
            }
            ++j;
        }
        return AtomType.JAVA;
    }

    public static Type type(Object o) {
        Type t = JavaFunc.type(o.getClass());
        if (t != AtomType.JAVA) {
            return t;
        }
        if (o instanceof Element) {
            return NodeType.ELM;
        }
        if (o instanceof Document) {
            return NodeType.DOC;
        }
        if (o instanceof DocumentFragment) {
            return NodeType.DOC;
        }
        if (o instanceof Attr) {
            return NodeType.ATT;
        }
        if (o instanceof Comment) {
            return NodeType.COM;
        }
        if (o instanceof ProcessingInstruction) {
            return NodeType.PI;
        }
        if (o instanceof Text) {
            return NodeType.TXT;
        }
        if (o instanceof Duration) {
            Duration d = (Duration)o;
            return !d.isSet(DatatypeConstants.YEARS) && !d.isSet(DatatypeConstants.MONTHS) ? AtomType.DTD : (!d.isSet(DatatypeConstants.HOURS) && !d.isSet(DatatypeConstants.MINUTES) && !d.isSet(DatatypeConstants.SECONDS) ? AtomType.YMD : AtomType.DUR);
        }
        if (o instanceof XMLGregorianCalendar) {
            QName type = ((XMLGregorianCalendar)o).getXMLSchemaType();
            if (type == DatatypeConstants.DATE) {
                return AtomType.DAT;
            }
            if (type == DatatypeConstants.DATETIME) {
                return AtomType.DTM;
            }
            if (type == DatatypeConstants.TIME) {
                return AtomType.TIM;
            }
            if (type == DatatypeConstants.GYEARMONTH) {
                return AtomType.YMO;
            }
            if (type == DatatypeConstants.GMONTHDAY) {
                return AtomType.MDA;
            }
            if (type == DatatypeConstants.GYEAR) {
                return AtomType.YEA;
            }
            if (type == DatatypeConstants.GMONTH) {
                return AtomType.MON;
            }
            if (type == DatatypeConstants.GDAY) {
                return AtomType.DAY;
            }
        }
        return AtomType.JAVA;
    }

    private Iter iter(Object res) {
        if (!res.getClass().isArray()) {
            return new Jav(res).iter();
        }
        ItemCache ic = new ItemCache();
        if (res instanceof boolean[]) {
            boolean[] blArray = (boolean[])res;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean o = blArray[n2];
                ic.add(new Jav(o));
                ++n2;
            }
        } else if (res instanceof char[]) {
            char[] cArray = (char[])res;
            int n = cArray.length;
            int n3 = 0;
            while (n3 < n) {
                Character o = Character.valueOf(cArray[n3]);
                ic.add(new Jav(o));
                ++n3;
            }
        } else if (res instanceof byte[]) {
            byte[] byArray = (byte[])res;
            int n = byArray.length;
            int n4 = 0;
            while (n4 < n) {
                Byte o = byArray[n4];
                ic.add(new Jav(o));
                ++n4;
            }
        } else if (res instanceof short[]) {
            short[] sArray = (short[])res;
            int n = sArray.length;
            int n5 = 0;
            while (n5 < n) {
                Short o = sArray[n5];
                ic.add(new Jav(o));
                ++n5;
            }
        } else if (res instanceof int[]) {
            int[] nArray = (int[])res;
            int n = nArray.length;
            int n6 = 0;
            while (n6 < n) {
                Integer o = nArray[n6];
                ic.add(new Jav(o));
                ++n6;
            }
        } else if (res instanceof long[]) {
            long[] lArray = (long[])res;
            int n = lArray.length;
            int n7 = 0;
            while (n7 < n) {
                Long o = lArray[n7];
                ic.add(new Jav(o));
                ++n7;
            }
        } else if (res instanceof float[]) {
            float[] fArray = (float[])res;
            int n = fArray.length;
            int n8 = 0;
            while (n8 < n) {
                Float o = Float.valueOf(fArray[n8]);
                ic.add(new Jav(o));
                ++n8;
            }
        } else if (res instanceof double[]) {
            double[] dArray = (double[])res;
            int n = dArray.length;
            int n9 = 0;
            while (n9 < n) {
                Double o = dArray[n9];
                ic.add(new Jav(o));
                ++n9;
            }
        } else {
            Object[] objectArray = (Object[])res;
            int n = objectArray.length;
            int n10 = 0;
            while (n10 < n) {
                Object o = objectArray[n10];
                ic.add(new Jav(o));
                ++n10;
            }
        }
        return ic;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.NAM, Token.token(this.cls + "." + this.mth)});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr arg = exprArray[n2];
            arg.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return String.valueOf(this.cls.getName()) + "." + this.mth + "(...)" + (this.mth.equals(NEW) ? " constructor" : " method");
    }

    @Override
    public String toString() {
        return this.cls + "." + this.mth + "(" + this.toString(", ") + ")";
    }
}

