/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.item.ANode;
import org.basex.query.item.Dbl;
import org.basex.query.item.Itr;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.Uri;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.Scoring;

public class DBNode
extends ANode {
    public final Data data;
    public int pre;
    private ANode root;
    Atts nsp;

    public DBNode(Data d, int p) {
        this(d, p, d.kind(p));
    }

    public DBNode(Data d, int p, int k) {
        this(d, p, null, DBNode.type(k));
    }

    protected DBNode(Data d, int p, ANode r, NodeType t) {
        super(t);
        this.data = d;
        this.pre = p;
        this.par = r;
    }

    public DBNode(IO input, Prop prop) throws IOException {
        this(Parser.xmlParser(input, prop), prop);
    }

    public DBNode(Parser parser, Prop prop) throws IOException {
        this(MemBuilder.build("", parser, prop), 0);
    }

    public final void set(int p, int k) {
        this.type = DBNode.type(k);
        this.par = null;
        this.val = null;
        this.nsp = null;
        this.pre = p;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    @Override
    public final byte[] atom(InputInfo ii) {
        if (this.val == null) {
            this.val = this.data.atom(this.pre);
        }
        return this.val;
    }

    @Override
    public final long itr(InputInfo ii) throws QueryException {
        long l;
        boolean txt;
        boolean bl = txt = this.type == NodeType.TXT || this.type == NodeType.COM;
        if ((txt || this.type == NodeType.ATT) && (l = this.data.textItr(this.pre, txt)) != Long.MIN_VALUE) {
            return l;
        }
        return Itr.parse(this.data.atom(this.pre), ii);
    }

    @Override
    public final double dbl(InputInfo ii) throws QueryException {
        double d;
        boolean txt;
        boolean bl = txt = this.type == NodeType.TXT || this.type == NodeType.COM;
        if ((txt || this.type == NodeType.ATT) && !Double.isNaN(d = this.data.textDbl(this.pre, txt))) {
            return d;
        }
        return Dbl.parse(this.data.atom(this.pre), ii);
    }

    @Override
    public final void serialize(Serializer ser) throws IOException {
        ser.node(this.data, this.pre);
    }

    @Override
    public final byte[] nname() {
        if (!(this.type instanceof NodeType)) {
            return Token.EMPTY;
        }
        NodeType t = this.ndType();
        switch (t) {
            case PI: 
            case ELM: 
            case ATT: {
                return this.data.name(this.pre, DBNode.kind(t));
            }
        }
        return Token.EMPTY;
    }

    @Override
    public final QNm qname() {
        return this.qname(new QNm());
    }

    @Override
    public final QNm qname(QNm name) {
        byte[] nm = this.nname();
        name.name(nm);
        name.uri(Uri.EMPTY);
        boolean ns = name.ns();
        if (ns || this.data.ns.size() != 0) {
            int n;
            int n2 = n = ns ? this.data.ns.uri(nm, this.pre) : this.data.uri(this.pre, this.data.kind(this.pre));
            byte[] uri = n > 0 ? this.data.ns.uri(n) : (ns ? NSGlobal.uri(Token.pref(nm)) : Token.EMPTY);
            name.uri(uri.length == 0 ? Uri.EMPTY : new Uri(uri));
        }
        return name;
    }

    @Override
    public final Atts ns() {
        if (this.type == NodeType.ELM && this.nsp == null) {
            this.nsp = this.data.ns(this.pre);
        }
        return this.nsp;
    }

    @Override
    public final byte[] base() {
        if (this.type != NodeType.DOC) {
            return Token.EMPTY;
        }
        String dir = this.data.meta.original;
        String name = Token.string(this.data.text(this.pre, true));
        return Token.token(dir.isEmpty() ? name : IO.get(dir).merge(name).url());
    }

    @Override
    public final boolean is(ANode node) {
        if (node == this) {
            return true;
        }
        if (!(node instanceof DBNode)) {
            return false;
        }
        return this.data == node.data() && this.pre == ((DBNode)node).pre;
    }

    @Override
    public final int diff(ANode node) {
        return !(node instanceof DBNode) || this.data != node.data() ? this.id - node.id : this.pre - ((DBNode)node).pre;
    }

    @Override
    public final DBNode copy() {
        DBNode n = new DBNode(this.data, this.pre, this.par, this.ndType());
        n.root = this.root;
        n.score = this.score;
        return n;
    }

    @Override
    public final DBNode finish() {
        return this.copy();
    }

    @Override
    public final ANode parent() {
        if (this.par != null) {
            return this.par;
        }
        int p = this.data.parent(this.pre, this.data.kind(this.pre));
        if (p == -1) {
            return null;
        }
        DBNode node = this.copy();
        node.set(p, this.data.kind(p));
        node.score(Scoring.step(node.score()));
        return node;
    }

    @Override
    public DBNode parent(ANode p) {
        this.root = p;
        this.par = p;
        return this;
    }

    @Override
    public final boolean hasChildren() {
        int k = this.data.kind(this.pre);
        return this.data.attSize(this.pre, k) != this.data.size(this.pre, k);
    }

    @Override
    public final AxisIter anc() {
        return new AxisIter(){
            private final DBNode node;
            int p;
            int k;
            final double sc;
            {
                this.node = DBNode.this.copy();
                this.p = DBNode.this.pre;
                this.k = DBNode.this.data.kind(this.p);
                this.sc = this.node.score();
            }

            @Override
            public ANode next() {
                this.p = DBNode.this.data.parent(this.p, this.k);
                if (this.p == -1) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter ancOrSelf() {
        return new AxisIter(){
            private final DBNode node;
            int p;
            int k;
            final double sc;
            {
                this.node = DBNode.this.copy();
                this.p = DBNode.this.pre;
                this.k = DBNode.this.data.kind(this.p);
                this.sc = this.node.score();
            }

            @Override
            public ANode next() {
                if (this.p == -1) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                this.p = DBNode.this.data.parent(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter attributes() {
        return new AxisIter(){
            final DBNode node;
            final int s;
            int p;
            {
                this.node = DBNode.this.copy();
                this.s = DBNode.this.pre + DBNode.this.data.attSize(DBNode.this.pre, DBNode.this.data.kind(DBNode.this.pre));
                this.p = DBNode.this.pre + 1;
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.node.set(this.p++, 3);
                return this.node;
            }
        };
    }

    @Override
    public final AxisMoreIter children() {
        return new AxisMoreIter(){
            int k;
            int p;
            final int s;
            final DBNode node;
            final double sc;
            {
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.p = DBNode.this.pre + DBNode.this.data.attSize(DBNode.this.pre, this.k);
                this.s = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
                this.node = DBNode.this.copy();
                this.sc = this.node.score();
            }

            @Override
            public boolean more() {
                return this.p != this.s;
            }

            @Override
            public ANode next() {
                if (!this.more()) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                this.p += DBNode.this.data.size(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter descendant() {
        return new AxisIter(){
            int k;
            int p;
            final int s;
            final DBNode node;
            final double sc;
            {
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.p = DBNode.this.pre + DBNode.this.data.attSize(DBNode.this.pre, this.k);
                this.s = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
                this.node = DBNode.this.copy();
                this.sc = this.node.score();
            }

            @Override
            public DBNode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.p += DBNode.this.data.attSize(this.p, this.k);
                this.node.score(Scoring.step(this.sc));
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter descOrSelf() {
        return new AxisIter(){
            final DBNode node;
            final int s;
            int p;
            {
                this.node = DBNode.this.copy();
                this.s = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, DBNode.this.data.kind(DBNode.this.pre));
                this.p = DBNode.this.pre;
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                int k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, k);
                this.p += DBNode.this.data.attSize(this.p, k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter foll() {
        return new AxisIter(){
            private final DBNode node;
            final int s;
            int k;
            int p;
            {
                this.node = DBNode.this.copy();
                this.s = DBNode.this.data.meta.size;
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.p = DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.p += DBNode.this.data.attSize(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter follSibl() {
        return new AxisIter(){
            private final DBNode node;
            int k;
            private final int pp;
            final int s;
            int p;
            {
                this.node = DBNode.this.copy();
                this.k = DBNode.this.data.kind(DBNode.this.pre);
                this.pp = DBNode.this.data.parent(DBNode.this.pre, this.k);
                this.s = this.pp == -1 ? 0 : this.pp + DBNode.this.data.size(this.pp, DBNode.this.data.kind(this.pp));
                this.p = this.pp == -1 ? 0 : DBNode.this.pre + DBNode.this.data.size(DBNode.this.pre, this.k);
            }

            @Override
            public ANode next() {
                if (this.p == this.s) {
                    return null;
                }
                this.k = DBNode.this.data.kind(this.p);
                this.node.set(this.p, this.k);
                this.p += DBNode.this.data.size(this.p, this.k);
                return this.node;
            }
        };
    }

    @Override
    public final AxisIter par() {
        return new AxisIter(){
            private boolean more;

            @Override
            public ANode next() {
                if (this.more) {
                    return null;
                }
                this.more = true;
                return DBNode.this.parent();
            }
        };
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        return cmp instanceof DBNode && this.data == ((DBNode)cmp).data && this.pre == ((DBNode)cmp).pre;
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(Token.token(Util.name(this)), (byte[][])new byte[][]{QueryText.NAM, Token.token(this.data.meta.name)});
        if (this.pre != 0) {
            ser.attribute(QueryText.PRE, Token.token(this.pre));
        }
        ser.closeElement();
    }

    @Override
    public String toString() {
        NodeType nt = (NodeType)this.type;
        TokenBuilder tb = new TokenBuilder(nt.nam()).add(32);
        switch (nt) {
            case PI: 
            case ATT: {
                tb.add(this.nname()).add(" { \"").add(Token.chop(this.atom(), 64)).add("\" }");
                break;
            }
            case ELM: {
                tb.add(this.nname()).add(" { ... }");
                break;
            }
            case DOC: {
                tb.add("{ \"").add(this.data.text(this.pre, true)).add("\" }");
                break;
            }
            default: {
                tb.add("{ \"").add(Token.chop(this.atom(), 64)).add("\" }");
            }
        }
        return tb.toString();
    }
}

