/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.query.QueryException;
import org.basex.query.item.Dur;
import org.basex.query.item.Item;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class Date
extends Item {
    protected static final String ZONE = "((\\+|-)([0-9]{2}):([0-9]{2})|Z)?";
    protected static final byte[] DAYS = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final Pattern DAT = Pattern.compile("(-?)([0-9]{4})-([0-9]{2})-([0-9]{2})((\\+|-)([0-9]{2}):([0-9]{2})|Z)?");
    private static final Pattern TIM = Pattern.compile("([0-9]{2}):([0-9]{2}):([0-9]{2})(\\.([0-9]+))?((\\+|-)([0-9]{2}):([0-9]{2})|Z)?");
    public static DatatypeFactory df;
    public XMLGregorianCalendar xc;

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception ex) {
            Util.notexpected(new Object[0]);
        }
    }

    protected Date(Type typ, Date d) {
        super(typ);
        this.xc = (XMLGregorianCalendar)d.xc.clone();
    }

    protected Date(Type typ, byte[] d, String e, InputInfo ii) throws QueryException {
        super(typ);
        try {
            this.xc = df.newXMLGregorianCalendar(Token.string(d).trim());
            if (this.xc.getHour() == 24) {
                this.xc.add(df.newDuration(0L));
            }
        }
        catch (IllegalArgumentException ex) {
            throw this.dateErr(d, e, ii);
        }
    }

    protected final void date(byte[] d, String e, InputInfo ii) throws QueryException {
        Matcher mt = DAT.matcher(Token.string(d).trim());
        if (!mt.matches()) {
            this.dateErr(d, e, ii);
        }
        this.zone(mt, 5, d, ii);
    }

    protected final void time(byte[] d, String e, InputInfo ii) throws QueryException {
        double ms;
        Matcher mt = TIM.matcher(Token.string(d).trim());
        if (!mt.matches()) {
            this.dateErr(d, e, ii);
        }
        int h = Token.toInt(mt.group(1));
        int s = Token.toInt(mt.group(3));
        if (s > 59) {
            Err.DATERANGE.thrw(ii, this.type, d);
        }
        double d2 = ms = mt.group(4) != null ? Double.parseDouble(mt.group(4)) : 0.0;
        if (h == 24 && ms > 0.0) {
            this.dateErr(d, e, ii);
        }
        this.zone(mt, 6, d, ii);
    }

    protected final void zone(Matcher mt, int p, byte[] val, InputInfo ii) throws QueryException {
        if (mt.group(p) == null || mt.group(p).equals("Z")) {
            return;
        }
        int th = Token.toInt(mt.group(p + 2));
        int tm = Token.toInt(mt.group(p + 3));
        if (th > 14 || tm > 59 || th == 14 && tm != 0) {
            Err.INVALIDZONE.thrw(ii, new Object[]{val});
        }
    }

    protected final void calc(Dur a, boolean p, InputInfo ii) throws QueryException {
        if (this.xc.getYear() + a.mon / 12 > 9999) {
            Err.DATERANGE.thrw(ii, this.type, a.atom(ii));
        }
        Duration dur = a.toJava();
        this.xc.add(p ? dur : dur.negate());
        if (this.xc.getYear() == 0) {
            this.xc.setYear(p ^ dur.getSign() < 0 ? 1 : -1);
        }
    }

    @Override
    public final byte[] atom(InputInfo ii) {
        String str = this.xc.toXMLFormat();
        str = str.replaceAll("\\.0+(Z|-.*|\\+.*)?$", "$1");
        str = str.replaceAll("(\\.\\d+?)0+(Z|-.*|\\+.*)?$", "$1$2");
        return Token.token(str);
    }

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        Date d;
        long d2;
        long d1 = this.days();
        return d1 == (d2 = (d = (Date)(it.date() ? it : this.type.e(it, null, ii))).days()) && this.seconds().doubleValue() == d.seconds().doubleValue();
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        Date d;
        long d2;
        long d1 = this.days();
        if (d1 != (d2 = (d = (Date)(it.date() ? it : this.type.e(it, null, ii))).days())) {
            return (int)(d1 - d2);
        }
        return this.seconds().subtract(d.seconds()).signum();
    }

    @Override
    public final XMLGregorianCalendar toJava() {
        return this.xc;
    }

    protected final BigDecimal seconds() {
        int h = this.xc.getHour() == Integer.MIN_VALUE ? 0 : this.xc.getHour();
        int m = this.xc.getMinute() == Integer.MIN_VALUE ? 0 : this.xc.getMinute();
        int s = this.xc.getSecond() == Integer.MIN_VALUE ? 0 : this.xc.getSecond();
        int z = this.xc.getTimezone() == Integer.MIN_VALUE ? 0 : this.xc.getTimezone();
        BigDecimal bd = this.xc.getFractionalSecond();
        if (bd == null) {
            bd = BigDecimal.valueOf(0L);
        }
        return bd.add(BigDecimal.valueOf(h * 3600 + m * 60 - z * 60 + s));
    }

    protected final long days() {
        int y = this.xc.getYear() == Integer.MIN_VALUE ? 0 : this.xc.getYear();
        int m = this.xc.getMonth() == Integer.MIN_VALUE ? 0 : this.xc.getMonth() - 1;
        int d = this.xc.getDay() == Integer.MIN_VALUE ? 0 : this.xc.getDay() - 1;
        long s = Date.days(y, m, d);
        return y > 0 ? s : -s;
    }

    private static long dpm(int y, int m) {
        return DAYS[m] + (m == 1 ? Date.leap(y) : 0);
    }

    private static int leap(int y) {
        return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 1 : 0;
    }

    public static long days(int y, int m, int d) {
        long n = 0L;
        int yy = Math.abs(y);
        int i = 0;
        while (i < yy) {
            n += (long)(365 + Date.leap(i));
            ++i;
        }
        i = 0;
        while (i < m) {
            n += Date.dpm(y, i);
            ++i;
        }
        return n + (long)d;
    }

    @Override
    public final String toString() {
        return Util.info("\"%\"", new Object[]{this.atom(null)});
    }
}

