/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.FNode;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.ProcessingInstruction;

public final class FPI
extends FNode {
    private static final byte[] CLOSE = new byte[]{63, 62};
    private final QNm name;

    public FPI(QNm n, byte[] v) {
        super(NodeType.PI);
        this.name = n;
        this.val = v;
    }

    public FPI(ProcessingInstruction pi) {
        this(new QNm(Token.token(pi.getTarget())), Token.token(pi.getData()));
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] nname() {
        return this.name.atom();
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        ser.pi(this.name.atom(), this.val);
    }

    @Override
    public FNode copy() {
        return new FPI(this.name, this.val).parent(this.par);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.emptyElement(this, (byte[][])new byte[][]{QueryText.NAM, this.name.atom(), QueryText.VAL, this.val});
    }

    @Override
    public String toString() {
        return Util.info("<?% %?>", this.name.atom(), this.val);
    }

    public static byte[] parse(byte[] atom, InputInfo ii) throws QueryException {
        if (Token.contains(atom, CLOSE)) {
            Err.CPICONT.thrw(ii, new Object[]{atom});
        }
        return atom;
    }
}

