/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bin;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class Hex
extends Bin {
    public Hex(byte[] b) {
        super(b, AtomType.HEX);
    }

    public Hex(byte[] v, InputInfo ii) throws QueryException {
        super(Hex.decode(Token.trim(v), ii), AtomType.HEX);
    }

    Hex(Bin b, InputInfo ii) throws QueryException {
        this(b.val(ii));
    }

    protected Hex(AtomType t) {
        super(null, t);
    }

    @Override
    public final byte[] atom(InputInfo ii) throws QueryException {
        return Token.hex(this.val(ii), true);
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return Token.eq(this.val(ii), it instanceof Bin ? ((Bin)it).val(ii) : Hex.decode(it.atom(ii), ii));
    }

    private static byte[] decode(byte[] h, InputInfo ii) throws QueryException {
        if ((h.length & 1) != 0) {
            throw Err.FUNCAST.thrw(ii, AtomType.HEX, Character.valueOf((char)h[0]));
        }
        int l = h.length >>> 1;
        byte[] v = new byte[l];
        int i = 0;
        while (i < l) {
            v[i] = (byte)((Hex.dec(h[i << 1], ii) << 4) + Hex.dec(h[(i << 1) + 1], ii));
            ++i;
        }
        return v;
    }

    private static int dec(byte b, InputInfo ii) throws QueryException {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 97 && b <= 102 || b >= 65 && b <= 70) {
            return (b & 0xF) + 9;
        }
        throw Err.FUNCAST.thrw(ii, AtomType.HEX, Character.valueOf((char)b));
    }

    @Override
    public String toString() {
        return Util.info("\"%\"", new Object[]{Token.hex(this.val, true)});
    }
}

