/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.basex.io.in.ArrayInput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.Dbl;
import org.basex.query.item.Dec;
import org.basex.query.item.Flt;
import org.basex.query.item.Itr;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class Item
extends Value {
    public static final int UNDEF = Integer.MIN_VALUE;
    protected Double score;

    protected Item(Type t) {
        super(t);
    }

    @Override
    public final ValueIter iter() {
        return new ItemIter(this);
    }

    @Override
    public final Item item(QueryContext ctx, InputInfo ii) {
        return this;
    }

    @Override
    public final Item itemAt(long pos) {
        return this;
    }

    @Override
    public final Item ebv(QueryContext ctx, InputInfo ii) {
        return this;
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.bool(ii) ? this : null;
    }

    @Override
    public final boolean item() {
        return true;
    }

    public abstract byte[] atom(InputInfo var1) throws QueryException;

    public boolean bool(InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this.type, this);
    }

    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this.atom(ii), ii);
    }

    public long itr(InputInfo ii) throws QueryException {
        return Itr.parse(this.atom(ii), ii);
    }

    public float flt(InputInfo ii) throws QueryException {
        return Flt.parse(this.atom(ii), ii);
    }

    public double dbl(InputInfo ii) throws QueryException {
        return Dbl.parse(this.atom(ii), ii);
    }

    public final boolean comparable(Item b) {
        return this.type == b.type || this.num() && b.num() || (this.unt() || this.str()) && (b.str() || b.unt()) || this.dur() && b.dur() || this.func();
    }

    public abstract boolean eq(InputInfo var1, Item var2) throws QueryException;

    public final boolean equiv(InputInfo ii, Item it) throws QueryException {
        return (this == Dbl.NAN || this == Flt.NAN) && it.num() && Double.isNaN(it.dbl(ii)) || this.comparable(it) && this.eq(ii, it);
    }

    public int diff(InputInfo ii, Item it) throws QueryException {
        throw (this == it ? Err.TYPECMP : Err.XPTYPECMP).thrw(ii, this.type, it.type);
    }

    public InputStream input() throws IOException {
        try {
            return new ArrayInput(this.atom(null));
        }
        catch (QueryException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    @Override
    public final SeqType type() {
        return this.type.seq();
    }

    @Override
    public final long size() {
        return 1L;
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    public double score() {
        return this.score == null ? 0.0 : this.score;
    }

    public final void score(double s) {
        if (this.score != null || s != 0.0) {
            this.score = s;
        }
    }

    public void serialize(Serializer ser) throws IOException {
        ser.item(this);
    }

    protected final QueryException castErr(Object val, InputInfo ii) throws QueryException {
        return Err.FUNCAST.thrw(ii, this.type, val);
    }

    public final QueryException dateErr(byte[] i, String ex, InputInfo ii) throws QueryException {
        throw Err.DATEFORMAT.thrw(ii, this.type, i, ex);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        try {
            ser.emptyElement(QueryText.ITM, (byte[][])new byte[][]{QueryText.VAL, this.atom(null), QueryText.TYP, Token.token(this.name())});
        }
        catch (QueryException ex) {
            Util.notexpected(ex);
        }
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return Token.hash(this.atom(ii));
    }

    @Override
    public final int writeTo(Item[] arr, int start) {
        arr[start] = this;
        return 1;
    }

    @Override
    public final boolean homogenous() {
        return true;
    }

    private static final class ItemIter
    extends ValueIter {
        private final Item item;
        private boolean req;

        ItemIter(Item it) {
            this.item = it;
        }

        @Override
        public Item next() {
            if (this.req) {
                return null;
            }
            this.req = true;
            return this.item;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public Item get(long i) {
            return this.item;
        }

        @Override
        public boolean reset() {
            this.req = false;
            return true;
        }

        @Override
        public Value value() {
            return this.item;
        }
    }
}

