/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.Seq;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ItemSeq
extends Seq {
    private final Item[] item;
    private SeqType seq;

    protected ItemSeq(Item[] it, int s) {
        super(s);
        this.item = it;
    }

    @Override
    public Object toJava() throws QueryException {
        Object[] obj = new Object[(int)this.size];
        int s = 0;
        while ((long)s != this.size) {
            obj[s] = this.item[s].toJava();
            ++s;
        }
        return obj;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        if (!this.item[0].node()) {
            Err.CONDTYPE.thrw(ii, this);
        }
        return this.item[0];
    }

    @Override
    public SeqType type() {
        if (this.seq == null) {
            Type t = this.item[0].type;
            int s = 1;
            while ((long)s != this.size && t != AtomType.ITEM) {
                if (t != this.item[s].type) {
                    t = AtomType.ITEM;
                }
                ++s;
            }
            this.seq = SeqType.get(t, SeqType.Occ.OM);
        }
        return this.seq;
    }

    @Override
    public boolean iterable() {
        return false;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof ItemSeq)) {
            return false;
        }
        ItemSeq is = (ItemSeq)cmp;
        return this.item == is.item && this.size == is.size;
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        System.arraycopy(this.item, 0, arr, start, (int)this.size);
        return (int)this.size;
    }

    @Override
    public Item itemAt(long pos) {
        return this.item[(int)pos];
    }

    @Override
    public boolean homogenous() {
        return false;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(Token.token(Util.name(this)), (byte[][])new byte[][]{QueryText.SIZE, Token.token(this.size)});
        int v = 0;
        while ((long)v != Math.min(this.size, 5L)) {
            this.item[v].plan(ser);
            ++v;
        }
        ser.closeElement();
    }
}

