/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Seq;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ItrSeq
extends Seq {
    final long[] vals;

    private ItrSeq(long[] ints, Type t) {
        super(ints.length, t);
        this.vals = ints;
    }

    @Override
    public boolean homogenous() {
        return true;
    }

    @Override
    public Item itemAt(long pos) {
        return Itr.get(this.vals[(int)pos], this.type);
    }

    public long[] toJava() {
        return (long[])this.vals.clone();
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        int w = Math.min(this.vals.length, arr.length - start);
        int i = 0;
        while (i < w) {
            arr[start + i] = this.itemAt(i);
            ++i;
        }
        return w;
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        throw Err.CONDTYPE.thrw(ii, this);
    }

    @Override
    public SeqType type() {
        return SeqType.get(this.type, SeqType.Occ.OM);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(Token.token(Util.name(this)), (byte[][])new byte[][]{QueryText.SIZE, Token.token(this.size)});
        int v = 0;
        while ((long)v != Math.min(this.size, 5L)) {
            ser.emptyElement(QueryText.ITM, (byte[][])new byte[][]{QueryText.VAL, Token.token(this.vals[v]), QueryText.TYP, this.type.nam()});
            ++v;
        }
        ser.closeElement();
    }

    public static Value get(long[] val, Type type) {
        return val.length == 0 ? Empty.SEQ : (val.length == 1 ? Itr.get(val[0], type) : new ItrSeq(val, type));
    }

    public static Value get(Expr[] expr, long size, Type type) throws QueryException {
        long[] tmp = new long[(int)size];
        int t = 0;
        Expr[] exprArray = expr;
        int n = expr.length;
        int n2 = 0;
        while (n2 < n) {
            int v;
            long vs;
            Value val;
            Expr e = exprArray[n2];
            if (e instanceof Item) {
                tmp[t++] = ((Item)e).itr(null);
            } else if (e instanceof ItrSeq) {
                val = (ItrSeq)e;
                vs = ((Seq)val).size();
                v = 0;
                while ((long)v < vs) {
                    tmp[t++] = ((ItrSeq)val).vals[v];
                    ++v;
                }
            } else {
                val = (Value)e;
                vs = val.size();
                v = 0;
                while ((long)v < vs) {
                    tmp[t++] = val.itemAt(v).itr(null);
                    ++v;
                }
            }
            ++n2;
        }
        return ItrSeq.get(tmp, type);
    }
}

