/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.iter;

import java.io.IOException;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.item.Item;
import org.basex.query.item.Seq;
import org.basex.query.item.Value;
import org.basex.query.iter.ValueIter;
import org.basex.util.Util;

public final class ItemCache
extends ValueIter
implements Result {
    public Item[] item;
    private int size;
    private int pos = -1;

    public ItemCache() {
        this(1);
    }

    public ItemCache(int c) {
        this.item = new Item[c];
    }

    public ItemCache(Item[] it, int s) {
        this.item = it;
        this.size = s;
    }

    public void add(Value val) {
        long sz = val.size();
        while ((long)(this.item.length - this.size) < sz) {
            this.item = ItemCache.extend(this.item);
        }
        this.size += val.writeTo(this.item, this.size);
    }

    public void add(Item it) {
        if (this.size == this.item.length) {
            this.item = ItemCache.extend(this.item);
        }
        this.item[this.size++] = it;
    }

    @Override
    public boolean sameAs(Result v) {
        if (!(v instanceof ItemCache)) {
            return false;
        }
        ItemCache ic = (ItemCache)v;
        if (this.size != ic.size) {
            return false;
        }
        int i = 0;
        while (i < this.size) {
            if (this.item[i].type != ic.item[i].type || !this.item[i].sameAs(ic.item[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        int c = 0;
        while (c < this.size && !ser.finished()) {
            this.serialize(ser, c);
            ++c;
        }
    }

    @Override
    public void serialize(Serializer ser, int n) throws IOException {
        ser.openResult();
        this.item[n].serialize(ser);
        ser.closeResult();
    }

    @Override
    public Item next() {
        return ++this.pos < this.size ? this.item[this.pos] : null;
    }

    public void pos(int p) {
        this.pos = p;
    }

    public void size(int s) {
        this.size = s;
    }

    @Override
    public boolean reset() {
        this.pos = -1;
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Item get(long i) {
        return this.item[(int)i];
    }

    public void set(Item i, int p) {
        this.item[p] = i;
    }

    @Override
    public Value value() {
        return Seq.get(this.item, this.size);
    }

    public String toString() {
        ArrayOutput ao = new ArrayOutput();
        try {
            this.serialize(Serializer.get(ao));
        }
        catch (IOException ex) {
            Util.notexpected(ex);
        }
        return ao.toString();
    }
}

