/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.data.StatsKey;
import org.basex.index.path.PathNode;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.Pos;
import org.basex.query.item.ANode;
import org.basex.query.item.Bln;
import org.basex.query.item.Empty;
import org.basex.query.item.NodeType;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeCache;
import org.basex.query.iter.NodeIter;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisStep;
import org.basex.query.path.DocTest;
import org.basex.query.path.IterPath;
import org.basex.query.path.Path;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.ObjList;

public class AxisPath
extends Path {
    private boolean cache;
    private NodeCache citer;
    private Value lvalue;

    protected AxisPath(InputInfo ii, Expr r, Expr ... s) {
        super(ii, r, s);
    }

    protected final AxisPath finish(QueryContext ctx) {
        this.size = this.size(ctx);
        this.type = SeqType.get(this.steps[this.steps.length - 1].type().type, this.size);
        return this.useIterator() ? new IterPath(this.input, this.root, this.steps, this.type, this.size) : this;
    }

    private boolean useIterator() {
        if (this.root == null || this.root.uses(Expr.Use.VAR) || !this.root.iterable()) {
            return false;
        }
        int sl = this.steps.length;
        int s = 0;
        while (s < sl) {
            switch (this.step((int)s).axis) {
                case ANCORSELF: 
                case ANC: 
                case PRECSIBL: 
                case PREC: {
                    return false;
                }
                case DESCORSELF: 
                case DESC: 
                case FOLLSIBL: 
                case FOLL: {
                    return s + 1 == sl || s + 2 == sl && this.step((int)(s + 1)).axis == Axis.ATTR;
                }
            }
            ++s;
        }
        return true;
    }

    @Override
    protected final Expr compPath(QueryContext ctx) throws QueryException {
        Expr s;
        Expr[] exprArray = this.steps;
        int n = this.steps.length;
        int n2 = 0;
        while (n2 < n) {
            s = exprArray[n2];
            this.checkUp(s, ctx);
            ++n2;
        }
        if (this.root instanceof AxisPath) {
            Expr[] st = ((AxisPath)this.root).steps;
            this.root = ((AxisPath)this.root).root;
            Expr[] exprArray2 = this.steps;
            int n3 = this.steps.length;
            n = 0;
            while (n < n3) {
                Expr s2 = exprArray2[n];
                st = Array.add(st, s2);
                ++n;
            }
            this.steps = st;
            ctx.compInfo("merging axis paths", new Object[0]);
            ctx.value = this.root(ctx);
        }
        if ((s = this.voidStep(this.steps)) != null) {
            Err.COMPSELF.thrw(this.input, s);
        }
        int i = 0;
        while (i != this.steps.length) {
            Expr e = this.steps[i].comp(ctx);
            if (!(e instanceof AxisStep)) {
                return e;
            }
            this.steps[i] = e;
            ++i;
        }
        this.optSteps(ctx);
        Data data = ctx.data();
        if (data != null && ctx.value.type == NodeType.DOC) {
            Expr e = this.index(ctx, data);
            if (e == this) {
                e = this.children(ctx, data);
            }
            if (e != this) {
                return e.comp(ctx);
            }
        }
        this.cache = this.root != null && !this.uses(Expr.Use.VAR);
        AxisPath path = this.finish(ctx);
        return this.size() != 1L ? path : new Filter(this.input, this, Pos.get(1L, this.size(), this.input)).comp2(ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expr index(QueryContext ctx, Data data) throws QueryException {
        boolean simple;
        int j;
        if (this.root == null) return this;
        if (this.uses(Expr.Use.POS)) {
            return this;
        }
        IndexContext ics = null;
        int pmin = 0;
        int smin = 0;
        int s = 0;
        while (s < this.steps.length) {
            AxisStep stp = this.step(s);
            if (!stp.axis.down) break;
            boolean i = this.pathNodes(data, s) != null;
            int p = 0;
            while (p < stp.preds.length) {
                IndexContext ic = new IndexContext(ctx, data, stp, i);
                if (stp.preds[p].indexAccessible(ic)) {
                    if (ic.costs() == 0) {
                        if (!ic.not) {
                            ctx.compInfo("removing path with no index results", this);
                            return Empty.SEQ;
                        }
                        stp.preds[p] = Bln.TRUE;
                    } else if (ics == null || ics.costs() > ic.costs()) {
                        ics = ic;
                        pmin = p;
                        smin = s;
                    }
                }
                ++p;
            }
            ++s;
        }
        if (ics == null) return this;
        if (ics.costs() > data.meta.size) {
            return this;
        }
        AxisStep stp = this.step(smin);
        Expr ie = stp.preds[pmin].indexEquivalent(ics);
        if (ics.seq) {
            stp.preds[pmin] = ie;
            return this;
        }
        Expr[] invSteps = new AxisStep[]{};
        Expr[] newPreds = new Expr[stp.preds.length - 1];
        int c = 0;
        int p = 0;
        while (p != stp.preds.length) {
            if (p != pmin) {
                newPreds[c++] = stp.preds[p];
            }
            ++p;
        }
        Test test = DocTest.get(ctx, data);
        boolean inv = true;
        if (test == Test.DOC && data.meta.pathindex || data.meta.uptodate) {
            j = 0;
            while (j <= smin) {
                int name;
                ObjList<PathNode> pn;
                AxisStep s2 = this.axisStep(j);
                if (s2 == null || s2.axis != Axis.CHILD || s2.preds.length > 0 && j != smin || s2.test.test != Test.Name.ALL && s2.test.test != null && (s2.test.test != Test.Name.NAME || (pn = data.pthindex.desc(name = data.tagindex.id(s2.test.name.ln()), 1)).size() != 1 || pn.get(0).level() != j + 1)) break;
                ++j;
            }
            boolean bl = inv = j <= smin;
        }
        if (inv) {
            j = smin;
            while (j >= 0) {
                Axis ax = this.step((int)j).axis.invert();
                if (ax == null) break;
                if (j != 0) {
                    AxisStep prev = this.step(j - 1);
                    invSteps = Array.add(invSteps, AxisStep.get(this.input, ax, prev.test, prev.preds));
                } else if (test != Test.DOC || ax != Axis.ANC && ax != Axis.ANCORSELF) {
                    invSteps = Array.add(invSteps, AxisStep.get(this.input, ax, test, new Expr[0]));
                }
                --j;
            }
        }
        AxisPath result = null;
        boolean bl = simple = invSteps.length == 0 && newPreds.length == 0;
        if (ie instanceof AxisPath) {
            result = (AxisPath)ie;
        } else {
            if (smin + 1 >= this.steps.length) {
                if (simple) return ie;
            }
            result = simple ? new AxisPath(this.input, ie, new Expr[0]) : new AxisPath(this.input, ie, AxisStep.get(this.input, Axis.SELF, Test.NOD, new Expr[0]));
        }
        int ls = result.steps.length - 1;
        if (ls >= 0) {
            result.steps[ls] = result.step(ls).addPreds(newPreds);
            if (invSteps.length != 0) {
                result.steps[ls] = result.step(ls).addPreds(Path.get(this.input, null, invSteps));
            }
        }
        int s3 = smin + 1;
        while (s3 < this.steps.length) {
            result.steps = Array.add(result.steps, this.steps[s3]);
            ++s3;
        }
        return result;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value r;
        Value c = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        Value value = r = this.root != null ? this.root.value(ctx) : c;
        if (!this.cache || this.citer == null || this.lvalue.type != NodeType.DOC || r.type != NodeType.DOC || !((ANode)this.lvalue).is((ANode)r)) {
            this.lvalue = r;
            this.citer = new NodeCache().random();
            if (r != null) {
                Iter ir = ctx.iter(r);
                while ((r = ir.next()) != null) {
                    ctx.value = r;
                    this.iter(0, this.citer, ctx);
                }
            } else {
                ctx.value = null;
                this.iter(0, this.citer, ctx);
            }
            this.citer.sort();
        } else {
            this.citer.reset();
        }
        ctx.value = c;
        ctx.size = cs;
        ctx.pos = cp;
        return this.citer;
    }

    private void iter(int l, NodeCache nc, QueryContext ctx) throws QueryException {
        ANode node;
        NodeIter ni = (NodeIter)ctx.iter(this.steps[l]);
        boolean more = l + 1 != this.steps.length;
        while ((node = ni.next()) != null) {
            if (more) {
                ctx.value = node;
                this.iter(l + 1, nc, ctx);
                continue;
            }
            ctx.checkStop();
            nc.add(node);
        }
    }

    public final AxisPath invertPath(Expr r, AxisStep curr) {
        int s = this.steps.length;
        Expr[] e = new Expr[s--];
        Expr rt = this.step((int)s).preds.length != 0 ? new Filter(this.input, r, this.step((int)s).preds) : r;
        int c = 0;
        while (--s >= 0) {
            e[c++] = AxisStep.get(this.input, this.step((int)(s + 1)).axis.invert(), this.step((int)s).test, this.step((int)s).preds);
        }
        e[c] = AxisStep.get(this.input, this.step((int)(s + 1)).axis.invert(), curr.test, new Expr[0]);
        return new AxisPath(this.input, rt, e);
    }

    @Override
    public final Expr addText(QueryContext ctx) throws QueryException {
        AxisStep s = this.step(this.steps.length - 1);
        if (s.preds.length != 0 || !s.axis.down || s.test.type == NodeType.ATT || s.test.test != Test.Name.NAME && s.test.test != Test.Name.STD) {
            return this;
        }
        Data data = ctx.data();
        if (data == null || !data.meta.uptodate) {
            return this;
        }
        StatsKey stats = data.tagindex.stat(data.tagindex.id(s.test.name.ln()));
        if (stats != null && stats.leaf) {
            this.steps = Array.add(this.steps, AxisStep.get(this.input, Axis.CHILD, Test.TXT, new Expr[0]));
            ctx.compInfo("adding text() step", this);
        }
        return this;
    }

    public final AxisStep step(int i) {
        return (AxisStep)this.steps[i];
    }

    public final Path copy() {
        Expr[] stps = new Expr[this.steps.length];
        int s = 0;
        while (s < this.steps.length) {
            stps[s] = AxisStep.get(this.step(s));
            ++s;
        }
        return AxisPath.get(this.input, this.root, stps);
    }

    @Override
    public final int count(Var v) {
        int c = 0;
        Expr[] exprArray = this.steps;
        int n = this.steps.length;
        int n2 = 0;
        while (n2 < n) {
            Expr s = exprArray[n2];
            c += s.count(v);
            ++n2;
        }
        return c + super.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        Expr[] exprArray = this.steps;
        int n = this.steps.length;
        int n2 = 0;
        while (n2 < n) {
            Expr s = exprArray[n2];
            if (!s.removable(v)) {
                return false;
            }
            ++n2;
        }
        return super.removable(v);
    }

    @Override
    public final Expr remove(Var v) {
        int s = 0;
        while (s != this.steps.length) {
            this.steps[s].remove(v);
            ++s;
        }
        return super.remove(v);
    }

    @Override
    public final boolean iterable() {
        return true;
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof AxisPath)) {
            return false;
        }
        AxisPath ap = (AxisPath)cmp;
        if ((this.root == null || ap.root == null) && this.root != ap.root || this.steps.length != ap.steps.length || this.root != null && !this.root.sameAs(ap.root)) {
            return false;
        }
        int s = 0;
        while (s < this.steps.length) {
            if (!this.steps[s].sameAs(ap.steps[s])) {
                return false;
            }
            ++s;
        }
        return true;
    }
}

