/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.io.IOException;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CAttr;
import org.basex.query.expr.CDoc;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Root;
import org.basex.query.item.DBNode;
import org.basex.query.item.Empty;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisPath;
import org.basex.query.path.AxisStep;
import org.basex.query.path.MixedPath;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.ObjList;

public abstract class Path
extends ParseExpr {
    public Expr root;
    public Expr[] steps;

    protected Path(InputInfo ii, Expr r, Expr[] s) {
        super(ii);
        this.root = r;
        this.steps = s;
    }

    public static final Path get(InputInfo ii, Expr r, Expr ... path) {
        boolean axes = true;
        Expr[] exprArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Expr p = exprArray[n2];
            axes &= p instanceof AxisStep;
            ++n2;
        }
        return axes ? new AxisPath(ii, r, path).finish(null) : new MixedPath(ii, r, path);
    }

    @Override
    public final Expr comp(QueryContext ctx) throws QueryException {
        if (this.root != null) {
            this.root = this.checkUp(this.root, ctx).comp(ctx);
            if (this.root instanceof Context) {
                this.root = null;
            }
        }
        Value v = ctx.value;
        ctx.value = this.root(ctx);
        Expr e = this.compPath(ctx);
        ctx.value = v;
        return e;
    }

    protected abstract Expr compPath(QueryContext var1) throws QueryException;

    protected final Value root(QueryContext ctx) {
        Value v;
        Value value = v = ctx != null ? ctx.value : null;
        if (this.root == null) {
            return v == null || v.type != NodeType.DOC ? v : null;
        }
        if (this.root.value()) {
            return (Value)this.root;
        }
        if (!(this.root instanceof Root) || v == null) {
            return null;
        }
        return v.size() != 1L ? v : ((Root)this.root).root(v);
    }

    @Override
    public final boolean uses(Expr.Use use) {
        if (use == Expr.Use.CTX) {
            return this.root == null || this.root.uses(use);
        }
        Expr[] exprArray = this.steps;
        int n = this.steps.length;
        int n2 = 0;
        while (n2 < n) {
            Expr s = exprArray[n2];
            if (s.uses(use)) {
                return true;
            }
            ++n2;
        }
        return this.root != null && this.root.uses(use);
    }

    protected void optSteps(QueryContext ctx) {
        boolean opt = false;
        Expr[] st = this.steps;
        int l = 1;
        while (l < st.length) {
            if (st[l - 1] instanceof AxisStep && st[l] instanceof AxisStep) {
                AxisStep prev = (AxisStep)st[l - 1];
                AxisStep curr = (AxisStep)st[l];
                if (prev.simple(Axis.DESCORSELF, false)) {
                    if (curr.axis == Axis.CHILD && !curr.uses(Expr.Use.POS)) {
                        Array.move(st, l, -1, st.length - l);
                        st = Arrays.copyOf(st, st.length - 1);
                        curr.axis = Axis.DESC;
                        opt = true;
                    } else if (curr.axis == Axis.ATTR && !curr.uses(Expr.Use.POS)) {
                        prev.test = new NameTest(false, prev.input);
                        opt = true;
                    }
                }
            }
            ++l;
        }
        if (opt) {
            ctx.compInfo("optimizing descendant-or-self step(s)", new Object[0]);
        }
        if (this.root == null && st.length == 1 && st[0] instanceof AxisPath) {
            AxisStep curr = (AxisStep)st[0];
            if (curr.axis == Axis.ATTR && curr.test.test == Test.Name.STD) {
                curr.type = SeqType.NOD_ZO;
            }
        }
        this.steps = st;
    }

    protected long size(QueryContext ctx) {
        Data data;
        Value rt = this.root(ctx);
        Data data2 = data = rt != null && rt.type == NodeType.DOC ? rt.data() : null;
        if (!(data != null && data.meta.pathindex && data.meta.uptodate && data.single())) {
            return -1L;
        }
        ObjList<PathNode> nodes = data.pthindex.root();
        long m = 1L;
        int s = 0;
        while (s < this.steps.length) {
            AxisStep curr = this.axisStep(s);
            if (curr != null) {
                if ((nodes = curr.size(nodes, data)) == null) {
                    return -1L;
                }
            } else if (s + 1 == this.steps.length) {
                m = this.steps[s].size();
            } else {
                return -1L;
            }
            ++s;
        }
        long sz = 0L;
        for (PathNode pn : nodes) {
            sz += (long)pn.size;
        }
        return sz * m;
    }

    protected AxisStep voidStep(Expr[] stps) {
        int l = 0;
        while (l < stps.length) {
            AxisStep s = this.axisStep(l);
            if (s != null) {
                Axis sa = s.axis;
                if (l == 0) {
                    if (this.root instanceof CAttr ? sa == Axis.CHILD || sa == Axis.DESC : (this.root instanceof DBNode && ((Value)this.root).type == NodeType.DOC || this.root instanceof CDoc) && sa != Axis.CHILD && sa != Axis.DESC && sa != Axis.DESCORSELF && (sa != Axis.SELF && sa != Axis.ANCORSELF || s.test != Test.NOD && s.test != Test.DOC)) {
                        return s;
                    }
                } else {
                    AxisStep ls = this.axisStep(l - 1);
                    if (ls != null) {
                        Axis lsa = ls.axis;
                        if (sa == Axis.SELF || sa == Axis.DESCORSELF) {
                            if (s.test != Test.NOD) {
                                if (lsa == Axis.ATTR && s.test.type != NodeType.ATT) {
                                    return s;
                                }
                                if (ls.test == Test.TXT && s.test != Test.TXT) {
                                    return s;
                                }
                                if (sa != Axis.DESCORSELF) {
                                    QNm n1 = s.test.name;
                                    QNm n0 = ls.test.name;
                                    if (n0 != null && n1 != null && !n1.eq(n0)) {
                                        return s;
                                    }
                                }
                            }
                        } else if (sa == Axis.FOLLSIBL || sa == Axis.PRECSIBL ? lsa == Axis.ATTR : (sa == Axis.DESC || sa == Axis.CHILD || sa == Axis.ATTR ? lsa == Axis.ATTR || ls.test == Test.TXT || ls.test == Test.COM || ls.test == Test.PI : (sa == Axis.PARENT || sa == Axis.ANC) && ls.test == Test.DOC)) {
                            return s;
                        }
                    }
                }
            }
            ++l;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Expr children(QueryContext ctx, Data data) {
        if (!data.meta.pathindex || !data.meta.uptodate) {
            return this;
        }
        Path path = this;
        int s = 0;
        while (s < this.steps.length) {
            ObjList<PathNode> objList;
            AxisStep prev;
            AxisStep axisStep = prev = s > 0 ? this.axisStep(s - 1) : null;
            if (prev != null && prev.preds.length != 0) break;
            AxisStep curr = this.axisStep(s);
            if (curr != null && curr.axis == Axis.DESC && !curr.uses(Expr.Use.POS) && (objList = this.pathNodes(data, s)) != null) {
                void var7_9;
                ObjList<QNm> qnm = new ObjList<QNm>();
                while (((PathNode)var7_9.get((int)0)).par != null) {
                    QNm nm = new QNm(data.tagindex.key(((PathNode)var7_9.get((int)0)).name));
                    if (nm.ns()) {
                        return this;
                    }
                    int j = 0;
                    while (j < var7_9.size()) {
                        if (((PathNode)var7_9.get((int)0)).name != ((PathNode)var7_9.get((int)j)).name) {
                            nm = null;
                        }
                        ++j;
                    }
                    qnm.add(nm);
                    ObjList<PathNode> objList2 = data.pthindex.parent((ObjList<PathNode>)var7_9);
                }
                ctx.compInfo("converting % to child steps", this.steps[s]);
                int ts = qnm.size();
                Expr[] stps = new Expr[ts + this.steps.length - s - 1];
                int t = 0;
                while (t < ts) {
                    Expr[] preds = t == ts - 1 ? ((AxisStep)this.steps[s]).preds : new Expr[]{};
                    QNm nm = (QNm)qnm.get(ts - t - 1);
                    NameTest nt = nm == null ? new NameTest(false, this.input) : new NameTest(nm, Test.Name.NAME, false, this.input);
                    stps[t] = AxisStep.get(this.input, Axis.CHILD, nt, preds);
                    ++t;
                }
                while (++s < this.steps.length) {
                    stps[ts++] = this.steps[s];
                }
                path = Path.get(this.input, this.root, stps);
                break;
            }
            ++s;
        }
        if (data.ns.size() == 0) {
            s = 0;
            while (s < path.steps.length) {
                block14: {
                    AxisStep st = path.axisStep(s);
                    if (st == null || st.axis != Axis.CHILD) break;
                    if (st.test.test != Test.Name.ALL && st.test.test != null) {
                        if (st.test.test != Test.Name.NAME) break;
                        int name = data.tagindex.id(st.test.name.ln());
                        for (PathNode pathNode : data.pthindex.desc(name, 1)) {
                            if (pathNode.level() != s + 1) {
                                continue;
                            }
                            break block14;
                        }
                        ctx.compInfo("removing non-existing path %", path);
                        return Empty.SEQ;
                    }
                }
                ++s;
            }
        }
        return path;
    }

    public AxisStep axisStep(int i) {
        return this.steps[i] instanceof AxisStep ? (AxisStep)this.steps[i] : null;
    }

    protected ObjList<PathNode> pathNodes(Data data, int l) {
        if (!data.meta.pathindex || !data.meta.uptodate) {
            return null;
        }
        ObjList<PathNode> in = data.pthindex.root();
        int s = 0;
        while (s <= l) {
            boolean desc;
            AxisStep curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            boolean bl = desc = curr.axis == Axis.DESC;
            if (!desc && curr.axis != Axis.CHILD || curr.test.test != Test.Name.NAME) {
                return null;
            }
            int name = data.tagindex.id(curr.test.name.ln());
            ObjList<PathNode> al = new ObjList<PathNode>();
            for (PathNode pn : data.pthindex.desc(in, desc)) {
                if (pn.kind != 1 || name != pn.name) continue;
                if (al.size() != 0 && ((PathNode)al.get(0)).level() != pn.level()) {
                    return null;
                }
                al.add(pn);
            }
            if (al.size() == 0) {
                return null;
            }
            in = al;
            ++s;
        }
        return in;
    }

    public final Path addPreds(Expr ... pred) {
        this.steps[this.steps.length - 1] = this.axisStep(this.steps.length - 1).addPreds(pred);
        return Path.get(this.input, this.root, this.steps);
    }

    @Override
    public int count(Var v) {
        return this.root != null ? this.root.count(v) : 0;
    }

    @Override
    public boolean removable(Var v) {
        return this.root == null || this.root.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        if (this.root != null) {
            this.root = this.root.remove(v);
        }
        if (this.root instanceof Context) {
            this.root = null;
        }
        return this;
    }

    @Override
    public final void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        if (this.root != null) {
            this.root.plan(ser);
        }
        Expr[] exprArray = this.steps;
        int n = this.steps.length;
        int n2 = 0;
        while (n2 < n) {
            Expr s = exprArray[n2];
            s.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            sb.append(this.root);
        }
        Expr[] exprArray = this.steps;
        int n = this.steps.length;
        int n2 = 0;
        while (n2 < n) {
            Expr s = exprArray[n2];
            sb.append(String.valueOf(sb.length() != 0 ? "/" : "") + s);
            ++n2;
        }
        return sb.toString();
    }
}

