/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.core.cmd.Export;
import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.up.NamePool;
import org.basex.query.up.NodeUpdates;
import org.basex.query.up.primitives.NodeCopy;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.util.hash.IntMap;
import org.basex.util.list.IntList;

final class DatabaseUpdates {
    private final Data data;
    IntList nodes = new IntList(0);
    final IntMap<NodeUpdates> updatePrimitives = new IntMap();

    DatabaseUpdates(Data d) {
        this.data = d;
    }

    void add(UpdatePrimitive p) throws QueryException {
        int pre = p.pre;
        NodeUpdates pc = this.updatePrimitives.get(pre);
        if (pc == null) {
            pc = new NodeUpdates();
            this.updatePrimitives.add(pre, pc);
        }
        pc.add(p);
    }

    protected void check() throws QueryException {
        int s = this.updatePrimitives.size();
        this.nodes = new IntList(s);
        int i = 1;
        while (i <= this.updatePrimitives.size()) {
            this.nodes.add(this.updatePrimitives.key(i));
            ++i;
        }
        this.nodes.sort();
        i = 0;
        while (i < s) {
            NodeUpdates ups = this.updatePrimitives.get(this.nodes.get(i));
            UpdatePrimitive[] updatePrimitiveArray = ups.prim;
            int n = ups.prim.length;
            int n2 = 0;
            while (n2 < n) {
                UpdatePrimitive p = updatePrimitiveArray[n2];
                if (p instanceof NodeCopy) {
                    ((NodeCopy)p).prepare();
                }
                if (p.type == PrimitiveType.PUT && this.ancestorDeleted(this.nodes.get(i))) {
                    Err.UPFOTYPE.thrw(p.input, p);
                }
                ++n2;
            }
            ++i;
        }
        int p = this.nodes.size() - 1;
        int par = -1;
        while (p >= 0) {
            if (par == this.nodes.get(p) && --p < 0) break;
            int pre = this.nodes.get(p);
            int k = this.data.kind(pre);
            if (k == 3) {
                par = this.data.parent(pre, k);
                IntList il = new IntList();
                while (p >= 0 && (pre = this.nodes.get(p)) > par) {
                    il.add(pre);
                    --p;
                }
                if (par != -1) {
                    il.add(par);
                }
                this.checkNames(il.toArray());
                continue;
            }
            if (k == 1) {
                this.checkNames(pre);
            }
            --p;
        }
    }

    private void checkNames(int ... pres) throws QueryException {
        NamePool pool = new NamePool();
        IntList il = new IntList();
        int[] nArray = pres;
        int n = pres.length;
        int n2 = 0;
        while (n2 < n) {
            int pre = nArray[n2];
            NodeUpdates ups = this.updatePrimitives.get(pre);
            if (ups != null) {
                UpdatePrimitive[] updatePrimitiveArray = ups.prim;
                int n3 = ups.prim.length;
                int n4 = 0;
                while (n4 < n3) {
                    UpdatePrimitive up = updatePrimitiveArray[n4];
                    up.update(pool);
                    ++n4;
                }
            }
            if (this.data.kind(pre) == 3) {
                il.add(pre);
            } else {
                int ps = pre + this.data.attSize(pre, 1);
                int p = pre + 1;
                while (p < ps) {
                    byte[] nm = this.data.name(p, 3);
                    if (!il.contains(p)) {
                        QNm name = new QNm(nm);
                        byte[] uri = this.data.ns.uri(this.data.ns.uri(nm, p));
                        if (uri != null) {
                            name.uri(uri);
                        }
                        pool.add(name, NodeType.ATT);
                    }
                    ++p;
                }
            }
            ++n2;
        }
        QNm dup = pool.duplicate();
        if (dup != null) {
            Err.UPATTDUPL.thrw(null, dup);
        }
        if (!pool.nsOK()) {
            Err.UPNSCONFL2.thrw(null, new Object[0]);
        }
    }

    private void treeAwareUpdates() {
        int l = this.nodes.size();
        int ni = 0;
        int c = 0;
        while (ni < l - 1) {
            int[] destroyed;
            int pre = this.nodes.get(ni++);
            int[] nArray = destroyed = this.updatePrimitives.get(pre).destroyedNodeIdentities().toArray();
            int n = destroyed.length;
            int n2 = 0;
            while (n2 < n) {
                int pd = nArray[n2];
                int followingAxisPre = pd + this.data.size(pd, this.data.kind(pd));
                while (ni < l && this.nodes.get(ni) < followingAxisPre) {
                    this.nodes.set(ni++, -1);
                    ++c;
                }
                ++n2;
            }
        }
        if (c == 0) {
            return;
        }
        IntList newNodes = new IntList(this.nodes.size() - c);
        int i = 0;
        while (i < this.nodes.size()) {
            int pre = this.nodes.get(i);
            if (pre != -1) {
                newNodes.add(pre);
            }
            ++i;
        }
        this.nodes = newNodes;
    }

    protected void apply() throws QueryException {
        this.treeAwareUpdates();
        NodeUpdates recent = null;
        int i = this.nodes.size() - 1;
        while (i >= 0) {
            NodeUpdates current = this.updatePrimitives.get(this.nodes.get(i));
            if (recent == null) {
                current.makePrimitivesEffective();
            } else {
                recent.resolveExternalTextNodeAdjacency(current.makePrimitivesEffective());
            }
            recent = current;
            --i;
        }
        recent.resolveExternalTextNodeAdjacency(0);
        this.data.flush();
        if (this.data.meta.prop.is(Prop.WRITEBACK) && !this.data.meta.original.isEmpty()) {
            try {
                Export.export(this.data, this.data.meta.original);
            }
            catch (IOException ex) {
                Err.UPPUTERR.thrw(null, this.data.meta.original);
            }
        }
    }

    protected boolean ancestorDeleted(int n) {
        NodeUpdates up = this.updatePrimitives.get(n);
        if (up != null && up.updatesDestroyIdentity(n)) {
            return true;
        }
        int p = this.data.parent(n, this.data.kind(n));
        return p != -1 && this.ancestorDeleted(p);
    }
}

