/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.InsertBefore;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.StructuralUpdate;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.ObjList;

final class NodeUpdates {
    UpdatePrimitive[] prim = new UpdatePrimitive[1];
    private boolean del;
    private boolean rep;
    private boolean adjEXT;
    private boolean adjINT;

    NodeUpdates() {
    }

    void add(UpdatePrimitive p) throws QueryException {
        if (this.prim[0] == null) {
            this.prim[0] = p;
            return;
        }
        PrimitiveType pt = p.type;
        UpdatePrimitive[] updatePrimitiveArray = this.prim;
        int n = this.prim.length;
        int n2 = 0;
        while (n2 < n) {
            UpdatePrimitive up = updatePrimitiveArray[n2];
            if (up.type == pt) {
                up.merge(p);
                return;
            }
            ++n2;
        }
        this.addToPrimitives(p);
    }

    private void addToPrimitives(UpdatePrimitive p) {
        int l = this.prim.length;
        UpdatePrimitive[] t = new UpdatePrimitive[l + 1];
        System.arraycopy(this.prim, 0, t, 0, l);
        t[l] = p;
        this.prim = t;
    }

    private UpdatePrimitive find(PrimitiveType t) {
        UpdatePrimitive[] updatePrimitiveArray = this.prim;
        int n = this.prim.length;
        int n2 = 0;
        while (n2 < n) {
            UpdatePrimitive p = updatePrimitiveArray[n2];
            if (p.type == t) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    private void prepareExecution() {
        PrimitiveType t2;
        UpdatePrimitive p;
        UpdatePrimitive[] updatePrimitiveArray = this.prim;
        int n = this.prim.length;
        int n2 = 0;
        while (n2 < n) {
            p = updatePrimitiveArray[n2];
            t2 = p.type;
            this.del |= t2 == PrimitiveType.DELETENODE;
            this.rep |= t2 == PrimitiveType.REPLACENODE;
            ++n2;
        }
        if (this.prim.length > 1 && (this.rep || this.del)) {
            PrimitiveType dominantOp = this.rep ? PrimitiveType.REPLACENODE : PrimitiveType.DELETENODE;
            ObjList<UpdatePrimitive> up = new ObjList<UpdatePrimitive>();
            UpdatePrimitive[] updatePrimitiveArray2 = this.prim;
            int t2 = this.prim.length;
            int n3 = 0;
            while (n3 < t2) {
                UpdatePrimitive p2 = updatePrimitiveArray2[n3];
                PrimitiveType t3 = p2.type;
                if (t3 == PrimitiveType.INSERTBEFORE || t3 == PrimitiveType.INSERTAFTER || t3 == dominantOp) {
                    up.add(p2);
                }
                ++n3;
            }
            this.prim = up.toArray(new UpdatePrimitive[up.size()]);
        }
        updatePrimitiveArray = this.prim;
        n = this.prim.length;
        int n4 = 0;
        while (n4 < n) {
            p = updatePrimitiveArray[n4];
            t2 = p.type;
            this.del |= t2 == PrimitiveType.DELETENODE;
            this.rep |= t2 == PrimitiveType.REPLACENODE;
            this.adjEXT |= this.del || this.rep || t2 == PrimitiveType.INSERTBEFORE || t2 == PrimitiveType.INSERTAFTER;
            this.adjINT |= t2 == PrimitiveType.INSERTINTO || t2 == PrimitiveType.INSERTINTOFIRST || t2 == PrimitiveType.INSERTINTOLAST;
            ++n4;
        }
        Arrays.sort(this.prim);
    }

    boolean updatesDestroyIdentity(int pre) {
        return (this.del || this.rep) && this.prim[0].pre == pre || this.destroyedNodeIdentities().contains(pre);
    }

    protected IntList destroyedNodeIdentities() {
        IntList d = new IntList();
        UpdatePrimitive[] updatePrimitiveArray = this.prim;
        int n = this.prim.length;
        int n2 = 0;
        while (n2 < n) {
            UpdatePrimitive p = updatePrimitiveArray[n2];
            PrimitiveType t = p.type;
            switch (t) {
                case REPLACENODE: 
                case DELETENODE: {
                    d.add(p.pre);
                    break;
                }
                case REPLACEELEMCONT: {
                    Data data = p.data;
                    int pre = p.pre;
                    int kind = data.kind(pre);
                    int l = pre + data.size(pre, kind);
                    int ipre = pre + data.attSize(pre, kind);
                    while (ipre < l) {
                        d.add(ipre);
                        ipre += data.size(ipre, data.kind(ipre));
                    }
                    break;
                }
            }
            ++n2;
        }
        return d;
    }

    int makePrimitivesEffective() throws QueryException {
        this.prepareExecution();
        int sd = 0;
        UpdatePrimitive[] updatePrimitiveArray = this.prim;
        int n = this.prim.length;
        int n2 = 0;
        while (n2 < n) {
            UpdatePrimitive p = updatePrimitiveArray[n2];
            p.apply();
            if (p instanceof StructuralUpdate) {
                sd += ((StructuralUpdate)p).preShifts();
            }
            ++n2;
        }
        if (this.adjINT) {
            return sd - this.resolveInternalTextNodeAdjacency();
        }
        return sd;
    }

    private int resolveInternalTextNodeAdjacency() {
        int merged = 0;
        InsertBefore ib = (InsertBefore)this.find(PrimitiveType.INSERTBEFORE);
        int c = ib == null ? 0 : ib.preShifts();
        int i = this.prim.length - 1;
        while (i >= 0) {
            if (this.prim[i] instanceof StructuralUpdate) {
                StructuralUpdate p = (StructuralUpdate)this.prim[i];
                if (p.type != PrimitiveType.INSERTAFTER && p.type != PrimitiveType.INSERTBEFORE && p.type != PrimitiveType.REPLACENODE && p.type != PrimitiveType.DELETENODE) {
                    if (p.adjacentTexts(c)) {
                        ++merged;
                        --c;
                    }
                    c += p.preShifts();
                }
            }
            --i;
        }
        return merged;
    }

    void resolveExternalTextNodeAdjacency(int preShifts) {
        if (!this.adjEXT) {
            return;
        }
        int c = preShifts;
        int i = this.prim.length - 1;
        while (i >= 0) {
            if (this.prim[i] instanceof StructuralUpdate) {
                StructuralUpdate p = (StructuralUpdate)this.prim[i];
                if ((p.type == PrimitiveType.INSERTAFTER || p.type == PrimitiveType.INSERTBEFORE || p.type == PrimitiveType.DELETENODE || p.type == PrimitiveType.REPLACENODE) && p.adjacentTexts(c)) {
                    --c;
                }
                c += p.preShifts();
            }
            --i;
        }
    }

    public String toString() {
        return Util.name(this);
    }
}

