/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import org.basex.core.Context;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.data.Data;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class DBOptimize
extends UpdatePrimitive {
    private final Context ctx;
    private boolean all;

    public DBOptimize(Data d, Context c, boolean a, InputInfo info) {
        super(PrimitiveType.DBOPTIMIZE, -1, d, info);
        this.ctx = c;
        this.all = a;
    }

    @Override
    public void merge(UpdatePrimitive p) {
        DBOptimize o = (DBOptimize)p;
        if (o.all) {
            this.all = o.all;
        }
    }

    @Override
    public void apply() throws QueryException {
        try {
            if (this.all) {
                OptimizeAll.optimizeAll(this.data, this.ctx, null);
            } else {
                Optimize.optimize(this.data, this.data.meta.prop);
            }
        }
        catch (Exception ex) {
            Err.DBERR.thrw(this.input, ex);
        }
    }
}

