/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.HashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.PrimitiveType;
import org.basex.query.up.primitives.UpdatePrimitive;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class DBRename
extends UpdatePrimitive {
    private final HashMap<String, String> map = new HashMap();

    public DBRename(Data d, String src, String trg, InputInfo info) {
        super(PrimitiveType.DBRENAME, -1, d, info);
        this.map.put(src, trg);
    }

    @Override
    public void merge(UpdatePrimitive p) throws QueryException {
        for (Map.Entry<String, String> e : ((DBRename)p).map.entrySet()) {
            String src = e.getKey();
            if (this.map.containsKey(src)) {
                Err.UPPATHREN.thrw(this.input, src);
            }
            this.map.put(src, e.getValue());
        }
    }

    @Override
    public void apply() throws QueryException {
        for (Map.Entry<String, String> op : this.map.entrySet()) {
            IOFile src = this.data.meta.binary(op.getKey());
            if (!src.exists() || src.rename(this.data.meta.binary(op.getValue()))) continue;
            Err.UPDBRENAMEERR.thrw(this.input, src);
        }
    }
}

