/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.basex.query.QueryException;
import org.basex.query.item.Item;
import org.basex.query.item.Str;
import org.basex.query.util.Err;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;

public final class Encryption {
    private final InputInfo input;
    private static final byte[] SYM = Token.token("symmetric");
    private static final byte[] BASE64 = Token.token("base64");
    private static final byte[] HEX = Token.token("hex");
    private static final TokenMap ALGE = new TokenMap();
    private static final TokenMap ALGN = new TokenMap();
    private static final TokenMap ALGHMAC = new TokenMap();
    private static final byte[] DES = Token.token("des");
    private static final byte[] AES = Token.token("aes");

    static {
        ALGE.add(DES, Token.token("8"));
        ALGE.add(AES, Token.token("16"));
        ALGN.add(DES, Token.token("DES/CBC/PKCS5Padding"));
        ALGN.add(AES, Token.token("AES/CBC/PKCS5Padding"));
        ALGHMAC.add(Token.token("md5"), Token.token("hmacmd5"));
        ALGHMAC.add(Token.token("sha1"), Token.token("hmacsha1"));
        ALGHMAC.add(Token.token("sha256"), Token.token("hmacsha256"));
        ALGHMAC.add(Token.token("sha384"), Token.token("hmacsha1"));
        ALGHMAC.add(Token.token("sha512"), Token.token("hmacsha512"));
    }

    public Encryption(InputInfo ii) {
        this.input = ii;
    }

    public Str encryption(byte[] in, byte[] s, byte[] k, byte[] a, boolean ec) throws QueryException {
        boolean symmetric = Token.eq(Token.lc(s), SYM);
        byte[] tivl = ALGE.get(Token.lc(a));
        if (!symmetric || tivl == null) {
            Err.CRYPTOINVALGO.thrw(this.input, new Object[]{s});
        }
        int ivl = Token.toInt(tivl);
        byte[] t = null;
        try {
            t = ec ? this.encrypt(in, k, a, ivl) : this.decrypt(in, k, a, ivl);
        }
        catch (NoSuchPaddingException e) {
            Err.CRYPTONOPAD.thrw(this.input, e);
        }
        catch (BadPaddingException e) {
            Err.CRYPTOBADPAD.thrw(this.input, e);
        }
        catch (NoSuchAlgorithmException e) {
            Err.CRYPTOINVALGO.thrw(this.input, e);
        }
        catch (InvalidKeyException e) {
            Err.CRYPTOKEYINV.thrw(this.input, e);
        }
        catch (IllegalBlockSizeException e) {
            Err.CRYPTOILLBLO.thrw(this.input, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            Err.CRYPTOINVALGO.thrw(this.input, e);
        }
        return Str.get(t);
    }

    public byte[] encrypt(byte[] in, byte[] k, byte[] a, int ivl) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(Token.string(ALGN.get(Token.lc(a))));
        SecretKeySpec kspec = new SecretKeySpec(k, Token.string(a));
        byte[] iv = new byte[ivl];
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        rand.nextBytes(iv);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(1, (Key)kspec, ivspec);
        byte[] t = cipher.doFinal(in);
        return Token.concat(iv, t);
    }

    public byte[] decrypt(byte[] in, byte[] k, byte[] a, int ivl) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec keySpec = new SecretKeySpec(k, Token.string(a));
        Cipher cipher = Cipher.getInstance(Token.string(ALGN.get(Token.lc(a))));
        byte[] iv = Token.substring(in, 0, ivl);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivspec);
        return cipher.doFinal(Token.substring(in, ivl, in.length));
    }

    public Item hmac(byte[] msg, byte[] k, byte[] a, byte[] enc) throws QueryException {
        boolean b64;
        SecretKeySpec key = new SecretKeySpec(k, Token.string(a));
        byte[] hash = null;
        if (ALGHMAC.id(a) == 0) {
            Err.CRYPTOINVHASH.thrw(this.input, new Object[]{a});
        }
        boolean bl = b64 = Token.eq(Token.lc(enc), BASE64) || enc.length == 0;
        if (!b64 && !Token.eq(Token.lc(enc), HEX)) {
            Err.CRYPTOENC.thrw(this.input, new Object[]{enc});
        }
        try {
            Mac mac = Mac.getInstance(Token.string(ALGHMAC.get(Token.lc(a))));
            mac.init(key);
            hash = mac.doFinal(msg);
        }
        catch (NoSuchAlgorithmException e) {
            Err.CRYPTOINVHASH.thrw(this.input, e);
        }
        catch (InvalidKeyException e) {
            Err.CRYPTOKEYINV.thrw(this.input, e);
        }
        if (b64) {
            return Str.get(Base64.encode(hash));
        }
        return Str.get(Token.hex(hash, true));
    }
}

