/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.basex.build.Parser;
import org.basex.build.file.HTMLParser;
import org.basex.core.Prop;
import org.basex.io.IOContent;
import org.basex.io.in.TextInput;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.B64;
import org.basex.query.item.Bln;
import org.basex.query.item.DBNode;
import org.basex.query.item.FAttr;
import org.basex.query.item.FElem;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.Str;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.NodeCache;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ByteList;

public final class ResponseHandler {
    private static final byte[] RESPONSE = Token.token("http:response");
    private static final byte[] MULTIPART = Token.token("http:multipart");
    private static final byte[] PART = Token.token("part");
    private static final byte[] BOUNDARY = Token.token("boundary");
    private static final byte[] HEADER = Token.token("http:header");
    private static final byte[] HDR_NAME = Token.token("name");
    private static final byte[] HDR_VALUE = Token.token("value");
    private static final byte[] BODY = Token.token("http:body");
    private static final byte[] MEDIATYPE = Token.token("media-type");
    private static final byte[] STATUS = Token.token("status");
    private static final byte[] MSG = Token.token("message");
    private static final byte[] APPL_XML = Token.token("application/xml");
    private static final byte[] APPL_EXT_XML = Token.token("application/xml-external-parsed-entity");
    private static final byte[] TXT_XML = Token.token("text/xml");
    private static final byte[] TXT_EXT_XML = Token.token("text/xml-external-parsed-entity");
    private static final byte[] MIME_XML_SUFFIX = Token.token("+xml");
    private static final byte[] TXT_HTML = Token.token("text/html");
    private static final byte[] OCT_STREAM = Token.token("application/octet-stream");
    private static final byte[] MIME_TEXT_PREFIX = Token.token("text/");
    private static final byte[] TXT_PLAIN = Token.token("text/plain");
    private static final byte[] CONT_TYPE_LC = Token.token("content-type");

    private ResponseHandler() {
    }

    public static ValueIter getResponse(HttpURLConnection conn, byte[] statusOnly, byte[] mediaTypeOvr, Prop prop, InputInfo ii) throws IOException, QueryException {
        FElem body;
        boolean s;
        NodeCache attrs = ResponseHandler.extractAttrs(conn);
        NodeCache hdrs = ResponseHandler.extractHdrs(conn);
        byte[] contentType = mediaTypeOvr == null ? ResponseHandler.extractContentType(conn.getContentType()) : mediaTypeOvr;
        ItemCache payloads = new ItemCache();
        boolean bl = s = statusOnly != null && Bln.parse(statusOnly, ii);
        if (Token.startsWith(contentType, Token.token("multipart"))) {
            byte[] boundary = ResponseHandler.extractBoundary(conn.getContentType(), ii);
            NodeCache a = new NodeCache();
            a.add(new FAttr(new QNm(MEDIATYPE, Token.EMPTY), contentType));
            a.add(new FAttr(new QNm(BOUNDARY, Token.EMPTY), boundary));
            body = new FElem(new QNm(MULTIPART, QueryText.HTTPURI), ResponseHandler.extractParts(conn.getInputStream(), s, payloads, Token.concat(Token.token("--"), boundary), prop, ii), a, new Atts().add(QueryText.HTTP, QueryText.HTTPURI), Token.EMPTY);
        } else {
            body = ResponseHandler.createBody(contentType);
            if (!s) {
                payloads.add(ResponseHandler.interpretPayload(ResponseHandler.extractPayload(conn.getInputStream(), ResponseHandler.extractCharset(conn.getContentType())), contentType, prop, ii));
            }
        }
        FElem responseEl = new FElem(new QNm(RESPONSE, QueryText.HTTPURI), hdrs, attrs, new Atts().add(QueryText.HTTP, QueryText.HTTPURI), Token.EMPTY);
        responseEl.add(body);
        ItemCache result = new ItemCache();
        result.add(responseEl);
        result.add(payloads.value());
        return result;
    }

    private static NodeCache extractAttrs(HttpURLConnection conn) throws IOException {
        NodeCache a = new NodeCache();
        a.add(new FAttr(new QNm(STATUS, Token.EMPTY), Token.token(conn.getResponseCode())));
        a.add(new FAttr(new QNm(MSG, Token.EMPTY), Token.token(conn.getResponseMessage())));
        return a;
    }

    private static NodeCache extractHdrs(HttpURLConnection conn) {
        NodeCache h = new NodeCache();
        for (String headerName : conn.getHeaderFields().keySet()) {
            if (headerName == null) continue;
            FElem hdr = new FElem(new QNm(HEADER, QueryText.HTTPURI), new Atts().add(QueryText.HTTP, QueryText.HTTPURI), null);
            hdr.add(new FAttr(new QNm(HDR_NAME, Token.EMPTY), Token.token(headerName)));
            hdr.add(new FAttr(new QNm(HDR_VALUE, Token.EMPTY), Token.token(conn.getHeaderField(headerName))));
            h.add(hdr);
        }
        return h;
    }

    private static FElem createBody(byte[] mediaType) {
        FElem b = new FElem(new QNm(BODY, QueryText.HTTPURI), new Atts().add(QueryText.HTTP, QueryText.HTTPURI), null);
        b.add(new FAttr(new QNm(MEDIATYPE, Token.EMPTY), mediaType));
        return b;
    }

    private static byte[] extractPayload(InputStream io, String cs) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(io);
        try {
            ByteList bl = new ByteList();
            int i = 0;
            while ((i = bis.read()) != -1) {
                bl.add(i);
            }
            byte[] byArray = TextInput.content(new IOContent(bl.toArray()), cs).finish();
            return byArray;
        }
        finally {
            bis.close();
        }
    }

    private static Item interpretPayload(byte[] p, byte[] c, Prop prop, InputInfo ii) throws IOException, QueryException {
        if (Token.eq(c, TXT_XML) || Token.eq(c, TXT_EXT_XML) || Token.eq(c, APPL_XML) || Token.eq(c, APPL_EXT_XML) || Token.endsWith(c, MIME_XML_SUFFIX)) {
            return new DBNode(Parser.xmlParser(new IOContent(p), prop), prop);
        }
        if (Token.eq(c, TXT_HTML)) {
            if (!HTMLParser.available()) {
                throw Err.HTMLERR.thrw(ii, new Object[0]);
            }
            return new DBNode(new HTMLParser(new IOContent(p), "", prop), prop);
        }
        return Token.startsWith(c, MIME_TEXT_PREFIX) ? Str.get(p) : new B64(p);
    }

    private static NodeCache extractParts(InputStream io, boolean statusOnly, ItemCache payloads, byte[] sep, Prop prop, InputInfo ii) throws IOException, QueryException {
        try {
            byte[] next = ResponseHandler.readLine(io);
            while (next != null && !Token.eq(sep, next)) {
                next = ResponseHandler.readLine(io);
            }
            if (next == null) {
                Err.REQINV.thrw(ii, "No body specified for http:part");
            }
            byte[] end = Token.concat(sep, Token.token("--"));
            FElem nextPart = ResponseHandler.extractNextPart(io, statusOnly, payloads, sep, end, prop, ii);
            NodeCache p = new NodeCache();
            while (nextPart != null) {
                p.add(nextPart);
                nextPart = ResponseHandler.extractNextPart(io, statusOnly, payloads, sep, end, prop, ii);
            }
            NodeCache nodeCache = p;
            return nodeCache;
        }
        finally {
            io.close();
        }
    }

    private static FElem extractNextPart(InputStream io, boolean statusOnly, ItemCache payloads, byte[] sep, byte[] end, Prop prop, InputInfo ii) throws IOException, QueryException {
        byte[] partContType = TXT_PLAIN;
        String charset = null;
        byte[] firstLine = ResponseHandler.readLine(io);
        if (firstLine == null || Token.eq(firstLine, end)) {
            return null;
        }
        FElem root = new FElem(new QNm(PART, Token.EMPTY), new Atts().add(QueryText.HTTP, QueryText.HTTPURI), Token.EMPTY);
        if (firstLine.length == 0) {
            byte[] p = ResponseHandler.extractPartPayload(io, sep, end, null);
            if (!statusOnly) {
                payloads.add(ResponseHandler.interpretPayload(p, partContType, prop, ii));
            }
        } else {
            byte[] nextHdr = firstLine;
            while (nextHdr != null && nextHdr.length > 0) {
                int pos;
                if (Token.startsWith(Token.lc(nextHdr), CONT_TYPE_LC)) {
                    charset = ResponseHandler.extractCharset(Token.string(nextHdr));
                }
                if ((pos = Token.indexOf(nextHdr, 58)) > 0) {
                    byte[] name = Token.substring(nextHdr, 0, pos);
                    if (pos + 1 < nextHdr.length) {
                        byte[] value = Token.trim(Token.substring(nextHdr, pos + 1, nextHdr.length));
                        FElem hdr = new FElem(new QNm(HEADER, QueryText.HTTPURI));
                        hdr.add(new FAttr(new QNm(HDR_NAME, Token.EMPTY), name));
                        hdr.add(new FAttr(new QNm(HDR_VALUE, Token.EMPTY), value));
                        root.add(hdr);
                        if (Token.eq(Token.lc(name), CONT_TYPE_LC)) {
                            partContType = value;
                        }
                    }
                }
                nextHdr = ResponseHandler.readLine(io);
            }
            byte[] p = ResponseHandler.extractPartPayload(io, sep, end, charset);
            if (!statusOnly) {
                payloads.add(ResponseHandler.interpretPayload(p, partContType, prop, ii));
            }
        }
        root.add(ResponseHandler.createBody(partContType));
        return root;
    }

    private static byte[] readLine(InputStream in) throws IOException {
        int b;
        TokenBuilder tb = new TokenBuilder();
        while ((b = in.read()) != -1) {
            if (b == 13) {
                int b2;
                while (true) {
                    if ((b2 = in.read()) == 10) {
                        return tb.finish();
                    }
                    if (b2 == -1) {
                        return tb.add(b).finish();
                    }
                    if (b2 != 13) break;
                    tb.add(b);
                }
                tb.add(b).add(b2);
                continue;
            }
            tb.add(b);
        }
        return tb.size() == 0 ? null : tb.finish();
    }

    private static byte[] extractPartPayload(InputStream io, byte[] sep, byte[] end, String cs) throws IOException {
        byte[] next;
        ByteList bl = new ByteList();
        while ((next = ResponseHandler.readLine(io)) != null && !Token.eq(next, sep)) {
            if (Token.eq(next, end)) {
                while (ResponseHandler.readLine(io) != null) {
                }
                break;
            }
            bl.add(next).add(10);
        }
        return TextInput.content(new IOContent(bl.toArray()), cs).finish();
    }

    private static byte[] extractContentType(String c) {
        if (c == null) {
            return OCT_STREAM;
        }
        int end = c.indexOf(59);
        return end == -1 ? Token.token(c) : Token.subtoken(Token.token(c), 0, end);
    }

    private static byte[] extractBoundary(String c, InputInfo info) throws QueryException {
        String b;
        int index = c.toLowerCase().lastIndexOf("boundary=");
        if (index == -1) {
            Err.REQINV.thrw(info, "No separation boundary specified");
        }
        if ((b = c.substring(index + 9)).charAt(0) == '\"') {
            index = b.lastIndexOf(34);
            b = b.substring(1, index);
        }
        return Token.token(b);
    }

    private static String extractCharset(String c) {
        if (c == null) {
            return null;
        }
        String cs = "charset=";
        int i = c.toLowerCase().lastIndexOf("charset=");
        return i == -1 ? null : c.substring(i + "charset=".length());
    }
}

