/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.json;

import org.basex.data.DataText;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.FAttr;
import org.basex.query.item.FElem;
import org.basex.query.item.FNode;
import org.basex.query.item.FTxt;
import org.basex.query.item.QNm;
import org.basex.query.util.Err;
import org.basex.query.util.json.JArray;
import org.basex.query.util.json.JObject;
import org.basex.query.util.json.JSONParser;
import org.basex.query.util.json.JString;
import org.basex.query.util.json.JStruct;
import org.basex.query.util.json.JValue;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjMap;

public final class JsonMLConverter {
    private final TokenObjMap<QNm> qnames = new TokenObjMap();
    private final InputInfo input;

    public JsonMLConverter(InputInfo ii) {
        this.input = ii;
    }

    public ANode parse(byte[] q) throws QueryException {
        JStruct node = new JSONParser(q, this.input).parse();
        return this.create(node);
    }

    private FElem create(JValue value) throws QueryException {
        return this.elem((JArray)this.check(value, DataText.ARR, "element constructor"));
    }

    private FElem elem(JArray value) throws QueryException {
        FNode elem = null;
        boolean txt = false;
        int s = 0;
        while (s < value.size()) {
            JValue val = value.value(s);
            if (s == 0) {
                JString str = (JString)this.check(val, DataText.STR, "element name");
                elem = new FElem(this.qname(str.value));
            } else if (s == 1 && val instanceof JObject) {
                this.attr((FElem)elem, (JObject)val);
            } else if (val instanceof JArray) {
                elem.add(this.elem((JArray)val));
                txt = false;
            } else if (val instanceof JString) {
                if (txt) {
                    this.error("No subsequent texts allowed", new Object[0]);
                }
                txt = true;
                elem.add(new FTxt(((JString)val).value));
            } else {
                this.error("No % allowed at this stage", new Object[]{val.type()});
            }
            ++s;
        }
        if (elem == null) {
            this.error("No element name specified in array", new Object[0]);
        }
        return elem;
    }

    private void attr(FElem elem, JObject attr) throws QueryException {
        int s = 0;
        while (s < attr.size()) {
            JString v = (JString)this.check(attr.value(s), DataText.STR, "attribute value");
            elem.add(new FAttr(this.qname(attr.name(s)), v.value));
            ++s;
        }
    }

    private QNm qname(byte[] name) throws QueryException {
        QNm qname = this.qnames.get(name);
        if (qname == null) {
            if (!XMLToken.isNCName(name)) {
                this.error("Invalid name: \"%\"", new Object[]{name});
            }
            qname = new QNm(name);
            this.qnames.add(name, qname);
        }
        return qname;
    }

    private JValue check(JValue val, byte[] type, String ext) throws QueryException {
        if (!Token.eq(val.type(), type)) {
            this.error("% expected for %, % found", type, ext, val.type());
        }
        return val;
    }

    private QueryException error(String msg, Object ... ext) throws QueryException {
        throw Err.JSONMLPARSE.thrw(this.input, new Object[]{Util.inf(msg, ext)});
    }
}

