/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.json;

import org.basex.query.QueryException;
import org.basex.query.item.Bln;
import org.basex.query.item.Dbl;
import org.basex.query.item.Empty;
import org.basex.query.item.Itr;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.util.json.JAtom;
import org.basex.query.util.json.JObject;
import org.basex.query.util.json.JSONParser;
import org.basex.query.util.json.JStruct;
import org.basex.query.util.json.JValue;
import org.basex.util.InputInfo;
import org.basex.util.list.TokenList;

public final class JsonMapConverter {
    private JsonMapConverter() {
    }

    public static Value parse(byte[] json, InputInfo ii) throws QueryException {
        return JsonMapConverter.convert(new JSONParser(json, ii).parse());
    }

    private static Value convert(JValue nd) throws QueryException {
        if (nd instanceof JAtom) {
            byte[] type = nd.type();
            byte[] val = ((JAtom)nd).value();
            switch (type[0]) {
                case 98: {
                    return Bln.get(val[0] == 116);
                }
                case 110: {
                    return type[2] == 109 ? Dbl.get(val, null) : Empty.SEQ;
                }
            }
            return Str.get(val);
        }
        Map map = Map.EMPTY;
        JStruct st = (JStruct)nd;
        TokenList names = st instanceof JObject ? ((JObject)st).names : null;
        int i = st.size();
        while (--i >= 0) {
            map = map.insert(names == null ? Itr.get(i + 1) : Str.get(names.get(i)), JsonMapConverter.convert(st.value(i)), null);
        }
        return map;
    }
}

