/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.QNm;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.PkgText;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class JarParser {
    private final Context context;
    private final InputInfo input;

    public JarParser(Context ctx, InputInfo ii) {
        this.context = ctx;
        this.input = ii;
    }

    public JarDesc parse(IO io) throws QueryException {
        JarDesc desc = new JarDesc();
        try {
            ANode next;
            ANode node = new DBNode(io, this.context.prop).children().next();
            AxisMoreIter ch = node.children();
            while ((next = ch.next()) != null) {
                QNm name = next.qname();
                if (JarParser.eqNS(PkgText.JAR, name)) {
                    desc.jars.add(next.atom());
                    continue;
                }
                if (!JarParser.eqNS(PkgText.CLASS, name)) continue;
                desc.classes.add(next.atom());
            }
            if (desc.jars.size() == 0) {
                Err.JARDESCINV.thrw(this.input, "No jars specified");
            } else if (desc.classes.size() == 0) {
                Err.JARDESCINV.thrw(this.input, "No public classes specified");
            }
            return desc;
        }
        catch (IOException ex) {
            throw Err.JARREADFAIL.thrw(this.input, ex.getMessage());
        }
    }

    private static boolean eqNS(byte[] cmp, QNm name) {
        return Token.eq(name.ln(), cmp) && Token.eq(name.uri().atom(), QueryText.PACKURI);
    }
}

