/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.util.pkg.Repo;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class PkgParser {
    private final Repo repo;
    private final InputInfo input;

    public PkgParser(Repo r, InputInfo ii) {
        this.repo = r;
        this.input = ii;
    }

    public Package parse(IO io) throws QueryException {
        Package pkg = new Package();
        try {
            DBNode doc = new DBNode(io, this.repo.context.prop);
            ANode node = this.childElements(doc).next();
            if (!PkgParser.eqNS(PkgText.PACKAGE, node.qname())) {
                Err.PKGDESCINV.thrw(this.input, Util.info("Invalid element %", node.qname()));
            }
            this.parseAttributes(node, pkg, PkgText.PACKAGE);
            this.parseChildren(node, pkg);
            return pkg;
        }
        catch (IOException ex) {
            throw Err.PKGREADFAIL.thrw(this.input, io.name(), ex.getMessage());
        }
    }

    private void parseAttributes(ANode node, Package p, byte[] root) throws QueryException {
        ANode next;
        AxisIter atts = node.attributes();
        while ((next = atts.next()) != null) {
            byte[] name = next.nname();
            if (Token.eq(PkgText.NAME, name)) {
                p.name = next.atom();
                continue;
            }
            if (Token.eq(PkgText.ABBREV, name)) {
                p.abbrev = next.atom();
                continue;
            }
            if (Token.eq(PkgText.VERSION, name)) {
                p.version = next.atom();
                continue;
            }
            if (Token.eq(PkgText.SPEC, name)) {
                p.spec = next.atom();
                continue;
            }
            Err.PKGDESCINV.thrw(this.input, Util.info("Invalid attribute '%'", new Object[]{name}));
        }
        if (p.name == null) {
            Err.PKGDESCINV.thrw(this.input, Util.info("'%' attribute missing in '%' element", PkgText.NAME, root));
        }
        if (p.version == null) {
            Err.PKGDESCINV.thrw(this.input, Util.info("'%' attribute missing in '%' element", PkgText.VERSION, root));
        }
        if (p.abbrev == null) {
            Err.PKGDESCINV.thrw(this.input, Util.info("'%' attribute missing in '%' element", PkgText.ABBREV, root));
        }
        if (p.spec == null) {
            Err.PKGDESCINV.thrw(this.input, Util.info("'%' attribute missing in '%' element", PkgText.SPEC, root));
        }
    }

    private void parseChildren(ANode node, Package p) throws QueryException {
        ANode next;
        AxisIter ch = this.childElements(node);
        while ((next = ch.next()) != null) {
            QNm name = next.qname();
            if (PkgParser.eqNS(PkgText.DEPEND, name)) {
                p.dep.add(this.parseDependency(next));
                continue;
            }
            if (!PkgParser.eqNS(PkgText.XQUERY, name)) continue;
            p.comps.add(this.parseComp(next));
        }
    }

    private Package.Dependency parseDependency(ANode node) throws QueryException {
        ANode next;
        AxisIter atts = node.attributes();
        Package.Dependency d = new Package.Dependency();
        while ((next = atts.next()) != null) {
            byte[] name = next.nname();
            if (Token.eq(PkgText.PKG, name)) {
                d.pkg = next.atom();
                continue;
            }
            if (Token.eq(PkgText.PROC, name)) {
                d.processor = next.atom();
                continue;
            }
            if (Token.eq(PkgText.VERS, name)) {
                d.versions = next.atom();
                continue;
            }
            if (Token.eq(PkgText.SEMVER, name)) {
                d.semver = next.atom();
                continue;
            }
            if (Token.eq(PkgText.SEMVERMIN, name)) {
                d.semverMin = next.atom();
                continue;
            }
            if (Token.eq(PkgText.SEMVERMAX, name)) {
                d.semverMax = next.atom();
                continue;
            }
            Err.PKGDESCINV.thrw(this.input, Util.info("Invalid attribute '%'", new Object[]{name}));
        }
        return d;
    }

    private Package.Component parseComp(ANode node) throws QueryException {
        ANode next;
        AxisIter ch = this.childElements(node);
        Package.Component c = new Package.Component();
        while ((next = ch.next()) != null) {
            QNm name = next.qname();
            if (PkgParser.eqNS(PkgText.NSPC, name)) {
                c.uri = next.atom();
                continue;
            }
            if (PkgParser.eqNS(PkgText.FILE, name)) {
                c.file = next.atom();
                continue;
            }
            Err.PKGDESCINV.thrw(this.input, Util.info("Invalid element %", name));
        }
        if (c.uri == null) {
            Err.PKGDESCINV.thrw(this.input, Util.info("Component '%' not specified", new Object[]{PkgText.NSPC}));
        }
        if (c.file == null) {
            Err.PKGDESCINV.thrw(this.input, Util.info("Component '%' not specified", new Object[]{PkgText.FILE}));
        }
        return c;
    }

    private AxisIter childElements(ANode node) {
        return new AxisIter(node){
            final AxisIter ch;
            {
                this.ch = aNode.children();
            }

            @Override
            public ANode next() {
                ANode n;
                while ((n = this.ch.next()) != null && n.type != NodeType.ELM) {
                }
                return n;
            }
        };
    }

    private static boolean eqNS(byte[] cmp, QNm name) {
        return Token.eq(name.ln(), cmp) && Token.eq(name.uri().atom(), QueryText.PKGURI);
    }
}

