/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.server.ClientSession;
import org.basex.server.Query;
import org.basex.server.ServerCmd;

public final class ClientQuery
extends Query {
    private final ClientSession cs;
    private final String id;

    public ClientQuery(String query, ClientSession session, OutputStream os) throws IOException {
        this.cs = session;
        this.id = this.exec(ServerCmd.QUERY, query, null);
        this.out = os;
    }

    @Override
    public String info() throws IOException {
        return this.exec(ServerCmd.INFO, this.id, null);
    }

    @Override
    public String options() throws IOException {
        return this.exec(ServerCmd.OPTIONS, this.id, null);
    }

    @Override
    public void bind(String n, Object v, String t) throws IOException {
        this.exec(ServerCmd.BIND, String.valueOf(this.id) + '\u0000' + n + '\u0000' + v + '\u0000' + (t == null ? "" : t), null);
    }

    @Override
    public String execute() throws IOException {
        return this.exec(ServerCmd.EXEC, this.id, this.out);
    }

    @Override
    public void close() throws IOException {
        this.exec(ServerCmd.CLOSE, this.id, null);
    }

    @Override
    protected void cache() throws IOException {
        this.cs.sout.write(ServerCmd.ITER.code);
        this.cs.send(this.id);
        this.cs.sout.flush();
        BufferInput bi = new BufferInput(this.cs.sin);
        this.cache(bi);
        if (!this.cs.ok(bi)) {
            throw new BaseXException(bi.readString(), new Object[0]);
        }
    }

    private String exec(ServerCmd cmd, String arg, OutputStream output) throws IOException {
        OutputStream os = output == null ? new ArrayOutput() : output;
        this.cs.sout.write(cmd.code);
        this.cs.send(arg);
        this.cs.sout.flush();
        BufferInput bi = new BufferInput(this.cs.sin);
        this.cs.receive(bi, os);
        if (!this.cs.ok(bi)) {
            throw new BaseXException(bi.readString(), new Object[0]);
        }
        return os.toString();
    }
}

