/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.basex.util.JarLoader;
import org.basex.util.Util;

public final class Reflect {
    private static HashMap<String, Constructor<?>> cons = new HashMap();
    private static HashMap<String, Class<?>> classes = new HashMap();
    private static HashMap<String, Field> fields = new HashMap();
    public static JarLoader jarLoader;

    private Reflect() {
    }

    public static boolean available(String pattern, Object ... ext) {
        try {
            Class.forName(Util.info(pattern, ext));
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static Class<?> find(String name) {
        Class<?> c = classes.get(name);
        try {
            if (c == null) {
                try {
                    c = Class.forName(name);
                    classes.put(name, c);
                    return c;
                }
                catch (ClassNotFoundException ex) {
                    if (jarLoader != null) {
                        c = Class.forName(name, true, jarLoader);
                        classes.put(name, c);
                    }
                    return c;
                }
            }
            return c;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field field(Class<?> clazz, String name) {
        String key = String.valueOf(clazz.getName()) + name;
        Field f = fields.get(key);
        if (f == null) {
            try {
                f = clazz.getField(name);
                fields.put(key, f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    public static Class<?> find(String pattern, Object ... ext) {
        return Reflect.find(Util.info(pattern, ext));
    }

    public static Class<?> find(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            Class<?> c = Reflect.find(n3);
            if (c != null) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static Constructor<?> find(Class<?> clazz, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(clazz.getName());
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            sb.append(c.getName());
            ++n2;
        }
        String key = sb.toString();
        Constructor<?> m = cons.get(key);
        if (m == null) {
            try {
                try {
                    m = clazz.getConstructor(types);
                }
                catch (Exception ex) {
                    m = clazz.getDeclaredConstructor(types);
                    m.setAccessible(true);
                }
                cons.put(key, m);
            }
            catch (Exception ex) {
                Util.debug(ex);
            }
        }
        return m;
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... types) {
        if (clazz == null) {
            return null;
        }
        Method m = null;
        try {
            try {
                m = clazz.getMethod(name, types);
            }
            catch (Exception ex) {
                m = clazz.getDeclaredMethod(name, types);
                m.setAccessible(true);
            }
        }
        catch (Exception ex) {
            Util.debug(ex);
        }
        return m;
    }

    public static Object get(Class<?> clazz) {
        try {
            return clazz != null ? clazz.newInstance() : null;
        }
        catch (Exception ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object get(Constructor<?> clazz, Object ... args) {
        try {
            return clazz != null ? clazz.newInstance(args) : null;
        }
        catch (Exception ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object invoke(Method method, Object object, Object ... args) {
        try {
            return method != null ? method.invoke(object, args) : null;
        }
        catch (Exception ex) {
            Util.debug(ex);
            return null;
        }
    }

    public static Object invoke(Object object, String method, Object ... args) throws Exception {
        if (object == null) {
            return null;
        }
        Class[] clz = new Class[args.length];
        int a = 0;
        while (a < args.length) {
            clz[a] = args[a].getClass();
            ++a;
        }
        Class<?> c = object.getClass();
        Method m = Reflect.method(c, method, clz);
        if (m == null) {
            int a2 = 0;
            while (a2 < args.length) {
                Class<?>[] ic = clz[a2].getInterfaces();
                if (ic.length != 0) {
                    clz[a2] = ic[0];
                }
                ++a2;
            }
            m = Reflect.method(c, method, clz);
            while (m == null) {
                boolean same = true;
                int a3 = 0;
                while (a3 < args.length) {
                    Class ic = clz[a3].getSuperclass();
                    if (ic != null && ic != Object.class) {
                        clz[a3] = ic;
                        same = false;
                    }
                    ++a3;
                }
                if (same) {
                    return null;
                }
                m = Reflect.method(c, method, clz);
            }
        }
        return m.invoke(object, args);
    }

    public static void setJarLoader(JarLoader l) {
        jarLoader = l;
    }
}

