/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Scanner;
import org.basex.core.Text;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Table {
    private static final int DIST = 2;
    public final TokenList header = new TokenList();
    public final BoolList align = new BoolList();
    public final ArrayList<TokenList> contents = new ArrayList();
    public String description;

    public Table() {
    }

    public Table(String in) {
        if (in.isEmpty()) {
            return;
        }
        Scanner scan = new Scanner(in);
        byte[] line = Token.token(scan.nextLine());
        IntList il = new IntList();
        int i = 0;
        while (i < line.length) {
            il.add(i);
            while (++i + 1 < line.length && (line[i] != 32 || line[i + 1] != 32)) {
            }
            this.header.add(Token.substring(line, il.get(il.size() - 1), i));
            while (++i < line.length && line[i] == 32) {
            }
        }
        il.add(i);
        scan.nextLine();
        int s = il.size() - 1;
        while ((line = Token.token(scan.nextLine())).length != 0) {
            TokenList entry = new TokenList();
            int e = 0;
            while (e < s) {
                entry.add(Token.trim(Token.substring(line, il.get(e), il.get(e + 1))));
                ++e;
            }
            this.contents.add(entry);
        }
    }

    public void sort() {
        Collections.sort(this.contents, new Comparator<TokenList>(){

            @Override
            public int compare(TokenList tl1, TokenList tl2) {
                return Token.diff(Token.lc(tl1.get(0)), Token.lc(tl2.get(0)));
            }
        });
    }

    public String value(int r, int c) {
        return Token.string(this.contents.get(r).get(c));
    }

    public int rows() {
        return this.contents.size();
    }

    public int cols() {
        return this.header.size();
    }

    public void toTop(byte[] top) {
        int i = 0;
        while (i < this.contents.size()) {
            if (Token.eq(top, this.contents.get(i).get(0))) {
                this.contents.add(0, this.contents.remove(i));
                return;
            }
            ++i;
        }
    }

    public byte[] finish() {
        int[] ind = new int[this.header.size()];
        int sz = this.header.size();
        int s = 0;
        while (s < sz) {
            for (TokenList e : this.contents) {
                ind[s] = Math.max(ind[s], e.get(s).length);
            }
            ind[s] = Math.max(ind[s], this.header.get(s).length);
            ++s;
        }
        TokenBuilder tb = new TokenBuilder();
        int u = 0;
        while (u < sz) {
            byte[] s2 = this.header.get(u);
            int is = ind[u] - s2.length + 2;
            tb.add(s2);
            int i = 0;
            while (i < is) {
                tb.add(32);
                ++i;
            }
            ++u;
        }
        tb.add(Text.NL);
        u = 0;
        while (u < sz) {
            int i = 0;
            while (i < ind[u] + (u + 1 == sz ? 0 : 2)) {
                tb.add(45);
                ++i;
            }
            ++u;
        }
        tb.add(Text.NL);
        for (TokenList e : this.contents) {
            int u2 = 0;
            while (u2 < sz) {
                int i;
                byte[] s3 = e.get(u2);
                int is = ind[u2] - s3.length;
                if (u2 < this.align.size() && this.align.get(u2)) {
                    i = 0;
                    while (i < is) {
                        tb.add(32);
                        ++i;
                    }
                    tb.add(s3);
                } else {
                    tb.add(s3);
                    i = 0;
                    while (i < is) {
                        tb.add(32);
                        ++i;
                    }
                }
                i = 0;
                while (i < 2) {
                    tb.add(32);
                    ++i;
                }
                ++u2;
            }
            tb.add(Text.NL);
        }
        if (this.description != null) {
            tb.add(Text.NL).add(String.valueOf(this.contents.size()) + " " + this.description + ".");
        }
        return tb.finish();
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        for (byte[] b : this.header) {
            tb.add(b);
            tb.add(9);
        }
        tb.add(Text.NL);
        for (TokenList e : this.contents) {
            for (byte[] b : e) {
                tb.add(b);
                tb.add(9);
            }
        }
        return tb.toString();
    }
}

