/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Arrays;
import java.util.Collection;
import org.basex.util.Token;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.InternalStemmer;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class EnglishStemmer
extends InternalStemmer {
    private static final byte[] AT = Token.token("at");
    private static final byte[] BL = Token.token("bl");
    private static final byte[] ED = Token.token("ed");
    private static final byte[] EED = Token.token("eed");
    private static final byte[] IES = Token.token("ies");
    private static final byte[] ING = Token.token("ing");
    private static final byte[] ION = Token.token("ion");
    private static final byte[] IZ = Token.token("iz");
    private static final byte[] LL = Token.token("ll");
    private static final byte[] SION = Token.token("sion");
    private static final byte[] SSES = Token.token("sses");
    private static final byte[] TION = Token.token("tion");
    private static final byte S = 115;
    private static final byte Y = 121;
    private static final byte E = 101;
    private static final byte L = 108;
    private static final byte[][][] ST2 = new byte[][][]{Token.tokens("abli", "able"), Token.tokens("alism", "al"), Token.tokens("aliti", "al"), Token.tokens("alli", "al"), Token.tokens("anci", "ance"), Token.tokens("ation", "ate"), Token.tokens("ational", "ate"), Token.tokens("ator", "ate"), Token.tokens("biliti", "ble"), Token.tokens("eli", "e"), Token.tokens("enci", "ence"), Token.tokens("entli", "ent"), Token.tokens("fulness", "ful"), Token.tokens("iveness", "ive"), Token.tokens("iviti", "ive"), Token.tokens("ization", "ize"), Token.tokens("ization", "ize"), Token.tokens("izer", "ize"), Token.tokens("izer", "ize"), Token.tokens("ousli", "ous"), Token.tokens("ousness", "ous"), Token.tokens("tional", "tion")};
    private static final byte[][][] ST3 = new byte[][][]{Token.tokens("alize", "al"), Token.tokens("alize", "al"), Token.tokens("ative", ""), Token.tokens("ful", ""), Token.tokens("ical", "ic"), Token.tokens("icate", "ic"), Token.tokens("iciti", "ic"), Token.tokens("ness", "")};
    private static final byte[][] ST4 = Token.tokens("able", "al", "ance", "ant", "ate", "ement", "ence", "ent", "er", "ible", "ic", "ism", "iti", "ive", "ize", "ment", "ou", "ous", "sion", "tion");
    private byte[] tok;
    private int te;
    private int tt;

    EnglishStemmer(FTIterator fti) {
        super(fti);
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new EnglishStemmer(fti);
    }

    @Override
    Collection<Language> languages() {
        return this.collection("en");
    }

    @Override
    protected byte[] stem(byte[] str) {
        this.te = str.length;
        this.tok = str;
        return !this.s() ? str : Arrays.copyOf(str, this.te);
    }

    private boolean s() {
        int m;
        if (this.te < 3) {
            return false;
        }
        if (this.e((byte)115)) {
            if (this.e(SSES) || this.e(IES)) {
                this.te -= 2;
            } else if (this.l(this.te - 2) != 115) {
                --this.te;
            }
        }
        if (this.e(EED)) {
            if (this.m() > 0) {
                --this.te;
            }
        } else if ((this.e(ED) || this.e(ING)) && this.v()) {
            this.te = this.tt;
            if (this.e(AT) || this.e(BL) || this.e(IZ)) {
                this.tt = this.te;
                this.a((byte)101);
            } else if (this.te > 1) {
                int c = this.l(this.te - 1);
                if (c == this.l(this.te - 2) && c != 108 && c != 115 && c != 122) {
                    --this.te;
                } else if (this.m() == 1 && this.c(this.te)) {
                    this.a((byte)101);
                }
            }
        }
        if (this.e((byte)121) && this.v()) {
            this.a((byte)105);
        }
        Object object = ST2;
        int n = ST2.length;
        int n2 = 0;
        while (n2 < n) {
            byte[][] s = object[n2];
            if (this.e(s[0])) {
                if (this.m() <= 0) break;
                this.a(s[1]);
                break;
            }
            ++n2;
        }
        object = ST3;
        n = ST3.length;
        n2 = 0;
        while (n2 < n) {
            byte[][] s = object[n2];
            if (this.e(s[0])) {
                if (this.m() <= 0) break;
                this.a(s[1]);
                break;
            }
            ++n2;
        }
        if ((this.e(TION) || this.e(SION)) && this.e(ION) && this.m() > 1) {
            this.te -= 3;
        } else {
            object = ST4;
            n = ST4.length;
            n2 = 0;
            while (n2 < n) {
                byte[][] s = object[n2];
                if (this.e((byte[])s)) {
                    if (this.m() <= 1) break;
                    this.te = this.tt;
                    break;
                }
                ++n2;
            }
        }
        if (this.e((byte)101) && ((m = this.m()) > 1 || m == 1 && !this.c(this.te - 1))) {
            --this.te;
        }
        if (this.e(LL) && this.e((byte)108) && this.m() > 1) {
            --this.te;
        }
        return this.te != this.tok.length;
    }

    private boolean c(int l) {
        if (l < 3) {
            return false;
        }
        int c = this.l(l - 1);
        return c != 119 && c != 120 && c != 121 && !this.v(l - 1) && this.v(l - 2) && !this.v(l - 3);
    }

    private boolean e(byte[] s) {
        int sl = s.length;
        int l = this.te - sl;
        if (l < 0) {
            return false;
        }
        int i = 0;
        while (i < sl) {
            if (this.l(l + i) != s[i]) {
                return false;
            }
            ++i;
        }
        this.tt = l;
        return true;
    }

    private boolean e(byte s) {
        int l = this.te - 1;
        if (l < 0 || this.l(l) != s) {
            return false;
        }
        this.tt = l;
        return true;
    }

    private int m() {
        int c = 0;
        int i = -1;
        boolean v = false;
        while (++i < this.tt) {
            if (!(v ^ this.v(i))) continue;
            if (v) {
                ++c;
            }
            v ^= true;
        }
        return c;
    }

    private boolean v() {
        int i = 0;
        while (i < this.tt) {
            if (this.v(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean v(int p) {
        int c = this.l(p);
        return c == 97 || c == 101 || c == 105 || c == 111 || c == 117 || c == 121 && p != 0 && !this.v(p - 1);
    }

    private int l(int p) {
        return Token.lc(this.tok[p]);
    }

    private void a(byte c) {
        this.te = this.tt;
        this.tok[this.te++] = c;
    }

    private void a(byte[] t) {
        this.te = this.tt;
        byte[] byArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            this.tok[this.te++] = c;
            ++n2;
        }
    }
}

