/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Map;
import java.util.TreeMap;
import org.basex.index.IndexToken;
import org.basex.util.Token;
import org.basex.util.ft.DictionaryStemmer;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTSpan;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.StringList;

public final class FTLexer
extends FTIterator
implements IndexToken {
    private final Tokenizer tok;
    private final FTOpt fto;
    private byte[] text = Token.EMPTY;
    private FTIterator iter;
    private FTSpan curr;
    private byte[] ctxt;

    public FTLexer() {
        this(null);
    }

    public FTLexer(FTOpt opt) {
        Language lang;
        this.fto = opt;
        Language language = lang = opt != null ? opt.ln : null;
        if (lang == null) {
            lang = Language.def();
        }
        Tokenizer tk = Tokenizer.IMPL.getFirst();
        for (Tokenizer t : Tokenizer.IMPL) {
            if (!t.supports(lang)) continue;
            tk = t;
            break;
        }
        this.tok = tk.get(opt);
        this.iter = this.tok;
        if (opt != null && opt.is(FTFlag.ST)) {
            if (opt.sd == null) {
                Stemmer st = Stemmer.IMPL.getFirst();
                for (Stemmer stem : Stemmer.IMPL) {
                    if (!stem.supports(lang)) continue;
                    st = stem;
                    break;
                }
                this.iter = st.get(lang, this.iter);
            } else {
                this.iter = new DictionaryStemmer(opt.sd, this.iter);
            }
        }
    }

    public FTLexer sc() {
        this.tok.special = true;
        return this;
    }

    public void init() {
        this.init(this.text);
    }

    @Override
    public FTLexer init(byte[] txt) {
        this.text = txt;
        this.iter.init(txt);
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public FTSpan next() {
        this.curr = (FTSpan)this.iter.next();
        return this.curr;
    }

    @Override
    public byte[] nextToken() {
        this.ctxt = this.iter.nextToken();
        return this.ctxt;
    }

    public int count() {
        this.init();
        int c = 0;
        while (this.hasNext()) {
            this.nextToken();
            ++c;
        }
        return c;
    }

    @Override
    public IndexToken.IndexType type() {
        return IndexToken.IndexType.FULLTEXT;
    }

    @Override
    public byte[] get() {
        return this.ctxt != null ? this.ctxt : this.curr.text;
    }

    public FTOpt ftOpt() {
        return this.fto;
    }

    public byte[] text() {
        return this.text;
    }

    public boolean paragraph() {
        return this.tok.paragraph();
    }

    public int pos(int w, FTUnit u) {
        return this.tok.pos(w, u);
    }

    public int[][] info() {
        return this.tok.info();
    }

    public static StringList languages() {
        TreeMap<Language, Stemmer> langs = new TreeMap<Language, Stemmer>();
        for (Stemmer stem : Stemmer.IMPL) {
            for (Language l : stem.languages()) {
                if (langs.containsKey(l)) continue;
                for (Tokenizer t : Tokenizer.IMPL) {
                    if (!t.languages().contains(l)) continue;
                    langs.put(l, stem);
                }
            }
        }
        StringList sl = new StringList();
        for (Map.Entry l : langs.entrySet()) {
            sl.add(l.getKey() + " (" + l.getValue() + ")");
        }
        sl.sort(true, true);
        return sl;
    }
}

