/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.basex.core.Prop;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTSpan;
import org.basex.util.ft.Language;
import org.basex.util.ft.Tokenizer;

class JapaneseTokenizer
extends Tokenizer {
    private static boolean available = true;
    private static final String PATTERN = "net.reduls.igo.Tagger";
    private static final String LANG = "ja";
    private static final int HINSHI_MARK = 1;
    private static final int HINSHI_OTHERS = 0;
    private static Constructor<?> tgr;
    private static Object tagger;
    private static Method parse;
    private static Field surface;
    private static Field feature;
    private static Field start;
    private Iterator<Morpheme> tokens;
    private final boolean cs;
    private final boolean uc;
    private final boolean lc;
    private int pos = -1;

    static {
        File dic = null;
        if (!Reflect.available(PATTERN, new Object[0])) {
            available = false;
        } else {
            dic = new File(LANG);
            if (!dic.exists() && !(dic = new File(Prop.HOME, "etc/ja")).exists()) {
                available = false;
            }
        }
        if (available) {
            Class<?> clz = Reflect.find(PATTERN);
            if (clz == null) {
                Util.errln("Could not initialize Igo Japanese lexer.", new Object[0]);
            } else {
                tgr = Reflect.find(clz, String.class);
                tagger = Reflect.get(tgr, dic.toString());
                if (tagger == null) {
                    available = false;
                    Util.errln("Could not initialize Igo Japanese lexer.", new Object[0]);
                } else {
                    parse = Reflect.method(clz, "parse", CharSequence.class);
                    if (parse == null) {
                        Util.errln("Could not initialize Igo lexer method.", new Object[0]);
                    }
                    clz = Reflect.find("net.reduls.igo.Morpheme");
                    surface = Reflect.field(clz, "surface");
                    feature = Reflect.field(clz, "feature");
                    start = Reflect.field(clz, "start");
                }
            }
        }
    }

    static boolean available() {
        return available;
    }

    JapaneseTokenizer(FTOpt fto) {
        this.lc = fto != null && fto.is(FTFlag.LC);
        this.uc = fto != null && fto.is(FTFlag.UC);
        this.cs = fto != null && fto.is(FTFlag.CS);
    }

    @Override
    Tokenizer get(FTOpt f) {
        return new JapaneseTokenizer(f);
    }

    @Override
    public JapaneseTokenizer init(byte[] txt) {
        String source = Token.string(txt);
        ArrayList morpheme = (ArrayList)Reflect.invoke(parse, tagger, source);
        ArrayList<Morpheme> list = new ArrayList<Morpheme>();
        try {
            int prev = 0;
            int i = 0;
            while (i < morpheme.size()) {
                int l;
                Object m = morpheme.get(i);
                String srfc = surface.get(m).toString();
                String ftr = feature.get(m).toString();
                int hinshi = JapaneseTokenizer.getHinshi(srfc, ftr);
                int s = start.getInt(m);
                if (i != 0 && (l = s - prev) != 0) {
                    list.add(new Morpheme(source.substring(s - 1, s + l - 1), 1));
                }
                prev = srfc.length() + s;
                list.add(new Morpheme(srfc, hinshi));
                ++i;
            }
        }
        catch (Exception ex) {
            Util.errln(String.valueOf(Util.name(this)) + ": " + ex, new Object[0]);
        }
        this.tokens = list.iterator();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.tokens.hasNext();
    }

    @Override
    public FTSpan next() {
        return new FTSpan(this.nextToken(), this.pos, false);
    }

    @Override
    public byte[] nextToken() {
        Morpheme m = this.tokens.next();
        String n = m.mSurface;
        ++this.pos;
        if (this.special) {
            return Token.token(n);
        }
        if (m.mHinshi == 1) {
            return Token.EMPTY;
        }
        if (this.uc) {
            n = n.toUpperCase();
        }
        if (this.lc || !this.cs) {
            n = n.toLowerCase();
        }
        return JapaneseTokenizer.toHankaku(Token.token(n));
    }

    @Override
    protected byte prec() {
        return 20;
    }

    @Override
    Collection<Language> languages() {
        return this.collection(LANG);
    }

    private static int getHinshi(String srfc, String ftr) {
        String[] parts;
        int hinshi = 0;
        byte[] s = Token.token(srfc);
        hinshi = s.length == 1 && !Token.letter(s[0]) && !Token.digit(s[0]) ? 1 : ((parts = ftr.split(","))[0].equals("\u8a18\u53f7") ? 1 : 0);
        return hinshi;
    }

    private static byte[] toHankaku(byte[] s) {
        if (Token.ascii(s)) {
            return s;
        }
        TokenBuilder tb = new TokenBuilder(s.length);
        int p = 0;
        while (p < s.length) {
            int c = Token.cp(s, p);
            if (c >= 65296 && c <= 65305 || c >= 65313 && c <= 65338 || c >= 65345 && c <= 65370) {
                tb.add(c - 65248);
            } else if (c == 12288) {
                tb.add(32);
            } else if (c == 65281) {
                tb.add(33);
            } else if (c == 8221) {
                tb.add(34);
            } else if (c == 65283) {
                tb.add(35);
            } else if (c == 65284) {
                tb.add(36);
            } else if (c == 65285) {
                tb.add(37);
            } else if (c == 65286) {
                tb.add(38);
            } else if (c == 8217) {
                tb.add(39);
            } else if (c == 65288) {
                tb.add(40);
            } else if (c == 65289) {
                tb.add(41);
            } else if (c == 65290) {
                tb.add(42);
            } else if (c == 65291) {
                tb.add(43);
            } else if (c == 65292) {
                tb.add(44);
            } else if (c == 65293) {
                tb.add(45);
            } else if (c == 65294) {
                tb.add(46);
            } else if (c == 65295) {
                tb.add(47);
            } else if (c == 65306) {
                tb.add(58);
            } else if (c == 65307) {
                tb.add(59);
            } else if (c == 65308) {
                tb.add(60);
            } else if (c == 65309) {
                tb.add(61);
            } else if (c == 65310) {
                tb.add(62);
            } else if (c == 65311) {
                tb.add(63);
            } else if (c == 65312) {
                tb.add(64);
            } else if (c == 65339) {
                tb.add(91);
            } else if (c == 65509) {
                tb.add(92);
            } else if (c == 65341) {
                tb.add(93);
            } else if (c == 65342) {
                tb.add(94);
            } else if (c == 65343) {
                tb.add(95);
            } else if (c == 65344) {
                tb.add(96);
            } else if (c == 65371) {
                tb.add(123);
            } else if (c == 65372) {
                tb.add(124);
            } else if (c == 65373) {
                tb.add(125);
            } else if (c == 65374) {
                tb.add(126);
            } else {
                tb.add(c);
            }
            p += Token.cl(s, p);
        }
        return tb.finish();
    }

    private static class Morpheme {
        final String mSurface;
        final int mHinshi;

        Morpheme(String srfc, int hinshi) {
            this.mSurface = srfc;
            this.mHinshi = hinshi;
        }
    }
}

