/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

public final class Scoring {
    private static final int MP = 1000;
    private static final double LOG = 1.718281828459045;
    private static final double SCORESTEP = 0.8;

    private Scoring() {
    }

    public static double word(int tl, double l) {
        return StrictMath.min(1.0, StrictMath.log(1.0 + 1.718281828459045 * (double)tl / l));
    }

    public static double and(double o, double n) {
        return 1.0 - (1.0 - o) * (1.0 - n);
    }

    public static double or(double o, double n) {
        return Scoring.and(o, n);
    }

    public static double not(double d) {
        return 1.0 - d;
    }

    public static double let(double s, int c) {
        return s / (double)c;
    }

    public static int tfIDF(double freq, double mfreq, double docs, double tokens) {
        return (int)StrictMath.max(2.0, 1000.0 * freq / mfreq * StrictMath.log(1.0 + docs / tokens));
    }

    public static double textNode(int npv, int is, int tokl, int tl) {
        return StrictMath.max((double)npv / (double)is, StrictMath.log(tokl * npv + 1) / StrictMath.log(tl + 1));
    }

    public static double intersect(double w1, double w2) {
        return (w1 + w2) / 2.0;
    }

    public static double union(double w1, double w2) {
        return StrictMath.max(w1, w2);
    }

    public static double step(double sc) {
        return sc * 0.8;
    }
}

