/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collections;
import java.util.LinkedList;
import org.basex.util.Util;
import org.basex.util.ft.DummyStemmer;
import org.basex.util.ft.EnglishStemmer;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTSpan;
import org.basex.util.ft.GermanStemmer;
import org.basex.util.ft.Language;
import org.basex.util.ft.LanguageImpl;
import org.basex.util.ft.LuceneStemmer;
import org.basex.util.ft.SnowballStemmer;
import org.basex.util.ft.WordnetStemmer;

public abstract class Stemmer
extends LanguageImpl {
    static final LinkedList<Stemmer> IMPL = new LinkedList();
    private final FTIterator iter;

    static {
        IMPL.add(new EnglishStemmer(null));
        IMPL.add(new GermanStemmer(null));
        IMPL.add(new DummyStemmer(null));
        if (SnowballStemmer.available()) {
            IMPL.add(new SnowballStemmer());
        }
        if (LuceneStemmer.available()) {
            IMPL.add(new LuceneStemmer());
        }
        if (WordnetStemmer.available()) {
            IMPL.add(new WordnetStemmer());
        }
        Collections.sort(IMPL);
    }

    protected Stemmer() {
        this(null);
    }

    protected Stemmer(FTIterator ft) {
        this.iter = ft;
    }

    public static boolean supportFor(Language l) {
        for (Stemmer s : IMPL) {
            if (!s.supports(l)) continue;
            return true;
        }
        return false;
    }

    abstract Stemmer get(Language var1, FTIterator var2);

    protected abstract byte[] stem(byte[] var1);

    @Override
    public final Stemmer init(byte[] txt) {
        this.iter.init(txt);
        return this;
    }

    @Override
    public final boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public final FTSpan next() {
        FTSpan s = (FTSpan)this.iter.next();
        s.text = this.stem(s.text);
        return s;
    }

    @Override
    public final byte[] nextToken() {
        return this.stem(this.iter.nextToken());
    }

    public String toString() {
        return Util.name(this).replace("Stemmer", "");
    }
}

