/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTSpan;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.IntList;

public final class WesternTokenizer
extends Tokenizer {
    private static final HashSet<Language> SUPPORTED = new HashSet();
    private final IntList sen = new IntList();
    private final IntList par = new IntList();
    private final boolean dc;
    private final boolean cs;
    private final boolean uc;
    private final boolean lc;
    private final boolean wc;
    private boolean pa;
    private byte[] text = Token.EMPTY;
    private int sent;
    private int para;
    private int pm;
    private int lp;
    private int spos;
    private int pos = -1;
    private int cpos;
    private boolean sc;
    private int next;

    static {
        String[] nonw = new String[]{"ar", "ja", "ko", "th", "zh"};
        for (Language l : Language.ALL.values()) {
            if (Token.eq(l.code(), nonw)) continue;
            SUPPORTED.add(l);
        }
    }

    public WesternTokenizer(FTOpt f) {
        this.lc = f != null && f.is(FTFlag.LC);
        this.uc = f != null && f.is(FTFlag.UC);
        this.cs = f != null && f.is(FTFlag.CS);
        this.wc = f != null && f.is(FTFlag.WC);
        this.dc = f != null && f.is(FTFlag.DC);
    }

    @Override
    Collection<Language> languages() {
        return SUPPORTED;
    }

    @Override
    Tokenizer get(FTOpt f) {
        return new WesternTokenizer(f);
    }

    @Override
    public WesternTokenizer init(byte[] txt) {
        if (this.text != txt) {
            this.text = txt;
            this.sen.reset();
            this.par.reset();
        }
        this.init();
        return this;
    }

    private void init() {
        this.sent = 0;
        this.para = 0;
        this.pos = -1;
        this.cpos = 0;
        this.next = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.next <= 0 && (this.special ? this.moreSC() : this.more())) {
            ++this.next;
        }
        return this.next > 0;
    }

    @Override
    public FTSpan next() {
        return new FTSpan(this.nextToken(), this.pos, this.sc);
    }

    @Override
    public byte[] nextToken() {
        if (--this.next < 0) {
            this.hasNext();
        }
        return this.special ? this.getSC() : this.get();
    }

    /*
     * Exception decompiling
     */
    private boolean more() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] get() {
        byte[] n = this.orig();
        boolean a = Token.ascii(n);
        if (!a && !this.dc) {
            n = WesternTokenizer.dia(n);
        }
        if (this.uc) {
            n = WesternTokenizer.upper(n, a);
        }
        if (this.lc || !this.cs) {
            n = WesternTokenizer.lower(n, a);
        }
        return n;
    }

    private byte[] orig() {
        int l = this.cpos - this.spos;
        byte[] copy = new byte[l];
        System.arraycopy(this.text, this.spos, copy, 0, l);
        return copy;
    }

    /*
     * Unable to fully structure code
     */
    private boolean moreSC() {
        l = this.text.length;
        this.pa = false;
        this.sc = false;
        this.lp = this.cpos;
        while (this.cpos < l) {
            c = Token.cp(this.text, this.cpos);
            if (c == 10) {
                this.pa = true;
                ++this.cpos;
                this.sc = true;
                break;
            }
            if (Token.ftChar(c)) break;
            this.sc = true;
            this.cpos += Token.cl(this.text, this.cpos);
        }
        if (this.lp < this.cpos) {
            return true;
        }
        ++this.pos;
        this.spos = this.cpos;
        if (this.cpos != l) ** GOTO lbl27
        return false;
lbl-1000:
        // 1 sources

        {
            c = Token.cp(this.text, this.cpos);
            if (!Token.ftChar(c)) {
                this.spos = this.cpos - Token.cl(this.text, this.cpos);
                break;
            }
            this.cpos += Token.cl(this.text, this.cpos);
lbl27:
            // 2 sources

            ** while (this.cpos < l)
        }
lbl28:
        // 2 sources

        return true;
    }

    private byte[] getSC() {
        return this.lp < this.cpos ? Arrays.copyOfRange(this.text, this.lp, this.cpos) : Arrays.copyOfRange(this.text, this.cpos, this.spos);
    }

    @Override
    int pos(int w, FTUnit u) {
        IntList il;
        if (u == FTUnit.WORD) {
            return w;
        }
        IntList intList = il = u == FTUnit.SENTENCE ? this.sen : this.par;
        if (this.sen.size() == 0) {
            this.init();
            while (this.more()) {
                this.sen.add(this.sent);
                this.par.add(this.para);
            }
        }
        return il.get(w);
    }

    private static byte[] dia(byte[] t) {
        int tl = t.length;
        int i = 0;
        while (i < tl) {
            int c = Token.cp(t, i);
            if (c != Token.norm(c)) {
                TokenBuilder tb = new TokenBuilder();
                tb.add(t, 0, i);
                int j = i;
                while (j < tl) {
                    tb.add(Token.norm(Token.cp(t, j)));
                    j += Token.cl(t, j);
                }
                return tb.finish();
            }
            i += Token.cl(t, i);
        }
        return t;
    }

    private static byte[] upper(byte[] t, boolean a) {
        int tl = t.length;
        if (a) {
            int i = 0;
            while (i < tl) {
                t[i] = (byte)Token.uc(t[i]);
                ++i;
            }
            return t;
        }
        TokenBuilder tb = new TokenBuilder();
        int i = 0;
        while (i < tl) {
            tb.add(Token.uc(Token.cp(t, i)));
            i += Token.cl(t, i);
        }
        return tb.finish();
    }

    private static byte[] lower(byte[] t, boolean a) {
        int tl = t.length;
        if (a) {
            int i = 0;
            while (i < tl) {
                t[i] = (byte)Token.lc(t[i]);
                ++i;
            }
            return t;
        }
        TokenBuilder tb = new TokenBuilder();
        int i = 0;
        while (i < tl) {
            tb.add(Token.lc(Token.cp(t, i)));
            i += Token.cl(t, i);
        }
        return tb.finish();
    }

    @Override
    int[][] info() {
        this.init();
        IntList[] il = new IntList[]{new IntList(), new IntList(), new IntList(), new IntList(), new IntList()};
        int lass = 0;
        int lasp = 0;
        int sl = 0;
        int pl = 0;
        while (this.more()) {
            byte[] n = this.orig();
            int l = n.length;
            il[0].add(l);
            byte[] byArray = n;
            int n2 = n.length;
            int n3 = 0;
            while (n3 < n2) {
                byte b = byArray[n3];
                il[3].add(b);
                ++n3;
            }
            if (this.sent != lass) {
                if (sl > 0) {
                    il[1].add(sl);
                    il[4].add(this.pm);
                }
                lass = this.sent;
                sl = 0;
            }
            if (this.para != lasp) {
                if (pl > 0) {
                    il[2].add(pl);
                }
                lasp = this.para;
                pl = 0;
            }
            sl += l;
            pl += l;
        }
        if (this.sent != lass && sl > 0) {
            il[1].add(sl);
            il[4].add(this.pm);
        }
        if (pl > 0) {
            il[2].add(pl);
        }
        il[1].add(sl + 1);
        return new int[][]{il[0].toArray(), il[1].toArray(), il[2].toArray(), il[3].toArray(), il[4].toArray()};
    }

    @Override
    protected byte prec() {
        return 10;
    }

    @Override
    boolean paragraph() {
        return this.pa;
    }

    public String toString() {
        return String.valueOf(Util.name(this)) + '[' + Token.string(this.text) + ']';
    }
}

